/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jdbcgateway;

import com.intersystems.gateway.JavaGateway;
import com.intersystems.jdbc.BufferRO;
import com.intersystems.jdbc.BufferWrite;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.LogFileStream;
import com.intersystems.jdbcgateway.JDBCGateway;
import java.sql.ResultSet;
import java.util.ArrayList;

public class JDBCGatewayHelper {
    private static final int GET_ERROR_TEXT = 1;
    private static final int GET_STRING = 2;
    private static final int SET_STRING = 3;
    private static final int SET_VALUE = 4;
    private static final int REGISTER_OUT_PARAMETER = 5;
    private static final int WAS_ERROR = 6;
    private static final int NEXT = 7;
    private static final int C_NEXT = 8;
    private static final int C_GET_STRING = 9;
    private static final int EXEC_UPDATE = 10;
    private static final int CONNECT = 11;
    private static final int CONNECT_WITH_PROP_STRING = 12;
    private static final int EXEC_QUERY = 13;
    private static final int GET_TABLES = 14;
    private static final int GET_COLUMNS = 15;
    private static final int GET_PRIMARY_KEYS = 16;
    private static final int GET_PROCEDURE_COLUMNS = 17;
    private static final int GET_PROCEDURES = 18;
    private static final int COLUMN_COUNT = 19;
    private static final int GET_COLUMN_TYPE = 20;
    private static final int GET_PRECISION = 21;
    private static final int GET_SCALE = 22;
    private static final int GET_COLUMN_NAME = 23;
    private static final int COLUMN_TYPE_NAME = 24;
    private static final int REMOVE_STATEMENT = 25;
    private static final int REMOVE_RESULT_SET = 26;
    private static final int CLOSE_ALL = 27;
    private static final int REMOVE_CONNECTION = 28;
    private static final int SET_AUTO_COMMIT = 29;
    private static final int COMMIT = 30;
    private static final int ROLLBACK = 31;
    private static final int GET_COLUMN_COUNT = 32;
    private static final int PREPARE_STATEMENT = 33;
    private static final int PREPARE_CALL = 34;
    private static final int GET_N_ROWS = 35;
    private static final int GET_ROWS = 36;
    private static final int SET_VALUES = 37;
    private static final int GET_UPDATE_COUNT = 38;
    private static final int GET_RESULT_SET = 39;
    private static final int GET_MORE_RESULTS = 40;
    private static final int EXECUTE = 41;
    private static final int STGETSTRING = 42;
    private static final int IS_CURRENCY = 43;
    private static final int GET_COLUMN_TYPE_NAME = 44;
    private static final int IS_NULLABLE = 45;
    private static final int GET_COLUMN_DISPLAY_SIZE = 46;
    private static final int IS_AUTOINCREMENT = 47;
    private static final int IS_CASESENSITIVE = 48;
    private static final int IS_READONLY = 49;
    private static final int STGETTIME = 50;
    private static final int STGETTIMESTAMP = 51;
    private static final int STGETDATE = 52;
    private static final int GET_ARG_RS = 53;
    private static final int GET_DB_NAME = 54;
    private static final int IS_XA = 55;
    private static final int SET_XA_MODE = 56;
    private static final int CONNECT_XA = 57;
    private static final int ROLLBACK_XA = 58;
    private static final int COMMIT_XA = 59;
    private static final int CGET_BLOB = 60;
    private static final int CGETBLOB_BYTES = 61;
    private static final int CGET_CLOB = 62;
    private static final int CGET_CLOB_SUBSTR = 63;
    private static final int REMOVE_LOB = 64;
    private static final int GET_BLOB = 65;
    private static final int GETBLOB_BYTES = 66;
    private static final int GET_CLOB = 67;
    private static final int GET_CLOB_SUBSTR = 68;
    private static final int INIT_STR_CONT = 69;
    private static final int SET_BINARY_STREAM = 70;
    private static final int SET_CHARACTER_STREAM = 71;
    private static final int ADD_BYTE = 72;
    private static final int ADD_STRING = 73;
    private static final int RM_STR_CONT = 74;
    private static final int GET_PARAMETER_COUNT = 75;
    private static final int GET_PARAMETER_CLASS_NAME = 76;
    private static final int GET_PARAMETER_TYPE_NAME = 77;
    private static final int GET_PARAMETER_MODE = 78;
    private static final int GET_PARAMETER_TYPE = 79;
    private static final int GET_PARAMETER_PRECISION = 80;
    private static final int GET_PARAMETER_SCALE = 81;
    private static final int IS_PARAMETER_NULLABLE = 82;
    private static final int IS_PARAMETER_SIGNED = 83;
    private static final int GET_INDEX_INFO = 84;
    private static final int GET_CROSSREFERENCE = 85;
    private static final int GET_EXPORTED_KEYS = 86;
    private static final int GET_IMPORTED_KEYS = 87;
    private static final int GET_ARGBLOB = 88;
    private static final int GET_ARGCLOB = 89;
    private static final int REMOVE_ARGLOB = 90;
    private static final int GET_ARGBLOB_BYTES = 91;
    private static final int GET_ARGCLOB_SUBSTR = 92;
    private static final int SET_VALUE_DIRECT = 93;
    private static final int PREPARE_STATEMENT_GK = 94;
    private static final int GET_GENERATED_KEYS = 95;
    private static final int GET_QUOTE_STRING = 96;
    private static final int GET_BINARY = 97;
    private static final int STGET_BINARY = 98;
    private static final int IS_VALID = 99;
    private static final int GET_QUERY_TIMEOUT = 100;
    private static final int SET_QUERY_TIMEOUT = 101;
    private static final int EXECUTE_PARAM_BATCH = 102;
    private static final int GET_PREPARED_STATEMENT_METADATA = 103;
    private static final int TEST = 1000;

    public static void processMessage(JDBCGateway jdbcGateway, BufferRO inWire, BufferWrite outWire, LogFileStream logFile) throws Exception {
        LogFileStream.log(logFile, " >> MESSAGE: ");
        int messageId = inWire.getInt();
        LogFileStream.log(logFile, "  msgId: " + messageId);
        outWire.writeHeader(JavaGateway.MESSAGE_JDBC_GATEWAY);
        switch (messageId) {
            case 1: {
                outWire.set(jdbcGateway.getErrorText());
                break;
            }
            case 2: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getString(ip1, ip2));
                break;
            }
            case 97: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getBinary(ip1, ip2));
                break;
            }
            case 98: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.stgetBinary(ip1, ip2));
                break;
            }
            case 42: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.stgetString(ip1, ip2));
                break;
            }
            case 50: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.stgetTime(ip1, ip2));
                break;
            }
            case 51: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.stgetTimestamp(ip1, ip2));
                break;
            }
            case 53: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getArgResultSet(ip1, ip2));
                break;
            }
            case 52: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.stgetDate(ip1, ip2));
                break;
            }
            case 3: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                String sp1 = inWire.getString();
                outWire.set(jdbcGateway.setString(ip1, ip2, sp1));
                break;
            }
            case 4: {
                int rc = 0;
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int offset = inWire.getOffsetThenNext();
                int ip3 = inWire.getInt();
                inWire.jump(offset);
                if (ip3 == -2 || ip3 == -3) {
                    byte[] ba1 = inWire.getByteArray();
                    rc = jdbcGateway.setValueBinary(ip1, ip2, ba1);
                } else {
                    String sp1 = inWire.getString();
                    rc = jdbcGateway.setValue(ip1, ip2, sp1, ip3);
                }
                outWire.set(rc);
                break;
            }
            case 93: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                String sp1 = inWire.getString();
                int ip3 = inWire.getInt();
                outWire.set(jdbcGateway.setValueDirect(ip1, ip2, sp1, ip3));
                break;
            }
            case 75: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterCount(ip1));
                break;
            }
            case 76: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterClassName(ip1, ip2));
                break;
            }
            case 77: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterTypeName(ip1, ip2));
                break;
            }
            case 78: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterMode(ip1, ip2));
                break;
            }
            case 79: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterType(ip1, ip2));
                break;
            }
            case 80: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterPrecision(ip1, ip2));
                break;
            }
            case 81: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getParameterScale(ip1, ip2));
                break;
            }
            case 82: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isParameterNullable(ip1, ip2));
                break;
            }
            case 83: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isParameterSigned(ip1, ip2));
                break;
            }
            case 5: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                outWire.set(jdbcGateway.registerOutParameter(ip1, ip2, ip3));
                break;
            }
            case 6: {
                outWire.set(jdbcGateway.wasError());
                break;
            }
            case 96: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getIdentifierQuoteString(ip1));
                break;
            }
            case 54: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getDatabaseProductName(ip1));
                break;
            }
            case 7: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.next(ip1));
                break;
            }
            case 8: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.cnext(ip1));
                break;
            }
            case 9: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.cgetString(ip1, ip2));
                break;
            }
            case 69: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.initStrCont(ip1));
                break;
            }
            case 70: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.setBinaryStream(ip1, ip2));
                break;
            }
            case 71: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.setCharacterStream(ip1, ip2));
                break;
            }
            case 72: {
                int ip1 = inWire.getInt();
                byte[] sb1 = inWire.getByteArray();
                outWire.set(jdbcGateway.addBytes(ip1, sb1));
                break;
            }
            case 73: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                outWire.set(jdbcGateway.addString(ip1, sp1));
                break;
            }
            case 74: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.rmStrCont(ip1));
                break;
            }
            case 64: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.removeLOB(ip1, ip2));
                break;
            }
            case 90: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.removeArgLOB(ip1, ip2));
                break;
            }
            case 60: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.cgetBLOB(ip1, ip2));
                break;
            }
            case 62: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.cgetCLOB(ip1, ip2));
                break;
            }
            case 61: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.cgetBLOBBytes(ip1, ip2, ip3, ip4));
                break;
            }
            case 63: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.cgetCLOBSubstr(ip1, ip2, ip3, ip4));
                break;
            }
            case 65: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getBLOB(ip1, ip2));
                break;
            }
            case 67: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getCLOB(ip1, ip2));
                break;
            }
            case 88: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getArgBLOB(ip1, ip2));
                break;
            }
            case 89: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getArgCLOB(ip1, ip2));
                break;
            }
            case 66: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.getBLOBBytes(ip1, ip2, ip3, ip4));
                break;
            }
            case 68: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.getCLOBSubstr(ip1, ip2, ip3, ip4));
                break;
            }
            case 91: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.getArgBLOBBytes(ip1, ip2, ip3, ip4));
                break;
            }
            case 92: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                int ip3 = inWire.getInt();
                int ip4 = inWire.getInt();
                outWire.set(jdbcGateway.getArgCLOBSubstr(ip1, ip2, ip3, ip4));
                break;
            }
            case 10: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.execUpdate(ip1));
                break;
            }
            case 38: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getUpdateCount(ip1));
                break;
            }
            case 57: {
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                outWire.set(jdbcGateway.connectXA(sp1, sp2));
                break;
            }
            case 11: {
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                if (inWire.isEnd()) {
                    outWire.set(jdbcGateway.connect(null, sp1, sp2, sp3));
                    break;
                }
                String sp4 = inWire.getString();
                outWire.set(jdbcGateway.connect(sp1, sp2, sp3, sp4));
                break;
            }
            case 12: {
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                if (inWire.isEnd()) {
                    outWire.set(jdbcGateway.connectWithPropString(null, sp1, sp2));
                    break;
                }
                String sp3 = inWire.getString();
                outWire.set(jdbcGateway.connectWithPropString(sp1, sp2, sp3));
                break;
            }
            case 58: {
                outWire.set(jdbcGateway.rollbackXA());
                break;
            }
            case 59: {
                outWire.set(jdbcGateway.commitXA());
                break;
            }
            case 13: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.execQuery(ip1));
                break;
            }
            case 14: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                int size = inWire.getInt();
                String[] arr = null;
                if (size != -1) {
                    arr = new String[size];
                    for (int ii = 0; ii < size; ++ii) {
                        arr[ii] = inWire.getString();
                    }
                }
                outWire.set(jdbcGateway.getTables(ip1, sp1, sp2, sp3, arr));
                break;
            }
            case 15: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                String sp4 = inWire.getString();
                outWire.set(jdbcGateway.getColumns(ip1, sp1, sp2, sp3, sp4));
                break;
            }
            case 85: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                String sp4 = inWire.getString();
                String sp5 = inWire.getString();
                String sp6 = inWire.getString();
                outWire.set(jdbcGateway.getCrossReference(ip1, sp1, sp2, sp3, sp4, sp5, sp6));
                break;
            }
            case 84: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                boolean bp1 = inWire.getBoolean();
                boolean bp2 = inWire.getBoolean();
                outWire.set(jdbcGateway.getIndexInfo(ip1, sp1, sp2, sp3, bp1, bp2));
                break;
            }
            case 16: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                outWire.set(jdbcGateway.getPrimaryKeys(ip1, sp1, sp2, sp3));
                break;
            }
            case 86: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                outWire.set(jdbcGateway.getExportedKeys(ip1, sp1, sp2, sp3));
                break;
            }
            case 87: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                outWire.set(jdbcGateway.getImportedKeys(ip1, sp1, sp2, sp3));
                break;
            }
            case 17: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                String sp4 = inWire.getString();
                outWire.set(jdbcGateway.getProcedureColumns(ip1, sp1, sp2, sp3, sp4));
                break;
            }
            case 18: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                String sp2 = inWire.getString();
                String sp3 = inWire.getString();
                outWire.set(jdbcGateway.getProcedures(ip1, sp1, sp2, sp3));
                break;
            }
            case 19: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.columnCount(ip1));
                break;
            }
            case 20: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getColumnType(ip1, ip2));
                break;
            }
            case 21: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getPrecision(ip1, ip2));
                break;
            }
            case 22: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getScale(ip1, ip2));
                break;
            }
            case 23: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getColumnName(ip1, ip2));
                break;
            }
            case 24: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.columnTypeName(ip1, ip2));
                break;
            }
            case 55: {
                outWire.set(jdbcGateway.isXA());
                break;
            }
            case 56: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.setXAMode(ip1));
                break;
            }
            case 99: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.isValid(ip1));
                break;
            }
            case 25: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.removeStatement(ip1));
                break;
            }
            case 26: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.removeResultSet(ip1));
                break;
            }
            case 27: {
                outWire.set(jdbcGateway.closeAll());
                break;
            }
            case 28: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.removeConnection(ip1));
                break;
            }
            case 29: {
                int ip1 = inWire.getInt();
                boolean bp1 = inWire.getBoolean();
                outWire.set(jdbcGateway.setAutoCommit(ip1, bp1));
                break;
            }
            case 30: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.commit(ip1));
                break;
            }
            case 31: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.rollback(ip1));
                break;
            }
            case 32: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getColumnCount(ip1));
                break;
            }
            case 33: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                outWire.set(jdbcGateway.prepareStatement(ip1, sp1));
                break;
            }
            case 94: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                outWire.set(jdbcGateway.prepareStatementGK(ip1, sp1));
                break;
            }
            case 34: {
                int ip1 = inWire.getInt();
                String sp1 = inWire.getString();
                outWire.set(jdbcGateway.prepareCall(ip1, sp1));
                break;
            }
            case 35: {
                int sind = inWire.getInt();
                int numRows = inWire.getInt();
                ResultSet rs = jdbcGateway.getRS(sind);
                int numCols = jdbcGateway.getColumnCount(sind);
                for (int irows = 0; irows < numRows && rs.next(); ++irows) {
                    outWire.set(numCols);
                    for (int icols = 0; icols < numCols; ++icols) {
                        outWire.set(rs.getString(icols + 1));
                    }
                }
                outWire.set(-1);
                break;
            }
            case 36: {
                int sind = inWire.getInt();
                ResultSet rs = jdbcGateway.getRS(sind);
                int numCols = jdbcGateway.getColumnCount(sind);
                while (outWire.getLength() < 24000 && rs.next()) {
                    outWire.set(numCols);
                    for (int icols = 0; icols < numCols; ++icols) {
                        outWire.set(rs.getString(icols + 1));
                    }
                }
                outWire.set(-1);
                break;
            }
            case 102: {
                int[] result;
                int ip1 = inWire.getInt();
                ListReader innerList = inWire.getInnerList();
                int ip2 = innerList.getInt();
                int paramSets = innerList.getInt();
                int rc = 0;
                ArrayList<Integer> errIdx = new ArrayList<Integer>();
                for (int pi = 0; pi < paramSets; ++pi) {
                    for (int ii = 0; ii < ip2; ++ii) {
                        int ip3 = innerList.getInt();
                        if (ip3 == -2 || ip3 == -3) {
                            byte[] ba1 = innerList.getByteArray();
                            rc = jdbcGateway.setValueBinary(ip1, ii + 1, ba1);
                        } else {
                            String sp1 = innerList.getString();
                            rc = jdbcGateway.setValueDirect(ip1, ii + 1, sp1, ip3);
                        }
                        if (rc == 0) continue;
                        errIdx.add(pi);
                        while (++ii < ip2) {
                            innerList.getObject();
                            innerList.getObject();
                        }
                        break;
                    }
                    if (rc == 0 && !jdbcGateway.addBatch(ip1)) break;
                }
                if ((result = jdbcGateway.executeBatch(ip1)) == null) {
                    outWire.set(-1);
                    break;
                }
                if (errIdx.size() != 0) {
                    int[] res = new int[paramSets];
                    int i = 0;
                    int j = 0;
                    for (int ei = 0; ei < errIdx.size(); ++ei) {
                        while (i < (Integer)errIdx.get(ei)) {
                            res[i++] = result[j++];
                        }
                        res[i++] = -3;
                    }
                    while (i < paramSets) {
                        res[i++] = result[j++];
                    }
                    outWire.set(res);
                    break;
                }
                outWire.set(result);
                break;
            }
            case 37: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                ListReader list1 = inWire.getInnerList();
                int rc = 0;
                for (int ii = 0; ii < ip2; ++ii) {
                    int offset = list1.getOffsetThenNext();
                    int ip3 = list1.getInt();
                    list1.jump(offset);
                    if (ip3 == -2 || ip3 == -3) {
                        byte[] ba1 = list1.getByteArray();
                        rc = jdbcGateway.setValueBinary(ip1, ii + 1, ba1);
                    } else {
                        String sp1 = list1.getString();
                        rc = jdbcGateway.setValueDirect(ip1, ii + 1, sp1, ip3);
                    }
                    list1.getOffsetThenNext();
                    if (rc != 0) break;
                }
                outWire.set(rc);
                break;
            }
            case 39: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getResultSet(ip1));
                break;
            }
            case 40: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getMoreResults(ip1));
                break;
            }
            case 41: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.execute(ip1));
                break;
            }
            case 95: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getGeneratedKeys(ip1));
                break;
            }
            case 103: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getPreparedStatementMetaData(ip1));
                break;
            }
            case 43: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isCurrency(ip1, ip2));
                break;
            }
            case 44: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getColumnTypeName(ip1, ip2));
                break;
            }
            case 45: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isNullable(ip1, ip2));
                break;
            }
            case 46: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.getColumnDisplaySize(ip1, ip2));
                break;
            }
            case 47: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isAutoIncrement(ip1, ip2));
                break;
            }
            case 48: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isCaseSensitive(ip1, ip2));
                break;
            }
            case 49: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.isReadOnly(ip1, ip2));
                break;
            }
            case 1000: {
                String sp1 = inWire.getString();
                outWire.set("Unkown message: " + sp1);
                break;
            }
            case 100: {
                int ip1 = inWire.getInt();
                outWire.set(jdbcGateway.getQueryTimeout(ip1));
                break;
            }
            case 101: {
                int ip1 = inWire.getInt();
                int ip2 = inWire.getInt();
                outWire.set(jdbcGateway.setQueryTimeout(ip1, ip2));
                break;
            }
            default: {
                String sp1 = inWire.getString();
                outWire.set("Test message: " + sp1);
            }
        }
        LogFileStream.log(logFile, " << MESSAGE");
    }
}

