/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jgss;

import com.intersystems.jgss.GSSCallbackHandler;
import com.intersystems.jgss.GSSSocketInputStream;
import com.intersystems.jgss.GSSSocketOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSSocket
extends Socket {
    private static final int MIN_CSL = 1;
    public static final int AUTHENTICATION = 1;
    public static final int INTEGRITY = 2;
    public static final int CONFIDENTIALITY = 3;
    private static final int MAX_CSL = 3;
    private int csl;
    private InputStream is;
    private OutputStream os;
    private DataInputStream dis;
    private DataOutputStream dos;
    private byte[] preamble = new byte[]{0, 0, 127, 1, 0};
    private GSSContext context;

    public GSSSocket(InetAddress address, int port, String service, int csl, String username, String password) throws IOException {
        super(address, port);
        this.initialize(service, csl, username, password);
    }

    public GSSSocket(String host, int port, String service, int csl, String username, String password) throws UnknownHostException, IOException {
        super(host, port);
        this.initialize(service, csl, username, password);
    }

    public GSSSocket(InetAddress address, int port, String service, int csl) throws IOException {
        this(address, port, service, csl, null, null);
    }

    public GSSSocket(String host, int port, String service, int csl) throws UnknownHostException, IOException {
        this(host, port, service, csl, null, null);
    }

    private void initialize(String service, int csl, String username, String password) throws IOException {
        if (csl < 1 || csl > 3) {
            throw new IllegalArgumentException("Invalid connection security level");
        }
        this.csl = csl;
        this.preamble[4] = (byte)csl;
        this.is = super.getInputStream();
        this.os = super.getOutputStream();
        this.dis = new DataInputStream(this.is);
        this.dos = new DataOutputStream(this.os);
        this.dos.write(this.preamble);
        this.dos.flush();
        try {
            GSSCallbackHandler handler = new GSSCallbackHandler(username, password);
            LoginContext lcontext = null;
            try {
                lcontext = new LoginContext("com.sun.security.jgss.initiate", handler);
                lcontext.login();
            }
            catch (LoginException e) {
                throw new IOException(e.toString());
            }
            catch (SecurityException e) {
                throw new IOException(e.toString());
            }
            Subject subject = lcontext.getSubject();
            GSSInitializeAction action = new GSSInitializeAction(service, csl, this.dis, this.dos);
            try {
                Subject.doAs(subject, action);
            }
            catch (PrivilegedActionException e) {
                throw new IOException(e.toString());
            }
            try {
                lcontext.logout();
            }
            catch (LoginException e) {
                throw new IOException(e.toString());
            }
            this.context = action.getContext();
            if (!this.context.getMutualAuthState()) {
                throw new IOException("Mutual authentication failure");
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        switch (this.csl) {
            case 1: {
                return this.is;
            }
            case 2: 
            case 3: {
                return new GSSSocketInputStream(this);
            }
        }
        throw new IOException();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        switch (this.csl) {
            case 1: {
                return this.os;
            }
            case 2: 
            case 3: {
                return new GSSSocketOutputStream(this);
            }
        }
        throw new IOException();
    }

    synchronized void sendToken(byte[] buf, int off, int len) throws IOException {
        byte[] token;
        try {
            MessageProp prop = new MessageProp(0, this.csl == 3);
            token = this.context.wrap(buf, off, len, prop);
        }
        catch (GSSException e) {
            throw new IOException(e.toString());
        }
        this.dos.writeInt(token.length);
        this.dos.write(token);
        this.dos.flush();
    }

    boolean tokenAvailable() throws IOException {
        return this.dis.available() > 0;
    }

    synchronized byte[] receiveToken() throws IOException {
        byte[] buf;
        byte[] token = new byte[this.dis.readInt()];
        this.dis.readFully(token);
        try {
            MessageProp prop = new MessageProp(0, false);
            buf = this.context.unwrap(token, 0, token.length, prop);
        }
        catch (GSSException e) {
            throw new IOException(e.toString());
        }
        return buf;
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.context != null) {
                this.context.dispose();
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        super.close();
    }

    class GSSInitializeAction
    implements PrivilegedExceptionAction<Object> {
        String service;
        int csl;
        GSSContext context;
        DataInputStream dis;
        DataOutputStream dos;

        public GSSInitializeAction(String service, int csl, DataInputStream dis, DataOutputStream dos) {
            this.service = service;
            this.csl = csl;
            this.dis = dis;
            this.dos = dos;
        }

        @Override
        public Object run() throws PrivilegedActionException {
            try {
                Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                GSSManager manager = GSSManager.getInstance();
                GSSName serviceName = manager.createName(this.service, null);
                this.context = manager.createContext(serviceName, krb5Oid, null, 0);
                this.context.requestMutualAuth(true);
                if (this.csl == 2) {
                    this.context.requestInteg(true);
                }
                if (this.csl == 3) {
                    this.context.requestConf(true);
                }
                byte[] token = new byte[]{};
                while (!this.context.isEstablished()) {
                    if ((token = this.context.initSecContext(token, 0, token.length)) != null) {
                        this.dos.writeInt(token.length);
                        this.dos.write(token);
                        this.dos.flush();
                    }
                    if (this.context.isEstablished()) continue;
                    token = new byte[this.dis.readInt()];
                    this.dis.readFully(token);
                }
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            return null;
        }

        public GSSContext getContext() {
            return this.context;
        }
    }
}

