/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jgss;

import com.intersystems.jgss.GSSSocket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class GSSSocketInputStream
extends InputStream {
    private GSSSocket s;
    private byte[] buf = new byte[0];
    private int offset = 0;

    public GSSSocketInputStream(GSSSocket socket) {
        this.s = socket;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        int got = 0;
        if (this.buf.length - this.offset >= len) {
            System.arraycopy(this.buf, this.offset, b, off, len);
            this.offset += len;
            return len;
        }
        if (this.buf.length - this.offset > 0) {
            System.arraycopy(this.buf, this.offset, b, off, this.buf.length - this.offset);
            got += this.buf.length - this.offset;
            this.offset = this.buf.length;
        }
        GSSSocket gSSSocket = this.s;
        synchronized (gSSSocket) {
            while (got < len && this.s.tokenAvailable() || got == 0) {
                try {
                    this.buf = this.s.receiveToken();
                }
                catch (EOFException e) {
                    return -1;
                }
                if (this.buf.length > len - got) {
                    System.arraycopy(this.buf, 0, b, off + got, len - got);
                    this.offset = len - got;
                    return len;
                }
                System.arraycopy(this.buf, 0, b, off + got, this.buf.length);
                got += this.buf.length;
                this.offset = this.buf.length;
            }
        }
        return got;
    }
}

