/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketFactory {
    public boolean debug = false;
    public String logFile;
    public String protocol = "TLS";
    public String cipherSuites = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_AES_256_GCM_SHA384";
    public String keyStore;
    public String keyStoreType = "JKS";
    public String keyStorePassword;
    public String keyRecoveryPassword;
    public String trustStore;
    public String trustStoreType = "JKS";
    public String trustStorePassword;
    public String algorithm = "SunX509";
    public PrintStream errout = System.err;
    public boolean serverHostNameVerification = false;
    SSLContext ctx;
    javax.net.ssl.SSLSocketFactory sf;
    ArrayList<String> enabled;

    public SSLSocketFactory(String configName, String password) throws Exception {
        String fileName = System.getProperty("com.intersystems.SSLConfigFile", "SSLConfig.properties");
        Properties props = null;
        File file = new File(fileName);
        if (file.exists()) {
            props = new Properties();
            props.load(new FileInputStream(fileName));
        } else if (!file.isAbsolute()) {
            String sep = File.separator;
            fileName = System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + fileName;
            file = new File(fileName);
            if (file.exists()) {
                props = new Properties();
                props.load(new FileInputStream(fileName));
            }
        }
        if (props != null) {
            this.autoConfig(props, 0);
            if (configName != null && configName.length() > 0) {
                String propName;
                String propValue;
                boolean found = false;
                int i = 1;
                while ((propValue = props.getProperty(propName = "name." + i)) != null) {
                    if (propValue.equals(configName)) {
                        found = true;
                        this.autoConfig(props, i);
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    String msg = "SSL/TLS: configuration " + configName + " not found in file " + fileName;
                    if (this.debug) {
                        this.errout.println(msg);
                    }
                    throw new Exception(msg);
                }
            }
        } else {
            this.keyStore = System.getProperty("javax.net.ssl.keyStore");
            this.trustStore = System.getProperty("javax.net.ssl.trustStore");
            this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            this.keyRecoveryPassword = System.getProperty("javax.net.ssl.keyRecoveryPassword", this.keyStorePassword);
            this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", this.keyStoreType);
            this.cipherSuites = System.getProperty("javax.net.ssl.cipherSuites", this.cipherSuites);
            this.protocol = System.getProperty("javax.net.ssl.protocol", this.protocol);
            this.logFile = System.getProperty("javax.net.ssl.logFile");
            String temp = System.getProperty("javax.net.debug");
            if (temp != null) {
                this.debug = temp.equalsIgnoreCase("true");
            }
        }
        if (this.protocol == null) {
            String msg = "SSL/TLS:  protocol must be specified";
            if (this.debug) {
                this.errout.println(msg);
            }
            throw new Exception(msg);
        }
        KeyManagerFactory kmf = null;
        if (this.keyStore != null) {
            if (this.keyStoreType == null) {
                String msg = "SSL/TLS:  keyStoreType must be specified for keyStore " + this.keyStore;
                if (this.debug) {
                    this.errout.println(msg);
                }
                throw new Exception(msg);
            }
            if (this.keyRecoveryPassword == null) {
                if (password != null) {
                    this.keyRecoveryPassword = password;
                } else if (this.keyStorePassword != null) {
                    this.keyRecoveryPassword = this.keyStorePassword;
                } else {
                    String msg = "SSL/TLS:  keyRecoveryPassword must be specified for keyStore " + this.keyStore;
                    if (this.debug) {
                        this.errout.println(msg);
                    }
                    throw new Exception(msg);
                }
            }
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            ks.load(new FileInputStream(this.keyStore), this.keyStorePassword.toCharArray());
            kmf = KeyManagerFactory.getInstance(this.algorithm);
            kmf.init(ks, this.keyRecoveryPassword.toCharArray());
        }
        TrustManagerFactory tmf = null;
        if (this.trustStore != null) {
            if (this.trustStoreType == null) {
                String msg = "SSL/TLS:  trustStoreType must be specified for trustStore " + this.trustStore;
                if (this.debug) {
                    this.errout.println(msg);
                }
                throw new Exception(msg);
            }
            KeyStore ts = KeyStore.getInstance(this.trustStoreType);
            ts.load(new FileInputStream(this.trustStore), this.trustStorePassword.toCharArray());
            tmf = TrustManagerFactory.getInstance(this.algorithm);
            tmf.init(ts);
        }
        SecureRandom sr = new SecureRandom();
        long t1 = System.currentTimeMillis();
        sr.nextBytes(new byte[1]);
        long t2 = System.currentTimeMillis();
        if (this.debug) {
            this.errout.println("RNG seeding time " + (t2 - t1) + " msec");
        }
        this.ctx = SSLContext.getInstance(this.protocol);
        this.ctx.init(kmf == null ? null : kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), sr);
        this.sf = this.ctx.getSocketFactory();
        List<String> supported = Arrays.asList(this.sf.getSupportedCipherSuites());
        if (this.debug) {
            this.errout.println("Supported CipherSuites:");
            this.errout.println(supported);
        }
        if (this.cipherSuites == null && this.debug) {
            this.errout.println("Default CipherSuites:");
            this.errout.println(Arrays.asList(this.sf.getSupportedCipherSuites()));
        } else {
            this.enabled = new ArrayList();
            StringTokenizer st = new StringTokenizer(this.cipherSuites, ", ");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!supported.contains(tok)) continue;
                this.enabled.add(tok);
            }
            if (this.enabled.isEmpty()) {
                String msg = "SSL/TLS:  No CipherSuites are enabled";
                if (this.debug) {
                    this.errout.println(msg);
                }
                throw new Exception(msg);
            }
            if (this.debug) {
                this.errout.println("Enabled CipherSuites:");
                this.errout.println(this.enabled);
            }
        }
    }

    public SSLSocket createSocket(String host, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.sf.createSocket(host, port);
        if (this.enabled != null) {
            socket.setEnabledCipherSuites(this.enabled.toArray(new String[0]));
        }
        if (!this.sslHostnameCertValidation(host, socket.getSession())) {
            throw new SSLPeerUnverifiedException("SSL Failed to validate server hostname: " + host);
        }
        return socket;
    }

    private boolean sslHostnameCertValidation(String hostname2, SSLSession session) throws SSLPeerUnverifiedException {
        if (!this.serverHostNameVerification) {
            return true;
        }
        try {
            Certificate[] certificateList;
            String lchn = hostname2.toLowerCase();
            for (Certificate certificate : certificateList = session.getPeerCertificates()) {
                if (!(certificate instanceof X509Certificate)) continue;
                X509Certificate x509 = (X509Certificate)certificate;
                Collection<List<?>> sanList = x509.getSubjectAlternativeNames();
                if (sanList != null) {
                    for (List<?> san : sanList) {
                        String saName;
                        int type = (Integer)san.get(0);
                        if (type != 2 && type != 7 || !lchn.contains((saName = (String)san.get(1)).substring(saName.indexOf("*") + 1))) continue;
                        return true;
                    }
                }
                String csn = x509.getSubjectX500Principal().getName("CANONICAL").split("=")[1];
                if (!lchn.contains(csn = (String)csn.subSequence(csn.indexOf("*") + 1, csn.lastIndexOf(44)))) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException("SSL Failed to validate server hostname!");
        }
        return false;
    }

    void autoConfig(Properties props, int n) throws Exception {
        Field[] field = this.getClass().getFields();
        for (int i = 0; i < field.length; ++i) {
            if (Modifier.isFinal(field[i].getModifiers())) continue;
            String name = field[i].getName();
            if (n > 0) {
                name = name + "." + n;
            }
            Class<?> t = field[i].getType();
            String value = props.getProperty(name);
            if (value == null) continue;
            if (name == "logFile") {
                this.errout = new PrintStream(value);
            }
            if (this.debug) {
                this.errout.println(name + " (" + t + ") = " + value);
            }
            try {
                if (t == Integer.TYPE) {
                    field[i].setInt(this, Integer.parseInt(value));
                    continue;
                }
                if (t == Boolean.TYPE) {
                    field[i].setBoolean(this, Boolean.valueOf(value));
                    continue;
                }
                if (t != String.class) continue;
                field[i].set(this, value);
                continue;
            }
            catch (IllegalAccessException e) {
                this.errout.println(e);
                this.errout.println("Setting value for property " + name);
                System.exit(1);
            }
        }
    }
}

