/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import com.intersystems.shm.SharedMemoryImpl;
import com.intersystems.shm.SharedMemoryInputStream;
import com.intersystems.shm.SharedMemoryOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class SharedMemoryDevice
extends SharedMemoryImpl {
    private String shmFileName;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private InputStream is;
    private OutputStream os;

    public SharedMemoryDevice(String shmFile) {
        this.shmFileName = shmFile;
    }

    public SharedMemoryDevice(FileChannel fc) {
        this.fileChannel = fc;
    }

    @Override
    public synchronized void connect(int timeout) throws IOException {
        this.os = new SharedMemoryOutputStream(this.fileChannel);
        this.is = new SharedMemoryInputStream(this.fileChannel);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public synchronized void close() throws IOException {
        this.is.close();
        this.os.close();
        this.fileChannel.close();
        this.raf.close();
    }
}

