/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import com.intersystems.shm.SharedMemoryImpl;
import com.intersystems.shm.SharedMemoryInputStreamJNI;
import com.intersystems.shm.SharedMemoryOutputStreamJNI;
import com.intersystems.util.MachineInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Paths;

public class SharedMemoryDeviceJNI
extends SharedMemoryImpl
implements AutoCloseable {
    private static boolean loadedDLL = false;
    long shmRef;
    private InputStream is;
    private OutputStream os;

    native long InitClientSharedMemory(int var1);

    native long InitClientSharedMemory(int var1, String var2, int var3);

    native long InitSharedMemory(int var1, String var2, int var3, boolean var4, int var5);

    native int available(long var1);

    native void close(long var1);

    native boolean connect(long var1, int var3);

    native void flush(long var1);

    native int getLastError(long var1);

    native ByteBuffer getReadByteBuffer(long var1);

    native ByteBuffer getWriteByteBuffer(long var1);

    native int length(long var1, int var3);

    native int mark(long var1, int var3);

    native int read(long var1, byte[] var3, int var4, int var5);

    native void reset(long var1);

    native void signalEvent(long var1, int var3);

    native void waitOnEvent(long var1, int var3);

    native void write(long var1, byte[] var3, int var4, int var5);

    private static void loadDLL(String rootDir) {
        String ext = "";
        String library = "";
        String partPath = "";
        try {
            boolean isWin = MachineInfo.getOSName().contains("WINDOWS");
            if (isWin) {
                library = System.getProperty("sun.arch.data.model").matches("32") ? "XDEVshm32" : "XDEVshm";
                ext = ".dll";
            } else {
                ext = ".so";
                library = "libxdevshm";
            }
            if (rootDir == null) {
                System.loadLibrary(library.replaceFirst("^lib", ""));
            }
            String shmFile = Paths.get(rootDir, "bin", library + ext).toString();
            System.load(shmFile);
            loadedDLL = true;
        }
        catch (Exception ex) {
            if (rootDir == null) {
                System.out.println("Exception loading JNI library and missing install directory parameter");
            }
            String shmFile = rootDir + partPath + library + ext;
            try {
                System.load(shmFile);
            }
            catch (Exception inner) {
                System.out.println("Exception loading dll: ");
                System.out.println("\tInitial exception ): " + ex.getMessage());
                System.out.println("\tInner exception ): " + inner.getMessage());
                throw inner;
            }
        }
    }

    public SharedMemoryDeviceJNI(int pid, String shmFileName, int optionFlags, String installDir) throws IOException {
        if (!loadedDLL) {
            SharedMemoryDeviceJNI.loadDLL(installDir);
        }
        this.shmRef = this.InitClientSharedMemory(pid, shmFileName, optionFlags);
        if (this.shmRef == 0L) {
            String error = "Could not create shared memory, GetLastError returned: " + this.getLastError(0L);
            throw new IOException(error);
        }
    }

    @Override
    public void connect(int timeout) throws IOException {
        if (!this.connect(this.shmRef, timeout)) {
            String error = "Could not create shared memory, GetLastError returned: " + this.getLastError(this.shmRef);
            this.close();
            throw new IOException(error);
        }
        this.is = new SharedMemoryInputStreamJNI(this);
        this.os = new SharedMemoryOutputStreamJNI(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(this.shmRef);
        this.shmRef = 0L;
    }
}

