/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class SharedMemoryInputStream
extends InputStream {
    private FileChannel fileChannel;
    private MappedByteBuffer readBuffer;
    private LongBuffer readLongBuff;

    public SharedMemoryInputStream(FileChannel fc) throws IOException {
        long size = 0x100000L;
        this.fileChannel = fc;
        long s = fc.size();
        this.fileChannel.position(0L);
        this.readLongBuff = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, size, 8L).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        this.fileChannel.position(0L);
        this.readBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, size + 8L, size - 8L).load();
        this.fileChannel.position(0L);
        if (this.readLongBuff.isDirect()) {
            System.out.println("lBuff1 is direct");
        } else {
            System.out.println("lBuff1 is not direct");
        }
        if (this.readBuffer.hasArray()) {
            System.out.println("readBuffer has backing array");
        }
        if (this.readBuffer.isDirect()) {
            System.out.println("readBuffer is direct");
        }
        this.readBuffer.position(0);
    }

    @Override
    public int available() throws IOException {
        return (int)this.readLongBuff.get(0);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
        this.readBuffer.position(readlimit);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readBuffer.get(b);
        int lenRead = this.readBuffer.position();
        int lenToRead = (int)this.readLongBuff.get(0);
        if (lenRead == lenToRead) {
            this.reset();
        }
        return lenRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long rc = 0L;
        while (this.readLongBuff.get(0) == 0L) {
        }
        int lenInbuffer = (int)this.readLongBuff.get(0);
        if (lenInbuffer < len) {
            len = lenInbuffer;
        }
        if (off == 0) {
            this.readBuffer.position(0);
        }
        this.readBuffer.get(b, off, len);
        if (lenInbuffer == this.readBuffer.position()) {
            this.reset();
        }
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.readBuffer.position(0);
        this.readLongBuff.put(0, 0L);
    }

    @Override
    public long skip(long n) throws IOException {
        this.readBuffer.position((int)n);
        return this.readBuffer.position();
    }
}

