/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import com.intersystems.shm.SharedMemoryDeviceJNI;
import java.io.IOException;
import java.io.InputStream;

public class SharedMemoryInputStreamJNI
extends InputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;
    SharedMemoryDeviceJNI shmDev;

    public SharedMemoryInputStreamJNI(SharedMemoryDeviceJNI shmDevRef) {
        this.shmDev = shmDevRef;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.shmDev.read(this.shmDev.shmRef, b, 0, 1) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.shmDev.read(this.shmDev.shmRef, b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.shmDev.read(this.shmDev.shmRef, b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining = n;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] localSkipBuffer = skipBuffer;
        if (n <= 0L) {
            return 0L;
        }
        while (remaining > 0L && (nr = this.read(localSkipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0) {
            remaining -= (long)nr;
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        return this.shmDev.available(this.shmDev.shmRef);
    }

    @Override
    public void close() throws IOException {
        this.shmDev.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

