/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class SharedMemoryOutputStream
extends OutputStream {
    private FileChannel fileChannel;
    private MappedByteBuffer writeBuffer;
    private LongBuffer writeLongBuff;

    public SharedMemoryOutputStream(FileChannel fc) throws IOException {
        long size = 0x100000L;
        this.fileChannel = fc;
        this.fileChannel.position(0L);
        this.writeLongBuff = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 16L).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        this.fileChannel.position(0L);
        this.writeBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 8L, size - 8L).load();
        this.fileChannel.position(0L);
        if (this.writeLongBuff.isDirect()) {
            System.out.println("lBuff2 is direct");
        } else {
            System.out.println("lBuff2 is not direct");
        }
        if (this.writeBuffer.hasArray()) {
            System.out.println("writeBuffer has backing array");
        }
        if (this.writeBuffer.isDirect()) {
            System.out.println("writeBuffer is direct");
        }
        this.writeLongBuff.put(0, size * 2L);
        this.writeBuffer.position(0);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        long pos = this.writeBuffer.position();
        if (pos > 0L) {
            this.writeBuffer.position(0);
            this.writeLongBuff.put(0, pos);
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (this.writeBuffer.position() == 0) {
            while (this.writeLongBuff.get(0) != 0L) {
            }
        }
        byte[] b = new byte[]{(byte)(i & 0xFF)};
        this.writeBuffer.put(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.writeBuffer.position() == 0) {
            while (this.writeLongBuff.get(0) != 0L) {
            }
        }
        this.writeBuffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.writeBuffer.position() == 0) {
            while (this.writeLongBuff.get(0) != 0L) {
            }
        }
        this.writeBuffer.put(b, off, len);
    }

    public boolean checkReady() {
        return this.writeLongBuff.get() == 0L;
    }
}

