/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import com.intersystems.shm.SharedMemoryDeviceJNI;
import java.io.IOException;
import java.io.OutputStream;

public class SharedMemoryOutputStreamJNI
extends OutputStream {
    SharedMemoryDeviceJNI shmDev;

    public SharedMemoryOutputStreamJNI(SharedMemoryDeviceJNI shmDevRef) {
        this.shmDev = shmDevRef;
    }

    @Override
    public void write(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i & 0xFF)};
        this.shmDev.write(this.shmDev.shmRef, b, 0, b.length);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.shmDev.write(this.shmDev.shmRef, b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.shmDev.write(this.shmDev.shmRef, b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.shmDev.close();
    }
}

