/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.shm;

import com.intersystems.shm.SharedMemoryDevice;
import com.intersystems.shm.SharedMemoryDeviceJNI;
import com.intersystems.shm.SharedMemoryImpl;
import com.intersystems.shm.SharedMemoryType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class SharedMemorySocket
extends Socket {
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    private FileChannel fileChannel;
    private String installDir;
    private final Map<String, String> argMap = new LinkedHashMap<String, String>(){
        {
            this.put("SHM", "SHM");
            this.put("DOLLARJ", "");
            this.put("SIZE", Integer.valueOf(40960).toString());
            this.put("FILENAME", "");
            this.put("FLAG", "");
            this.put("OPENTIMEOUT", "");
        }
    };
    SharedMemoryImpl impl;
    private SharedMemoryType smType = SharedMemoryType.FILE;
    private String namespace = null;
    private static SocketImplFactory factory = null;

    public SharedMemorySocket(String shmParameters, String nsp, String cacheInstallDir, SharedMemoryType type) {
        this.smType = type;
        this.namespace = nsp;
        this.installDir = cacheInstallDir == "" || cacheInstallDir == null ? System.getenv("CACHE_HOME") : cacheInstallDir;
        this.MapArguments(shmParameters);
        switch (type) {
            case FILE: {
                this.impl = new SharedMemoryDevice(this.fileChannel);
                break;
            }
            case JNI: {
                break;
            }
            case JNIFILE: {
                break;
            }
        }
    }

    protected SharedMemorySocket(SharedMemoryImpl impl) throws SocketException {
        this.impl = impl;
        if (impl == null) {
            throw new SocketException("SharedMemory has not been initialized");
        }
    }

    public static String FormatParameters(Integer dollarJ, Integer shmSize, String shmName, Integer shmWaitFlag, Integer openTimeout) {
        return "SHM|" + (dollarJ == null ? "" : dollarJ) + "|" + (shmSize == null ? "" : shmSize) + "|" + (shmName == null ? "" : shmName) + "|" + (shmWaitFlag == null ? "" : shmWaitFlag) + "|" + (openTimeout == null ? "" : openTimeout);
    }

    public static String FormatParameters(Integer dollarJ, String shmName, Integer shmWaitFlag) {
        return SharedMemorySocket.FormatParameters(dollarJ, null, shmName, shmWaitFlag, null);
    }

    public static String FormatParameters(String shmName, Integer shmWaitFlag) {
        return SharedMemorySocket.FormatParameters(null, null, shmName, shmWaitFlag, null);
    }

    public static String FormatParameters(Integer shmWaitFlag) {
        return SharedMemorySocket.FormatParameters(null, null, null, shmWaitFlag, null);
    }

    public static String ValidateHostString(String hostStr) {
        String fileName;
        String[] params = hostStr.toUpperCase().split("\\|", -1);
        String openTimeout = params[5];
        if (openTimeout.equals("0")) {
            params[5] = "";
        }
        if (!(fileName = params[3]).equals("")) {
            params[3] = "";
        }
        String validatedStr = params[0];
        for (int i = 1; i < params.length; ++i) {
            validatedStr = validatedStr + "|" + params[i];
        }
        return validatedStr;
    }

    public void MapArguments(String parseHostArgs) {
        String[] entries = parseHostArgs.toUpperCase().split("\\|");
        int i = 0;
        for (String key : this.argMap.keySet()) {
            if (entries.length <= i) break;
            if (entries[i] != null) {
                this.argMap.put(key, entries[i]);
            }
            ++i;
        }
        switch (this.smType) {
            case FILE: {
                String shmFile = this.argMap.get("FILENAME");
                String dollarj = this.argMap.get("DOLLARJ");
                if (shmFile != null && !shmFile.isEmpty()) break;
                if (dollarj == null || dollarj.isEmpty()) {
                    dollarj = Integer.valueOf(new Random().nextInt()).toString();
                    this.argMap.put("DOLLARJ", dollarj);
                }
                shmFile = this.installDir != null ? this.installDir + "\\mgr\\" + this.namespace + "\\xdev" + dollarj + ".shm" : "xdev" + dollarj + ".shm";
                this.argMap.put("FILENAME", shmFile);
                File file = new File(shmFile);
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(file, "rw");
                    this.fileChannel = raf.getChannel();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case JNIFILE: {
                break;
            }
        }
    }

    public String unMapArguments() {
        Object[] values = this.argMap.values().toArray();
        String out = "";
        for (int i = 0; i < values.length; ++i) {
            out = out + values[i].toString() + "|";
        }
        return out;
    }

    public void connect(String dollarj) throws IOException {
        this.connect(dollarj, 0);
    }

    public void connect(String dollarj, int timeout) throws IOException {
        int connectionTimeout = timeout;
        String openTimeout = this.argMap.get("OPENTIMEOUT");
        if (openTimeout != "") {
            try {
                connectionTimeout = Integer.valueOf(openTimeout);
            }
            catch (NumberFormatException ex) {
                connectionTimeout = timeout;
            }
        }
        if (connectionTimeout == 0) {
            connectionTimeout = 1;
        } else if (connectionTimeout < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("already connected");
        }
        try {
            switch (this.smType) {
                case FILE: {
                    break;
                }
                default: {
                    this.argMap.put("DOLLARJ", dollarj);
                    int pid = Integer.parseInt(dollarj);
                    String file = this.argMap.get("FILENAME");
                    int flag = 0;
                    try {
                        flag = Integer.parseInt(this.argMap.get("FLAG"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.impl = new SharedMemoryDeviceJNI(pid, file, flag, this.installDir);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.impl.connect(connectionTimeout);
        this.connected = true;
        this.bound = true;
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getInetAddress();
    }

    @Override
    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getLocalPort() {
        return this.getPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.impl.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.impl.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return true;
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public int getSoLinger() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public int getTrafficClass() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        throw new SocketException("Not Implemented");
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        throw new SocketException("Not Implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.impl != null) {
                this.impl.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.impl.shutdownInput();
        this.shutIn = true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.impl.shutdownOutput();
        this.shutOut = true;
    }

    @Override
    public String toString() {
        try {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + "]";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Socket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public boolean isInputShutdown() {
        return this.shutIn;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("factory already defined");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

