/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.sqf.Address;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ISCRecord;
import com.intersystems.sqf.Sharder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSharder
implements Sharder {
    List<Factor> m_factors;
    int[] m_fields;
    int[] m_bounds;
    int[] m_map;
    String m_query;
    Address m_addr;

    public AbstractSharder(List<Factor> factors, int[] fields, int[] bounds, int[] map, String query, Address addr) {
        this.m_factors = factors;
        this.m_fields = fields;
        this.m_bounds = bounds;
        this.m_map = map;
        this.m_query = query;
        this.m_addr = addr;
    }

    @Override
    public Factor getProduct() {
        return new Factor(this.m_query, this.m_addr);
    }

    @Override
    public int getFactor(Object ... keyValues) throws SQLException {
        ISCRecord record = new ISCRecord(keyValues);
        return this.getFactor(record);
    }

    @Override
    public Address getAddress(ISCRecord record) throws SQLException {
        int i = this.getFactor(record);
        return this.m_factors.get((int)i).address;
    }

    @Override
    public Address getAddress(Object ... keyValues) throws SQLException {
        ISCRecord record = new ISCRecord(keyValues);
        return this.getAddress(record);
    }

    @Override
    public List<Factor> getFactors() {
        return this.m_factors;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(1024);
        this.dump(b);
        return b.toString();
    }

    void dump(StringBuilder sb, String key, Object val) {
        sb.append("\n " + key + " : " + val);
    }

    void dump(StringBuilder sb, String key, int[] val) {
        this.dump(sb, key, Arrays.toString(val));
    }

    void dump(StringBuilder sb) {
        this.dump(sb, "factors", this.m_factors);
    }
}

