/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.sqf.Utilities;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public final class Address
implements Serializable {
    public static final String SHMHOSTNAME = "SHM|||||";
    private static final long serialVersionUID = 1L;
    public final String host;
    public final int port;
    public final String namespace;
    public final String user;
    public final String password;
    public final String logFile;

    public Address(String url) throws Exception {
        this(url, "", "");
    }

    public Address(URI uri) throws Exception {
        this(uri, "", "");
    }

    public Address(String host, int port, String namespace) {
        this(host, port, namespace, "", "");
    }

    public Address(String url, String user, String password) throws Exception {
        int i = url.indexOf("//");
        String s = url.substring(i + 2);
        int i1 = s.indexOf(":");
        int i2 = s.indexOf("/");
        String h = s.substring(0, i1);
        String p = s.substring(i1 + 1, i2);
        String n = s.substring(i2 + 1);
        this.host = h;
        this.port = Integer.parseInt(p);
        this.user = user;
        this.password = password;
        String[] ns = Address.splitNS(n);
        this.namespace = ns[0];
        this.logFile = ns[1];
    }

    public Address(URI uri, String u, String z) throws Exception {
        assert (uri != null && u != null && z != null);
        String s = uri.getScheme();
        String h = uri.getHost();
        int p = uri.getPort();
        String n = uri.getPath();
        if (s == null || s.compareTo("IRIS") != 0) {
            Utilities.fail("Bad URI scheme: expected 'IRIS' but got '%s'", s);
        }
        if (h == null || h.isEmpty()) {
            Utilities.fail("Bad server host name", new Object[0]);
        }
        if (p < 0 || p > 65535) {
            Utilities.fail("Bad server port number: expected integer between 0 and 65535, but got '%d'", p);
        }
        if (n == null || n.isEmpty() || n.compareTo("/") == 0) {
            Utilities.fail("Bad server namespace", new Object[0]);
        }
        if (n.charAt(0) == '/') {
            n = n.substring(1);
        }
        this.host = h;
        this.port = p;
        this.user = u;
        this.password = z;
        String[] ns = Address.splitNS(n);
        this.namespace = ns[0];
        this.logFile = ns[1];
    }

    public Address(String h, int p, String n, String u, String z) {
        this(h, p, Address.splitNS(n)[0], u, z, Address.splitNS(n)[1]);
    }

    public Address(String h, int p, String n, String u, String z, String l) {
        assert (h != null && n != null && u != null && z != null);
        this.host = h;
        this.port = p;
        this.user = u;
        this.password = z;
        this.namespace = n;
        this.logFile = l;
    }

    public Address normalize() {
        try {
            String hostName = this.host.equalsIgnoreCase(SHMHOSTNAME) ? Utilities.hostname() : this.host;
            return new Address(InetAddress.getByName(hostName).getCanonicalHostName(), this.port, this.namespace.toUpperCase(), this.user, this.password, this.logFile);
        }
        catch (UnknownHostException e) {
            return this;
        }
    }

    public String ipAddress() throws UnknownHostException {
        String hostName = this.host.equalsIgnoreCase(SHMHOSTNAME) ? Utilities.hostname() : this.host;
        return InetAddress.getByName(hostName).getHostAddress();
    }

    public boolean hasCredentials() {
        return !this.user.isEmpty() && !this.password.isEmpty();
    }

    public boolean isLocal() {
        if (this.host.equalsIgnoreCase(SHMHOSTNAME)) {
            return true;
        }
        return Utilities.hostname().equalsIgnoreCase(this.host);
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public String jdbc() {
        if (this.logFile != null) {
            return String.format("jdbc:IRIS://%s:%d/%s/%s", this.host, this.port, this.namespace, this.logFile);
        }
        return String.format("jdbc:IRIS://%s:%d/%s", this.host, this.port, this.namespace);
    }

    public String url() {
        if (this.logFile != null) {
            return String.format("IRIS://%s:%d/%s/%s", this.host, this.port, this.namespace, this.logFile);
        }
        return String.format("IRIS://%s:%d/%s", this.host, this.port, this.namespace);
    }

    public String toString() {
        return this.url();
    }

    public int hashCode() {
        int h = 1;
        h = 31 * h + this.host.hashCode();
        h = 31 * h + this.port;
        h = 31 * h + this.namespace.hashCode();
        h = 31 * h + this.user.hashCode();
        h = 31 * h + this.password.hashCode();
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Address)) {
            return false;
        }
        Address that = (Address)object;
        return this.host.equals(that.host) && this.port == that.port && this.namespace.equals(that.namespace) && this.user.equals(that.user) && this.password.equals(that.password);
    }

    private static String[] splitNS(String ns) {
        String[] a = ns.split("/", 2);
        if (a.length > 1) {
            return a;
        }
        return new String[]{ns, null};
    }
}

