/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.sqf.AbstractSharder;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ForeignIdInfo;
import com.intersystems.sqf.ISCRecord;
import java.sql.SQLException;
import java.util.List;

public class ForeignIdSharder
extends AbstractSharder {
    final int m_rangeSize;
    final String m_mapOwner;

    public ForeignIdSharder(ForeignIdInfo info, List<Factor> factors, int[] fields, int[] bounds, int[] map, String query, Address addr) {
        super(factors, fields, bounds, map, query, addr);
        this.m_map = info.map();
        this.m_rangeSize = info.rangeSize();
        this.m_mapOwner = info.mapOwner();
    }

    @Override
    public int getFactor(ISCRecord record) throws SQLException {
        Object k = record.fields[this.m_fields[0]];
        if (k == null) {
            throw new SQLException("Shard key is null");
        }
        Integer fld = Integer.valueOf(k.toString());
        int range = fld / this.m_rangeSize + 1;
        if (range < 1 || range >= this.m_map.length) {
            throw new SQLException("Shard key " + fld + " is outside any existing id range of " + this.m_mapOwner);
        }
        return this.m_map[range] - 1;
    }

    @Override
    void dump(StringBuilder sb) {
        this.dump(sb, "method ", "foreign-id");
        super.dump(sb);
        this.dump(sb, "map ", this.m_map);
        this.dump(sb, "rangeSize ", this.m_rangeSize);
        this.dump(sb, "mapOwner ", this.m_mapOwner);
    }
}

