/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.sqf.AbstractSharder;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ISCRecord;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;

public class KeyHashSharder
extends AbstractSharder {
    int m_maxhash = 2048;

    public KeyHashSharder(List<Factor> factors, int[] fields, int[] bounds, int[] map, String query, Address addr, int maxhash) {
        super(factors, fields, bounds, map, query, addr);
        this.m_maxhash = maxhash;
    }

    @Override
    public int getFactor(ISCRecord record) {
        CRC32 crc32 = new CRC32();
        for (int field : this.m_fields) {
            Object k = record.fields[field];
            String fld = k == null ? "" : k.toString();
            fld = ("x" + fld.toUpperCase()).trim();
            fld = " " + fld.substring(1, fld.length());
            crc32.update(fld.getBytes());
        }
        int h = (int)(crc32.getValue() % (long)this.m_maxhash);
        if (this.m_map != null) {
            return this.m_map[h];
        }
        int i = Arrays.binarySearch(this.m_bounds, h);
        return i < 0 ? -i - 2 : i;
    }

    @Override
    void dump(StringBuilder sb) {
        this.dump(sb, "method ", "key-hash");
        super.dump(sb);
        this.dump(sb, "fields ", this.m_fields);
        this.dump(sb, "bounds ", this.m_bounds);
    }
}

