/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.jdbc.IRIS;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.jdbc.ListReader;
import com.intersystems.jdbc.ListWriter;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ForeignIdInfo;
import com.intersystems.sqf.ForeignIdSharder;
import com.intersystems.sqf.KeyHashSharder;
import com.intersystems.sqf.RoundRobinSharder;
import com.intersystems.sqf.Sharder;
import com.intersystems.sqf.Utilities;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Master {
    private final IRISConnection m_conn;
    private final IRIS m_iris;
    private final Address m_addr;
    private static final int maxhash = 2048;

    public Master(IRISConnection c, String h, int p, String n, String u, String z, String l) throws SQLException {
        this.m_conn = c;
        this.m_iris = IRIS.createIRIS(c);
        this.m_addr = new Address(h, p, n, u, z, l);
    }

    public Address address() {
        return this.m_addr;
    }

    public IRIS getIRIS() {
        return this.m_iris;
    }

    public boolean isEntitySharded(String entityName) throws SQLException {
        assert (!this.m_conn.isClosed());
        boolean sharded = false;
        try {
            sharded = this.m_iris.classMethodBoolean("%BigData.ShardingManager", "%IsEntitySharded", "SQ", entityName);
        }
        catch (RuntimeException e) {
            Utilities.log("Exception calling %IsEntitySharded(): %s", e.getMessage());
        }
        return sharded;
    }

    public List<Address> listShardAddresses() throws SQLException {
        assert (!this.m_conn.isClosed());
        ArrayList<Address> shards = new ArrayList<Address>();
        ListReader r = this.classMethodList("%BigData.ShardingManager", "%ListShardAddresses", new Object[0]);
        Object o = r.getObject();
        if (!(o instanceof Long) || (Long)o != 1L) {
            throw new SQLException(o.toString());
        }
        int pv = r.getInt();
        int n = r.getInt();
        for (int i = 0; i < n; ++i) {
            String host = r.getString();
            int port = r.getInt();
            String ns = r.getString();
            shards.add(new Address(host, port, ns));
        }
        return shards;
    }

    public Sharder getSharder(String tableName, String[] keyFields) throws SQLException {
        StringBuffer query = new StringBuffer();
        if (keyFields == null || keyFields.length == 0) {
            query.append("SELECT %ID FROM ").append(tableName);
        } else {
            int i;
            query.append("INSERT INTO ").append(tableName).append(" ");
            query.append("(");
            int len = keyFields.length;
            for (i = 0; i < len; ++i) {
                query.append(keyFields[i]);
                if (i >= len - 1) continue;
                query.append(",");
            }
            query.append(") ");
            query.append("VALUES(");
            for (i = 0; i < len; ++i) {
                query.append("?");
                if (i >= len - 1) continue;
                query.append(",");
            }
            query.append(")");
        }
        return this.getSharder(query.toString());
    }

    public Sharder getSharder(String query) throws SQLException {
        assert (!this.m_conn.isClosed());
        ListReader v = this.broker(query);
        String q = v.getString();
        int brokerShardOpVersion = v.getInt();
        int kCount = brokerShardOpVersion < 0 ? v.getInt() : brokerShardOpVersion;
        int[] k = new int[kCount];
        for (int i = 0; i < k.length; ++i) {
            k[i] = v.getInt();
            v.getString();
        }
        Factor[] f = new Factor[v.getInt()];
        int[] b = new int[f.length + 1];
        int[] map = null;
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Factor(q, this.getAddress(v, brokerShardOpVersion));
            b[i] = v.getInt();
            if (b[i] >= 0) continue;
            if (map == null) {
                map = new int[2049];
            }
            for (int j = 0; j < -b[i]; ++j) {
                int low = v.getInt();
                int high = v.getInt();
                for (int kk = low; kk <= high; ++kk) {
                    map[kk] = i;
                }
            }
        }
        b[f.length] = 2048;
        List<Factor> m_factors = this.prune(f, k);
        int[] m_fields = k;
        int[] m_bounds = b;
        int[] m_map = map;
        if (m_fields.length == 0) {
            return new RoundRobinSharder(m_factors, m_fields, m_bounds, m_map, query, this.m_addr);
        }
        if (m_fields.length == 1 && !v.isEnd()) {
            return new ForeignIdSharder(this.parseForeignIdInfo(v), m_factors, m_fields, m_bounds, m_map, query, this.m_addr);
        }
        return new KeyHashSharder(m_factors, m_fields, m_bounds, m_map, query, this.m_addr, 2048);
    }

    private ForeignIdInfo parseForeignIdInfo(ListReader v) throws SQLException {
        int mapSizeTotal = v.getInt();
        int mapSizeReturned = v.getInt();
        int rangeSize = v.getInt();
        String mapOwner = v.getString();
        String mapString = v.getString();
        int[] map = new int[1 + mapSizeTotal];
        int previousSize = 0;
        int newSizeReturned = 0;
        do {
            if (previousSize > 0 && mapSizeReturned < mapSizeTotal) {
                v = this.shardMapRanges(mapOwner, mapSizeReturned + 1);
                int repeatTotal = v.getInt();
                newSizeReturned = v.getInt();
                int repeatRangeSize = v.getInt();
                mapString = v.getString();
            }
            if (mapString != null) {
                for (int ii = 0; ii < mapString.length(); ++ii) {
                    map[ii + previousSize + 1] = mapString.charAt(ii);
                }
            }
            previousSize = mapSizeReturned;
        } while ((mapSizeReturned += newSizeReturned) < mapSizeTotal);
        return new ForeignIdInfo(map, rangeSize, mapOwner);
    }

    private ListReader broker(String query) throws SQLException {
        assert (!this.m_conn.isClosed());
        try {
            ListReader r;
            try {
                r = this.classMethodList("%BigData.ShardingManager", "%BrokerShardOp", "SQ", query, 3);
            }
            catch (RuntimeException e) {
                if (!e.getMessage().contains("<PARAMETER>")) {
                    throw e;
                }
                r = this.classMethodList("%BigData.ShardingManager", "%BrokerShardOp", "SQ", query);
            }
            Object o = r.getObject();
            if (!(o instanceof Long) || (Long)o != 1L) {
                throw new SQLException(r.getString());
            }
            return r;
        }
        catch (RuntimeException e) {
            Utilities.log("Exception calling %sBrokerShardOp(): %s", "%", e.getMessage());
            ListWriter b = new ListWriter(this.m_conn.getServerLocale());
            b.set(query);
            b.set(0);
            b.set(1);
            if (this.m_addr.host.startsWith("SHM|")) {
                b.set("127.0.0.1");
            } else {
                b.set(this.m_addr.host);
            }
            b.set(this.m_addr.port);
            b.set(this.m_addr.namespace);
            b.set(0);
            return new ListReader(b);
        }
    }

    private ListReader shardMapRanges(String mapOwner, int firstRange) throws SQLException {
        assert (!this.m_conn.isClosed());
        try {
            ListReader r = this.classMethodList("%BigData.ShardingManager", "%GetShardMapRanges", "SQ", mapOwner, firstRange);
            Object o = r.getObject();
            if (!(o instanceof Long) || (Long)o != 1L) {
                throw new SQLException(r.getString());
            }
            return r;
        }
        catch (RuntimeException e) {
            Utilities.log("Exception calling %GetShardMapRanges():%s", e.getMessage());
            ListWriter b = new ListWriter(this.m_conn.getServerLocale());
            b.set(0);
            b.set(0);
            b.set(0);
            return new ListReader(b);
        }
    }

    public List<Factor> getFactors(List<String> queries, int mfpi) throws SQLException {
        assert (!this.m_conn.isClosed());
        int n = queries.size();
        try {
            Object[] a = new Object[1 + n];
            queries.toArray(a);
            a[n] = a[0];
            a[0] = mfpi;
            ListReader r = this.functionList("qsetpart", "%apiSQL", a);
            Factor[] f = new Factor[r.getInt()];
            for (int i = 0; i < f.length; ++i) {
                f[i] = this.getFactor(r);
            }
            return Arrays.asList(f);
        }
        catch (RuntimeException e) {
            Utilities.log("Exception calling qsetpart^apiSQL():" + e.getMessage(), new Object[0]);
            Factor[] f = new Factor[n];
            for (int i = 0; i < n; ++i) {
                f[i] = new Factor(queries.get(i), this.m_addr);
            }
            return Arrays.asList(f);
        }
    }

    private Address getAddress(ListReader list, int brokerShardOpVersion) throws SQLException {
        return new Address(list.getString(), Integer.parseInt(list.getString()), list.getString(), brokerShardOpVersion <= -2 ? list.getString() : this.m_addr.user, brokerShardOpVersion < 0 ? list.getString() : this.m_addr.password, this.m_addr.logFile).normalize();
    }

    private Address getAddress1(ListReader list) throws SQLException {
        String host = list.getString();
        int port = Integer.parseInt(list.getString());
        String namespace = list.getString();
        int webserverport = list.getInt();
        String ver1 = list.getString();
        String ver2 = list.getString();
        return new Address(host, port, namespace, this.m_addr.user, this.m_addr.password, this.m_addr.logFile).normalize();
    }

    private Factor getFactor(ListReader list) throws SQLException {
        return new Factor(list.getString(), this.getAddress1(list));
    }

    private List<Factor> prune(Factor[] factors, int[] key) {
        if (key.length == 0 && !this.m_conn.conParams.autobalance) {
            ArrayList<Factor> list = new ArrayList<Factor>(factors.length);
            for (Factor f : factors) {
                if (!f.address.isLocal()) continue;
                list.add(f);
            }
            if (!list.isEmpty()) {
                return list;
            }
        }
        return Arrays.asList(factors);
    }

    private ListReader classMethodList(String klass, String method, Object ... args) throws SQLException {
        byte[] x = this.m_iris.classMethodBytes(klass, method, args);
        return new ListReader(x, x.length, this.m_conn.getServerLocale());
    }

    private ListReader functionList(String func, String routine, Object ... args) throws SQLException {
        byte[] x = this.m_iris.functionBytes(func, routine, args);
        return new ListReader(x, x.length, this.m_conn.getServerLocale());
    }

    public String toString() {
        return this.m_addr.toString();
    }
}

