/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.jdbc.ConnectionParameters;
import com.intersystems.jdbc.IRISConnection;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.ISCRecord;
import com.intersystems.sqf.Pipe;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PipeJDBC
implements Pipe {
    final Connection m_conn;
    final PreparedStatement m_prep;
    final List<Integer> m_index = new ArrayList<Integer>(1024);
    final ArrayList<ISCRecord> m_records = new ArrayList();

    public PipeJDBC(Address shard, String query, ConnectionParameters conParams) throws SQLException {
        String l = conParams.getLogFileName();
        if (l != null && !l.isEmpty()) {
            l = String.format("%s.%d.%s.%s", shard.host, shard.port, shard.namespace, l);
            l = l.replace('|', '_');
        }
        try {
            this.m_conn = IRISConnection.internalPipedConnection(shard, conParams, l);
        }
        catch (SQLException e) {
            throw new SQLException("[InterSystems IRIS JDBC] Failed to connect to instance " + shard, e);
        }
        this.m_prep = this.m_conn.prepareStatement(query);
    }

    @Override
    public int insert(ISCRecord record) throws SQLException {
        assert (!this.m_prep.isClosed());
        int ordinal = 1;
        for (Object f : record.fields) {
            this.m_prep.setObject(ordinal++, f);
        }
        int n = this.m_prep.executeUpdate();
        this.m_index.clear();
        this.m_records.clear();
        return n;
    }

    @Override
    public void sink(ISCRecord record) throws SQLException {
        assert (!this.m_prep.isClosed());
        assert (record.offset >= 0);
        this.m_index.add(record.offset);
        this.m_records.add(record);
    }

    @Override
    public void flush(int[] results) throws SQLException {
        assert (results.length >= this.m_index.size());
        assert (!this.m_prep.isClosed());
        try {
            if (this.m_records.size() > 0) {
                int ncol = this.m_records.get((int)0).fields.length;
                for (int j = 0; j < ncol; ++j) {
                    ArrayList<Object> col = new ArrayList<Object>();
                    for (ISCRecord r : this.m_records) {
                        col.add(r.fields[j]);
                    }
                    this.m_prep.setObject(j + 1, col);
                }
                this.m_prep.addBatch();
            }
            int[] row = this.m_prep.executeBatch();
            this.merge(results, row);
        }
        catch (BatchUpdateException e) {
            this.merge(results, e.getUpdateCounts());
            throw e;
        }
        finally {
            this.m_index.clear();
            this.m_records.clear();
        }
    }

    private void merge(int[] global, int[] local) {
        assert (local.length == this.m_index.size());
        int j = 0;
        for (int i : this.m_index) {
            global[i] = local[j++];
        }
    }

    @Override
    public void close() throws SQLException {
        this.m_prep.close();
        this.m_conn.close();
    }
}

