/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.sqf;

import com.intersystems.sqf.AbstractSharder;
import com.intersystems.sqf.Address;
import com.intersystems.sqf.Factor;
import com.intersystems.sqf.ISCRecord;
import java.util.List;
import java.util.Random;

public class RoundRobinSharder
extends AbstractSharder {
    int m_size;
    int m_next;

    public RoundRobinSharder(List<Factor> factors, int[] fields, int[] bounds, int[] map, String query, Address addr) {
        super(factors, fields, bounds, map, query, addr);
        this.m_size = this.m_factors.size();
        this.m_next = new Random().nextInt(this.m_size);
    }

    @Override
    public synchronized int getFactor(ISCRecord record) {
        if (this.m_next == this.m_size) {
            this.m_next = 0;
        }
        return this.m_next++;
    }

    @Override
    void dump(StringBuilder sb) {
        this.dump(sb, "method ", "round-robbin");
        super.dump(sb);
    }
}

