/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.util;

import java.net.InetAddress;

public class MachineInfo {
    private static final String loopBackAddress = "127.0.0.1";
    private static String exeName = "java.exe";
    private static String ipAddress;
    private static String[] ipAddressArray;
    private static String hostName;
    private static String myUserName;
    private static String osName;

    private static void setIPAddress() {
        InetAddress[] iptest = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostName = ia.getHostName();
            ipAddress = ia.getHostAddress();
            iptest = InetAddress.getAllByName(hostName);
            ipAddressArray = new String[iptest.length];
            for (int counter = 0; counter < iptest.length; ++counter) {
                MachineInfo.ipAddressArray[counter] = iptest[counter].getHostAddress();
            }
        }
        catch (Exception e) {
            hostName = "localhost";
            ipAddress = loopBackAddress;
            ipAddressArray = new String[1];
            MachineInfo.ipAddressArray[0] = loopBackAddress;
        }
    }

    public static String getIPAddress(String connectIP) {
        if (connectIP.regionMatches(0, loopBackAddress, 0, 4)) {
            return loopBackAddress;
        }
        for (int counter = 0; counter < ipAddressArray.length; ++counter) {
            if (!ipAddressArray[counter].regionMatches(0, connectIP, 0, ipAddressArray[counter].length())) continue;
            return loopBackAddress;
        }
        return ipAddress;
    }

    public static String getUserName() {
        return myUserName;
    }

    private static void setUserName() {
        myUserName = System.getProperty("user.name");
    }

    public static String getMachineName() {
        return hostName;
    }

    public static String getExeName() {
        return exeName;
    }

    private static void setExeName() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        exeName = stack[stack.length - 1].getClassName();
    }

    public static String getOSName() {
        return osName;
    }

    public static void main(String[] args) {
        System.out.print("\nMachineInfo class\n");
        String test = MachineInfo.getIPAddress("192.168.1.101");
        System.out.print("\n" + test + "\n");
        System.out.print("\nUser Name: " + MachineInfo.getUserName() + "\n");
        System.out.print("\nHost Name: " + MachineInfo.getMachineName() + "\n");
        System.out.print("\nInitial Class Application Name: " + MachineInfo.getExeName() + "\n");
    }

    static {
        ipAddressArray = null;
        osName = System.getProperty("os.name").toUpperCase();
        MachineInfo.setExeName();
        MachineInfo.setIPAddress();
        MachineInfo.setUserName();
    }
}

