/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class VersionInfo {
    private static final int MAJOR;
    private static final int MINOR;
    private static final int PATCH;
    private static final int BUILD;
    private static final String CLIENT;
    private static final String JAR;
    private static final String BUILT;

    private static Attributes getAttributes() {
        try {
            Enumeration<URL> e = VersionInfo.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                Attributes a = new Manifest(e.nextElement().openStream()).getMainAttributes();
                if (!"intersystems-jdbc".equals(a.getValue("Artifact-Id"))) continue;
                return a;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Attributes(){

            @Override
            public String get(Object o) {
                return "0";
            }
        };
    }

    public static int getMinorVersion() {
        return MINOR;
    }

    public static int getMajorVersion() {
        return MAJOR;
    }

    public static int getPatchNumber() {
        return PATCH;
    }

    public static int getBuildNumber() {
        return BUILD;
    }

    public static String getClientVersion() {
        return CLIENT;
    }

    public static String getJarFileName() {
        return JAR;
    }

    public static String compiledAt() {
        return BUILT;
    }

    public static String getJDBCVersion() {
        return "4.2";
    }

    public static int getJDBCMajorVersion() {
        return 4;
    }

    public static int getJDBCMinorVersion() {
        return 2;
    }

    static {
        Attributes a = VersionInfo.getAttributes();
        MAJOR = Integer.parseInt(a.getValue("Version-Major"));
        MINOR = Integer.parseInt(a.getValue("Version-Minor"));
        PATCH = Integer.parseInt(a.getValue("Version-Patch"));
        BUILD = 0;
        CLIENT = String.format("%d.%d.%d.%d", MAJOR, MINOR, PATCH, BUILD);
        JAR = String.format("intersystems-jdbc-%s.jar", a.getValue("Implementation-Version"));
        BUILT = a.getValue("Built");
    }
}

