/*
 * Decompiled with CFR 0.152.
 */
package com.intersystems.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;

public class XMLClassGenerator {
    private StringWriter writer;
    private boolean closedElement = true;

    public void saveMethod(Object method) {
        this.endElement("Method");
    }

    public Object createEmptyClass(String name) {
        this.writer = new StringWriter();
        this.closedElement = true;
        this.startDocument();
        this.startElement("Export");
        this.addAttribute("generator", "Cache");
        this.addAttribute("version", "23");
        this.startElement("Class");
        this.addAttribute("name", name);
        return this.writer;
    }

    public void addSuper(Object classDef, String name) {
        this.startElement("Super");
        this.writeElement(name);
        this.endElement("Super");
    }

    public void addDdlAllowed(Object classDef) {
        this.startElement("DdlAllowed");
        this.writeElement("1");
        this.endElement("DdlAllowed");
    }

    public void makeAbstract(Object classDef) {
        this.startElement("Abstract");
        this.writeElement("1");
        this.endElement("Abstract");
    }

    public void useProcedureBlock(Object classDef, boolean yesno) {
        this.startElement("ProcedureBlock");
        if (yesno) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("ProcedureBlock");
    }

    public void defineReturnType(Object method, String type) {
        this.startElement("ReturnType");
        this.writeElement(type);
        this.endElement("ReturnType");
    }

    public void defineIsFinal(Object def, boolean isFinal) {
        this.startElement("Final");
        if (isFinal) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("Final");
    }

    public void defineIsStatic(Object method, boolean isStatic) {
        this.startElement("ClassMethod");
        if (isStatic) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("ClassMethod");
    }

    public void defineBody(Object method, String body) {
        this.startElement("Implementation");
        this.startCDATA();
        this.writeElement(body);
        this.endCDATA();
        this.endElement("Implementation");
        this.endElement("Method");
    }

    public void defineArguments(Object method, String[] types, String[] names, boolean[] byRef, String[] defaultValues) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (byRef[i]) {
                buffer.append("&");
            }
            buffer.append(names[i]);
            buffer.append(":");
            buffer.append(types[i]);
            if (defaultValues != null && defaultValues[i] != null) {
                buffer.append("=").append(defaultValues[i]);
            }
            if (i == types.length - 1) continue;
            buffer.append(",");
        }
        this.startElement("FormalSpec");
        this.startCDATA();
        this.writeElement(buffer.toString());
        this.endCDATA();
        this.endElement("FormalSpec");
    }

    public Object createMethod(Object classDef, String name) {
        this.startElement("Method");
        this.addAttribute("name", name);
        return classDef;
    }

    public Object createComment(Object classDef, List<String> commentText) {
        this.startElement("UDLText");
        this.addAttribute("name", "T");
        this.startElement("Content");
        this.startCDATA();
        for (int i = 0; i < commentText.size(); ++i) {
            this.writer.write("///" + commentText.get(i) + "\n");
        }
        this.endCDATA();
        this.endElement("Content");
        this.endElement("UDLText");
        return classDef;
    }

    public void writeEnumValueList(Class<?> enumType) {
        String enumOptions = "";
        ?[] ob = enumType.getEnumConstants();
        for (int i = 0; i < ob.length; ++i) {
            enumOptions = enumOptions + "," + ob[i].toString();
        }
        if (enumOptions != "") {
            this.startElement("Parameter");
            this.addAttribute("name", "VALUELIST");
            this.addAttribute("value", enumOptions);
            this.endElement("Parameter");
        }
    }

    public Object createProperty(Object classDef, String name, String type, Class<?> javaType) {
        this.startElement("Property");
        this.addAttribute("name", name);
        if (type.startsWith("list ")) {
            type = type.substring(5);
            this.startElement("Collection");
            this.writeElement("list");
            this.endElement("Collection");
        }
        if (type.startsWith("array ")) {
            type = type.substring(6);
            this.startElement("Collection");
            this.writeElement("array");
            this.endElement("Collection");
            this.startElement("Parameter");
            this.addAttribute("name", "STORAGEDEFAULT");
            this.addAttribute("value", "list");
            this.endElement("Parameter");
        }
        this.startElement("Type");
        this.writeElement(type);
        this.endElement("Type");
        if (type.equals("%Library.String")) {
            this.startElement("Parameter");
            this.addAttribute("name", "MAXLEN");
            this.addAttribute("value", "10000");
            this.endElement("Parameter");
        }
        if (javaType.isEnum()) {
            this.writeEnumValueList(javaType);
        } else if (javaType.isArray() && javaType.getComponentType().isEnum()) {
            this.writeEnumValueList(javaType.getComponentType());
        }
        this.endElement("Property");
        return classDef;
    }

    public Object createParameter(Object classDef, String name, String value) {
        this.startElement("Parameter");
        this.addAttribute("name", name);
        this.startElement("Type");
        this.writeElement("STRING");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(value);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return classDef;
    }

    public Object createParameter(Object classDef, String name, int value) {
        String stringValue = String.valueOf(value);
        this.startElement("Parameter");
        this.addAttribute("name", name);
        this.startElement("Type");
        this.writeElement("INTEGER");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(stringValue);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return classDef;
    }

    public Object createParameter(Object classDef, String name, boolean value) {
        String stringValue = "true";
        if (!value) {
            stringValue = "false";
        }
        this.startElement("Parameter");
        this.addAttribute("name", name);
        this.startElement("Type");
        this.writeElement("BOOLEAN");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(stringValue);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return classDef;
    }

    public Object createClassParameter(Object classDef, String name, Object value, String type) {
        if (type.equals("BOOLEAN") && value instanceof Boolean) {
            return this.createParameter(classDef, name, (Boolean)value);
        }
        if (type.equals("INTEGER") && value instanceof Integer) {
            return this.createParameter(classDef, name, (Integer)value);
        }
        if (type.equals("STRING") && value instanceof String) {
            return this.createParameter(classDef, name, (String)value);
        }
        throw new RuntimeException("Unsupported parameter type");
    }

    public Object createIndex(Object classDef, String name, String properties, String type) {
        this.startElement("Index");
        this.addAttribute("name", name);
        this.startElement("Properties");
        this.writeElement(properties);
        this.endElement("Properties");
        this.startElement("Type");
        this.writeElement(type);
        this.endElement("Type");
        this.endElement("Index");
        return classDef;
    }

    public Object createIdKey(Object classDef, String name, String properties) {
        this.startElement("Index");
        this.addAttribute("name", name);
        this.startElement("IdKey");
        this.writeElement("1");
        this.endElement("IdKey");
        this.startElement("Properties");
        this.writeElement(properties);
        this.endElement("Properties");
        this.endElement("Index");
        return classDef;
    }

    public Object createIndex(Object classDef, String name, String properties) {
        this.startElement("Index");
        this.addAttribute("name", name);
        this.startElement("Properties");
        this.writeElement(properties);
        this.endElement("Properties");
        this.endElement("Index");
        return classDef;
    }

    public Object createStorage(Object classDef, String name, String[] properties, String dataLocation, String idLocation, String indexLocation, String streamLocation, String defaultDataLocation) {
        this.startElement("Storage");
        this.addAttribute("name", "Default");
        this.startElement("Type");
        this.writeElement("%Library.CacheStorage");
        this.endElement("Type");
        this.startElement("DataLocation");
        this.writeElement(dataLocation);
        this.endElement("DataLocation");
        this.startElement("DefaultData");
        this.writeElement(name + "DefaultData");
        this.endElement("DefaultData");
        this.startElement("IdLocation");
        this.writeElement(idLocation);
        this.endElement("IdLocation");
        this.startElement("IndexLocation");
        this.writeElement(indexLocation);
        this.endElement("IndexLocation");
        this.startElement("StreamLocation");
        this.writeElement(streamLocation);
        this.endElement("StreamLocation");
        this.startElement("Data");
        this.addAttribute("name", defaultDataLocation);
        for (int i = 0; i < properties.length; ++i) {
            this.startElement("Value");
            this.addAttribute("name", Integer.toString(i + 1));
            this.startElement("Value");
            this.writeElement(properties[i]);
            this.endElement("Value");
            this.endElement("Value");
        }
        this.endElement("Data");
        this.endElement("Storage");
        return classDef;
    }

    public Object createStorage(Object classDef, String name, String[] properties, String defaultDataLocation) {
        this.startElement("Storage");
        this.addAttribute("name", "Default");
        this.startElement("Type");
        this.writeElement("%Library.CacheStorage");
        this.endElement("Type");
        this.endElement("Storage");
        return classDef;
    }

    public Object setSqlTableName(Object classDef, String name) {
        this.startElement("SqlTableName");
        this.writeElement(name);
        this.endElement("SqlTableName");
        return classDef;
    }

    public Object setClassType(Object classDef, String type) {
        this.startElement("ClassType");
        this.writeElement(type);
        this.endElement("ClassType");
        return classDef;
    }

    public void defineSystem(Object def, int value) {
        this.startElement("System");
        if (value == 4) {
            this.writeElement('4');
        } else if (value == 3) {
            this.writeElement('3');
        }
        this.endElement("System");
    }

    public Reader saveClass(Object classDef) {
        this.endElement("Class");
        this.endElement("Export");
        this.writer.flush();
        return new StringReader(this.writer.toString());
    }

    public String saveAsString(Object classDef) {
        this.endElement("Class");
        this.endElement("Export");
        this.writer.flush();
        return this.writer.toString();
    }

    public File saveAsFile(Object classDef, String className) throws Exception {
        this.endElement("Class");
        this.endElement("Export");
        this.writer.flush();
        String millis = Long.toString(System.currentTimeMillis());
        File file = File.createTempFile(className + millis, ".xml");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.writer.toString());
        fileWriter.close();
        return file;
    }

    public void defineArguments(Object method, String[] types, String[] names) {
        boolean[] byRef = new boolean[types.length];
        for (int i = 0; i < byRef.length; ++i) {
            byRef[i] = false;
        }
        String[] defaultValues = new String[types.length];
        this.defineArguments(method, types, names, byRef, defaultValues);
    }

    private void addAttribute(String name, String value) {
        this.writer.write(" " + name + "=\"" + value + "\"");
    }

    private void startElement(String name) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write("\r\n<" + name);
        this.closedElement = false;
    }

    private void endElement(String name) {
        if (this.closedElement) {
            this.writer.write("</" + name + ">");
        } else {
            this.writer.write("></" + name + ">");
            this.closedElement = true;
        }
    }

    private void writeElement(String data) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write(data);
    }

    private void writeElement(char data) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write(data);
    }

    private void startCDATA() {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write("<![CDATA[");
    }

    private void endCDATA() {
        this.writer.write("]]>");
    }

    private void startDocument() {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }
}

