/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.autoconfigure;

import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaAutoConfiguration;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaConfigurer;
import com.introproventures.graphql.jpa.query.autoconfigure.JavaScalarsRuntimeWiringConfigurer;
import graphql.GraphQL;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.graphql.ConditionalOnGraphQlSchema;
import org.springframework.boot.autoconfigure.graphql.GraphQlAutoConfiguration;
import org.springframework.boot.autoconfigure.graphql.GraphQlProperties;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;

@AutoConfiguration(before={GraphQlAutoConfiguration.class, GraphQLSchemaAutoConfiguration.class})
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class, GraphQLSchemaConfigurer.class})
@ConditionalOnProperty(name={"spring.graphql.jpa.query.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GraphQlProperties.class})
public class GraphQLJpaQueryGraphQlSourceAutoConfiguration {
    @Bean
    @ConditionalOnGraphQlSchema
    GraphQLSchemaConfigurer graphQlSourceSchemaConfigurer(ListableBeanFactory beanFactory, ResourcePatternResolver resourcePatternResolver, GraphQlProperties properties, ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, ObjectProvider<Instrumentation> instrumentations, ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers) {
        return registry -> {
            GraphQlAutoConfiguration graphQlAutoConfiguration = new GraphQlAutoConfiguration(beanFactory);
            GraphQlSource graphQlSource = graphQlAutoConfiguration.graphQlSource(resourcePatternResolver, properties, exceptionResolvers, subscriptionExceptionResolvers, instrumentations, wiringConfigurers, sourceCustomizers);
            registry.register(graphQlSource.schema());
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQlSource graphQlSource(GraphQLSchema graphQLSchema, ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, ObjectProvider<Instrumentation> instrumentations, ObjectProvider<Consumer<GraphQL.Builder>> configurers) {
        GraphQlSource.Builder builder = GraphQlSource.builder((GraphQLSchema)graphQLSchema);
        builder.exceptionResolvers(exceptionResolvers.orderedStream().collect(Collectors.toList())).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().collect(Collectors.toList())).instrumentation(instrumentations.orderedStream().collect(Collectors.toList()));
        configurers.orderedStream().forEach(arg_0 -> ((GraphQlSource.Builder)builder).configureGraphQl(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public JavaScalarsRuntimeWiringConfigurer javaScalarsRuntimeWiringConfigurer() {
        return new JavaScalarsRuntimeWiringConfigurer();
    }
}

