/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.autoconfigure;

import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJpaQueryProperties;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaBuilderAutoConfiguration;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaConfigurer;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaFactoryBean;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLShemaRegistration;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLShemaRegistrationImpl;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={GraphQLSchemaBuilderAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLJpaQueryProperties.class})
@ConditionalOnClass(value={GraphQL.class})
@ConditionalOnProperty(name={"spring.graphql.jpa.query.enabled"}, havingValue="true", matchIfMissing=true)
public class GraphQLSchemaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphQLShemaRegistration graphQLShemaRegistration() {
        return new GraphQLShemaRegistrationImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={GraphQLSchema.class})
    public GraphQLSchemaFactoryBean graphQLSchemaFactoryBean(GraphQLJpaQueryProperties properties, GraphQLShemaRegistration graphQLShemaRegistration, ObjectProvider<GraphQLSchemaConfigurer> graphQLSchemaConfigurers) {
        for (GraphQLSchemaConfigurer configurer : graphQLSchemaConfigurers) {
            configurer.configure(graphQLShemaRegistration);
        }
        return new GraphQLSchemaFactoryBean(graphQLShemaRegistration.getManagedGraphQLSchemas()).setQueryName(properties.getName()).setQueryDescription(properties.getDescription());
    }
}

