/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.autoconfigure;

import com.introproventures.graphql.jpa.query.autoconfigure.EnableGraphQLJpaQuerySchemaImportSelector;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJPASchemaBuilderCustomizer;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJpaQueryGraphQlSourceAutoConfiguration;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJpaQueryProperties;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaAutoConfiguration;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaConfigurer;
import com.introproventures.graphql.jpa.query.schema.GraphQLSchemaBuilder;
import com.introproventures.graphql.jpa.query.schema.RestrictedKeysProvider;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaSchemaBuilder;
import graphql.GraphQL;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

@AutoConfiguration(before={GraphQLSchemaAutoConfiguration.class, GraphQLJpaQueryGraphQlSourceAutoConfiguration.class}, after={HibernateJpaAutoConfiguration.class})
@ConditionalOnClass(value={EntityManagerFactory.class, GraphQL.class, GraphQLSchemaBuilder.class})
@ConditionalOnProperty(name={"spring.graphql.jpa.query.enabled"}, havingValue="true", matchIfMissing=true)
public class GraphQLSchemaBuilderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSingleCandidate(value=EntityManagerFactory.class)
    GraphQLJpaSchemaBuilder defaultGraphQLJpaSchemaBuilder(EntityManagerFactory entityManagerFactory, GraphQLJpaQueryProperties properties, ObjectProvider<RestrictedKeysProvider> restrictedKeysProvider) {
        EntityManager entityManager = SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)entityManagerFactory);
        GraphQLJpaSchemaBuilder builder = new GraphQLJpaSchemaBuilder(entityManager);
        builder.name(properties.getName()).description(properties.getDescription()).defaultDistinct(properties.isDefaultDistinct()).useDistinctParameter(properties.isUseDistinctParameter()).toManyDefaultOptional(properties.isToManyDefaultOptional()).enableRelay(properties.isEnableRelay());
        EnableGraphQLJpaQuerySchemaImportSelector.getPackageNames().stream().forEach(arg_0 -> ((GraphQLJpaSchemaBuilder)builder).entityPath(arg_0));
        restrictedKeysProvider.ifAvailable(arg_0 -> ((GraphQLJpaSchemaBuilder)builder).restrictedKeysProvider(arg_0));
        return builder;
    }

    @Bean
    @ConditionalOnSingleCandidate(value=GraphQLSchemaBuilder.class)
    GraphQLSchemaConfigurer defaultGraphQLJpaSchemaBuilderConfigurer(GraphQLJpaSchemaBuilder builder, ObjectProvider<GraphQLJPASchemaBuilderCustomizer> customizer) {
        return registry -> {
            customizer.ifAvailable(it -> it.customize(builder));
            registry.register(builder.build());
        };
    }
}

