/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.autoconfigure;

import com.introproventures.graphql.jpa.query.autoconfigure.TypeTraverser;
import graphql.Assert;
import graphql.Internal;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class GraphQLSchemaFactoryBean
extends AbstractFactoryBean<GraphQLSchema> {
    private static final String QUERY_NAME = "Query";
    private static final String QUERY_DESCRIPTION = "";
    private static final String SUBSCRIPTION_NAME = "Subscription";
    private static final String SUBSCRIPTION_DESCRIPTION = "";
    private static final String MUTATION_NAME = "Mutation";
    private static final String MUTATION_DESCRIPTION = "";
    private final GraphQLSchema[] managedGraphQLSchemas;
    private String queryName = "Query";
    private String queryDescription = "";
    private String subscriptionName = "Subscription";
    private String subscriptionDescription = "";
    private String mutationName = "Mutation";
    private String mutationDescription = "";

    public GraphQLSchemaFactoryBean(GraphQLSchema[] managedGraphQLSchemas) {
        this.managedGraphQLSchemas = managedGraphQLSchemas;
    }

    protected GraphQLSchema createInstance() throws Exception {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
        TypeTraverser typeTraverser = new TypeTraverser();
        List mutations = Stream.of(this.managedGraphQLSchemas).filter(it -> it.getMutationType() != null).peek(schema -> schema.getCodeRegistry().transform(builderConsumer -> typeTraverser.depthFirst((GraphQLTypeVisitor)new CodeRegistryVisitor((GraphQLCodeRegistry.Builder)builderConsumer, codeRegistryBuilder, (GraphQLFieldsContainer)schema.getMutationType(), this.mutationName), (GraphQLSchemaElement)schema.getMutationType()))).map(GraphQLSchema::getMutationType).filter(Objects::nonNull).map(GraphQLObjectType::getFieldDefinitions).flatMap(Collection::stream).collect(Collectors.toList());
        List queries = Stream.of(this.managedGraphQLSchemas).filter(it -> Optional.ofNullable(it.getQueryType()).map(GraphQLNamedSchemaElement::getName).filter(name -> !"null".equals(name)).isPresent()).peek(schema -> schema.getCodeRegistry().transform(builderConsumer -> typeTraverser.depthFirst((GraphQLTypeVisitor)new CodeRegistryVisitor((GraphQLCodeRegistry.Builder)builderConsumer, codeRegistryBuilder, (GraphQLFieldsContainer)schema.getQueryType(), this.queryName), (GraphQLSchemaElement)schema.getQueryType()))).map(GraphQLSchema::getQueryType).map(GraphQLObjectType::getFieldDefinitions).flatMap(Collection::stream).collect(Collectors.toList());
        List subscriptions = Stream.of(this.managedGraphQLSchemas).filter(it -> it.getSubscriptionType() != null).peek(schema -> schema.getCodeRegistry().transform(builderConsumer -> typeTraverser.depthFirst((GraphQLTypeVisitor)new CodeRegistryVisitor((GraphQLCodeRegistry.Builder)builderConsumer, codeRegistryBuilder, (GraphQLFieldsContainer)schema.getSubscriptionType(), this.subscriptionName), (GraphQLSchemaElement)schema.getSubscriptionType()))).map(GraphQLSchema::getSubscriptionType).map(GraphQLObjectType::getFieldDefinitions).flatMap(Collection::stream).collect(Collectors.toList());
        Set directives = Stream.of(this.managedGraphQLSchemas).map(GraphQLSchema::getDirectives).flatMap(Collection::stream).filter(this.distinctByKeys(GraphQLDirective::getName)).collect(Collectors.toSet());
        if (!directives.isEmpty()) {
            schemaBuilder.additionalDirectives(directives);
        }
        Set types = Stream.of(this.managedGraphQLSchemas).map(GraphQLSchema::getAdditionalTypes).flatMap(Collection::stream).map(GraphQLNamedType.class::cast).filter(this.distinctByKeys(GraphQLNamedSchemaElement::getName)).collect(Collectors.toSet());
        if (!types.isEmpty()) {
            schemaBuilder.additionalTypes(types);
        }
        if (!mutations.isEmpty()) {
            schemaBuilder.mutation(GraphQLObjectType.newObject().name(this.mutationName).description(this.mutationDescription).fields(mutations));
        }
        if (!queries.isEmpty()) {
            schemaBuilder.query(GraphQLObjectType.newObject().name(this.queryName).description(this.queryDescription).fields(queries));
        }
        if (!subscriptions.isEmpty()) {
            schemaBuilder.subscription(GraphQLObjectType.newObject().name(this.subscriptionName).description(this.subscriptionDescription).fields(subscriptions));
        }
        return schemaBuilder.codeRegistry(codeRegistryBuilder.build()).build();
    }

    private <T> Predicate<T> distinctByKeys(Function<? super T, ?> ... keyExtractors) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> {
            List keys = Arrays.stream(keyExtractors).map(ke -> ke.apply(t)).collect(Collectors.toList());
            return seen.putIfAbsent(keys, Boolean.TRUE) == null;
        };
    }

    public Class<?> getObjectType() {
        return GraphQLSchema.class;
    }

    public GraphQLSchemaFactoryBean setQueryName(String name) {
        this.queryName = name;
        return this;
    }

    public GraphQLSchemaFactoryBean setQueryDescription(String description) {
        this.queryDescription = description;
        return this;
    }

    public GraphQLSchemaFactoryBean setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public GraphQLSchemaFactoryBean setSubscriptionDescription(String subscriptionDescription) {
        this.subscriptionDescription = subscriptionDescription;
        return this;
    }

    public GraphQLSchemaFactoryBean setMutationName(String mutationName) {
        this.mutationName = mutationName;
        return this;
    }

    public GraphQLSchemaFactoryBean setMutationDescription(String mutationDescription) {
        this.mutationDescription = mutationDescription;
        return this;
    }

    @Internal
    class CodeRegistryVisitor
    extends GraphQLTypeVisitorStub {
        private final GraphQLCodeRegistry.Builder source;
        private final GraphQLCodeRegistry.Builder codeRegistry;
        private final GraphQLFieldsContainer containerType;
        private final String typeName;

        CodeRegistryVisitor(GraphQLCodeRegistry.Builder context, GraphQLCodeRegistry.Builder codeRegistry, GraphQLFieldsContainer containerType, String typeName) {
            this.source = context;
            this.codeRegistry = codeRegistry;
            this.containerType = containerType;
            this.typeName = typeName;
        }

        public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
            GraphQLFieldsContainer parentContainerType = (GraphQLFieldsContainer)context.getParentContext().thisNode();
            FieldCoordinates coordinates = parentContainerType.equals(this.containerType) ? FieldCoordinates.coordinates((String)this.typeName, (String)node.getName()) : FieldCoordinates.coordinates((GraphQLFieldsContainer)parentContainerType, (GraphQLFieldDefinition)node);
            DataFetcher dataFetcher = this.source.getDataFetcher(parentContainerType, node);
            if (dataFetcher == null) {
                dataFetcher = new PropertyDataFetcher(node.getName());
            }
            this.codeRegistry.dataFetcherIfAbsent(coordinates, dataFetcher);
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
            TypeResolver typeResolver = this.codeRegistry.getTypeResolver(node);
            if (typeResolver != null) {
                this.codeRegistry.typeResolverIfAbsent(node, typeResolver);
            }
            Assert.assertTrue((this.codeRegistry.getTypeResolver(node) != null ? 1 : 0) != 0, () -> "You MUST provide a type resolver for the interface type '" + node.getName() + "'");
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
            TypeResolver typeResolver = this.codeRegistry.getTypeResolver(node);
            if (typeResolver != null) {
                this.codeRegistry.typeResolverIfAbsent(node, typeResolver);
            }
            Assert.assertTrue((this.codeRegistry.getTypeResolver(node) != null ? 1 : 0) != 0, () -> "You MUST provide a type resolver for the union type '" + node.getName() + "'");
            return TraversalControl.CONTINUE;
        }
    }
}

