/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Objects;

public class AnnotationDescriptor {
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationType;
    private final ElementType[] elementTypes;
    private final RetentionPolicy policy;
    private final boolean isDocumented;
    private final boolean isInherited;

    public <A extends Annotation> AnnotationDescriptor(A annotation) {
        this.annotation = annotation;
        this.annotationType = annotation.annotationType();
        Target target = this.annotationType.getAnnotation(Target.class);
        this.elementTypes = target == null ? ElementType.values() : target.value();
        Retention retention = this.annotationType.getAnnotation(Retention.class);
        this.policy = retention == null ? RetentionPolicy.CLASS : retention.value();
        Documented documented = this.annotationType.getAnnotation(Documented.class);
        this.isDocumented = documented != null;
        Inherited inherited = this.annotationType.getAnnotation(Inherited.class);
        this.isInherited = inherited != null;
    }

    public <A extends Annotation> A getAnnotation() {
        return (A)this.annotation;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public ElementType[] getElementTypes() {
        return this.elementTypes;
    }

    public RetentionPolicy getPolicy() {
        return this.policy;
    }

    public boolean isDocumented() {
        return this.isDocumented;
    }

    public boolean isInherited() {
        return this.isInherited;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotationDescriptor [annotation=").append(this.annotation).append(", annotationType=").append(this.annotationType).append(", elementTypes=").append(Arrays.toString((Object[])this.elementTypes)).append(", policy=").append((Object)this.policy).append(", isDocumented=").append(this.isDocumented).append(", isInherited=").append(this.isInherited).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.elementTypes);
        result = 31 * result + Objects.hash(new Object[]{this.annotation, this.annotationType, this.isDocumented, this.isInherited, this.policy});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationDescriptor other = (AnnotationDescriptor)obj;
        return Objects.equals(this.annotation, other.annotation) && Objects.equals(this.annotationType, other.annotationType) && Arrays.equals((Object[])this.elementTypes, (Object[])other.elementTypes) && this.isDocumented == other.isDocumented && this.isInherited == other.isInherited && this.policy == other.policy;
    }
}

