/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.AnnotationDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ArrayUtil;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Annotations {
    protected final AnnotatedElement annotatedElement;
    protected final Map<Class<? extends Annotation>, AnnotationDescriptor> annotationsMap;
    private AnnotationDescriptor[] allAnnotations;

    public Annotations(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
        this.annotationsMap = this.inspectAnnotations();
    }

    private Map<Class<? extends Annotation>, AnnotationDescriptor> inspectAnnotations() {
        Annotation[] annotations = ReflectionUtil.getAnnotation(this.annotatedElement);
        if (ArrayUtil.isEmpty(annotations)) {
            return null;
        }
        LinkedHashMap<Class<? extends Annotation>, AnnotationDescriptor> map = new LinkedHashMap<Class<? extends Annotation>, AnnotationDescriptor>(annotations.length);
        for (Annotation annotation : annotations) {
            map.put(annotation.annotationType(), new AnnotationDescriptor(annotation));
        }
        return map;
    }

    public AnnotationDescriptor getAnnotationDescriptor(Class<? extends Annotation> clazz) {
        if (this.annotationsMap == null) {
            return null;
        }
        return this.annotationsMap.get(clazz);
    }

    public AnnotationDescriptor[] getAllAnnotationDescriptors() {
        if (this.annotationsMap == null) {
            return null;
        }
        if (this.allAnnotations == null) {
            AnnotationDescriptor[] allAnnotations = new AnnotationDescriptor[this.annotationsMap.size()];
            int index = 0;
            Iterator<AnnotationDescriptor> iterator = this.annotationsMap.values().iterator();
            while (iterator.hasNext()) {
                AnnotationDescriptor annotationDescriptor;
                allAnnotations[index] = annotationDescriptor = iterator.next();
                ++index;
            }
            Arrays.sort(allAnnotations, new Comparator<AnnotationDescriptor>(){

                @Override
                public int compare(AnnotationDescriptor ad1, AnnotationDescriptor ad2) {
                    return ad1.getClass().getName().compareTo(ad2.getClass().getName());
                }
            });
            this.allAnnotations = allAnnotations;
        }
        return this.allAnnotations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Annotations [annotatedElement=").append(this.annotatedElement).append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.annotatedElement);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotations other = (Annotations)obj;
        return Objects.equals(this.annotatedElement, other.annotatedElement);
    }
}

