/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import java.lang.reflect.Array;

public class ArrayUtil {
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(Object array) {
        if (array == null) {
            return true;
        }
        if (!array.getClass().isArray()) {
            return false;
        }
        return Array.getLength(array) == 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] addAll(T[] array1, T[] array2) {
        if (array1 == null) {
            return ArrayUtil.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtil.clone(array1);
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type1 = array1.getClass().getComponentType();
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
            }
            throw ase;
        }
        return joinedArray;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }
}

