/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.AnnotationDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassUtil;
import com.introproventures.graphql.jpa.query.introspection.ConstructorDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Constructors;
import com.introproventures.graphql.jpa.query.introspection.FieldDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Fields;
import com.introproventures.graphql.jpa.query.introspection.MethodDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Methods;
import com.introproventures.graphql.jpa.query.introspection.Properties;
import com.introproventures.graphql.jpa.query.introspection.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClassDescriptor {
    protected final Class<?> type;
    protected final boolean scanAccessible;
    protected final boolean scanStatics;
    protected final boolean extendedProperties;
    protected final boolean includeFieldsAsProperties;
    protected final String propertyFieldPrefix;
    protected final Class<?>[] interfaces;
    protected final Class<?>[] superclasses;
    protected int usageCount;
    private final boolean isArray;
    private final boolean isMap;
    private final boolean isList;
    private final boolean isSet;
    private final boolean isCollection;
    private final Fields fields;
    private final Methods methods;
    private final Properties properties;
    private final Constructors constructors;
    private final Annotations annotations;

    public ClassDescriptor(Class<?> type, boolean scanAccessible, boolean extendedProperties, boolean includeFieldsAsProperties, boolean scanStatics, String propertyFieldPrefix) {
        this.type = type;
        this.scanAccessible = scanAccessible;
        this.extendedProperties = extendedProperties;
        this.includeFieldsAsProperties = includeFieldsAsProperties;
        this.propertyFieldPrefix = propertyFieldPrefix;
        this.scanStatics = scanStatics;
        this.isArray = type.isArray();
        this.isMap = Map.class.isAssignableFrom(type);
        this.isList = List.class.isAssignableFrom(type);
        this.isSet = Set.class.isAssignableFrom(type);
        this.isCollection = Collection.class.isAssignableFrom(type);
        this.interfaces = ClassUtil.getAllInterfacesAsArray(type);
        this.superclasses = ClassUtil.getAllSuperclassesAsArray(type);
        this.fields = new Fields(this);
        this.methods = new Methods(this);
        this.properties = new Properties(this);
        this.constructors = new Constructors(this);
        this.annotations = new Annotations(type);
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isScanAccessible() {
        return this.scanAccessible;
    }

    public boolean isExtendedProperties() {
        return this.extendedProperties;
    }

    public boolean isIncludeFieldsAsProperties() {
        return this.includeFieldsAsProperties;
    }

    public String getPropertyFieldPrefix() {
        return this.propertyFieldPrefix;
    }

    protected void increaseUsageCount() {
        ++this.usageCount;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    protected Fields getFields() {
        return this.fields;
    }

    public FieldDescriptor getFieldDescriptor(String name, boolean declared) {
        FieldDescriptor fieldDescriptor = this.getFields().getFieldDescriptor(name);
        if (fieldDescriptor != null && !fieldDescriptor.matchDeclared(declared)) {
            return null;
        }
        return fieldDescriptor;
    }

    public FieldDescriptor[] getAllFieldDescriptors() {
        return this.getFields().getAllFieldDescriptors();
    }

    protected Methods getMethods() {
        return this.methods;
    }

    public MethodDescriptor getMethodDescriptor(String name, boolean declared) {
        MethodDescriptor methodDescriptor = this.getMethods().getMethodDescriptor(name);
        if (methodDescriptor != null && methodDescriptor.matchDeclared(declared)) {
            return methodDescriptor;
        }
        return methodDescriptor;
    }

    public MethodDescriptor getMethodDescriptor(String name, Class<?>[] params, boolean declared) {
        MethodDescriptor methodDescriptor = this.getMethods().getMethodDescriptor(name, params);
        if (methodDescriptor != null && methodDescriptor.matchDeclared(declared)) {
            return methodDescriptor;
        }
        return null;
    }

    public MethodDescriptor[] getAllMethodDescriptors(String name) {
        return this.getMethods().getAllMethodDescriptors(name);
    }

    public MethodDescriptor[] getAllMethodDescriptors() {
        return this.getMethods().getAllMethodDescriptors();
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public PropertyDescriptor getPropertyDescriptor(String name, boolean declared) {
        PropertyDescriptor propertyDescriptor = this.getProperties().getPropertyDescriptor(name);
        if (propertyDescriptor != null && propertyDescriptor.matchDeclared(declared)) {
            return propertyDescriptor;
        }
        return null;
    }

    public PropertyDescriptor[] getAllPropertyDescriptors() {
        return this.getProperties().getAllPropertyDescriptors();
    }

    protected Constructors getConstructors() {
        return this.constructors;
    }

    public ConstructorDescriptor getDefaultCtorDescriptor(boolean declared) {
        ConstructorDescriptor defaultConstructor = this.getConstructors().getDefaultCtor();
        if (defaultConstructor != null && defaultConstructor.matchDeclared(declared)) {
            return defaultConstructor;
        }
        return null;
    }

    public ConstructorDescriptor getConstructorDescriptor(Class<?>[] args, boolean declared) {
        ConstructorDescriptor constructorDescriptor = this.getConstructors().getCtorDescriptor(args);
        if (constructorDescriptor != null && constructorDescriptor.matchDeclared(declared)) {
            return constructorDescriptor;
        }
        return null;
    }

    public ConstructorDescriptor[] getAllConstructorDescriptors() {
        return this.getConstructors().getAllCtorDescriptors();
    }

    protected Annotations getAnnotations() {
        return this.annotations;
    }

    public AnnotationDescriptor getAnnotationDescriptor(Class<? extends Annotation> clazz) {
        return this.annotations.getAnnotationDescriptor(clazz);
    }

    public AnnotationDescriptor[] getAllAnnotationDescriptors() {
        return this.annotations.getAllAnnotationDescriptors();
    }

    public Class<?>[] getAllInterfaces() {
        return this.interfaces;
    }

    public Class<?>[] getAllSuperclasses() {
        return this.superclasses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClassDescriptor [type=").append(this.type).append(", scanAccessible=").append(this.scanAccessible).append(", extendedProperties=").append(this.extendedProperties).append(", includeFieldsAsProperties=").append(this.includeFieldsAsProperties).append(", propertyFieldPrefix=").append(this.propertyFieldPrefix).append(", usageCount=").append(this.usageCount).append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassDescriptor other = (ClassDescriptor)obj;
        return Objects.equals(this.type, other.type);
    }

    public boolean isScanStatics() {
        return this.scanStatics;
    }
}

