/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Descriptor;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;

public class ConstructorDescriptor
extends Descriptor {
    protected final Constructor<?> constructor;
    protected final Class<?>[] parameters;

    public ConstructorDescriptor(ClassDescriptor classDescriptor, Constructor<?> constructor) {
        super(classDescriptor, ReflectionUtil.isPublic(constructor));
        this.constructor = constructor;
        this.parameters = constructor.getParameterTypes();
        this.annotations = new Annotations(constructor);
        ReflectionUtil.forceAccess(constructor);
    }

    @Override
    public String getName() {
        return this.constructor.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Class<?>[] getParameters() {
        return this.parameters;
    }

    public boolean isDefault() {
        return this.parameters.length == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConstructorDescriptor [constructor=").append(this.constructor).append(", parameters=").append(Arrays.toString(this.parameters)).append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + Objects.hash(this.constructor);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructorDescriptor other = (ConstructorDescriptor)obj;
        return Objects.equals(this.constructor, other.constructor) && Arrays.equals(this.parameters, other.parameters);
    }
}

