/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ConstructorDescriptor;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;

public class Constructors {
    protected final ClassDescriptor classDescriptor;
    protected final ConstructorDescriptor[] allConstructors;
    protected ConstructorDescriptor defaultConstructor;

    public Constructors(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.allConstructors = this.inspectConstructors();
    }

    protected ConstructorDescriptor[] inspectConstructors() {
        Class<?> type = this.classDescriptor.getType();
        Constructor<?>[] ctors = type.getDeclaredConstructors();
        ConstructorDescriptor[] allConstructors = new ConstructorDescriptor[ctors.length];
        for (int i = 0; i < ctors.length; ++i) {
            ConstructorDescriptor ctorDescriptor;
            Constructor<?> ctor = ctors[i];
            allConstructors[i] = ctorDescriptor = this.createCtorDescriptor(ctor);
            if (!ctorDescriptor.isDefault()) continue;
            this.defaultConstructor = ctorDescriptor;
        }
        return allConstructors;
    }

    protected ConstructorDescriptor createCtorDescriptor(Constructor<?> constructor) {
        return new ConstructorDescriptor(this.classDescriptor, constructor);
    }

    public ConstructorDescriptor getDefaultCtor() {
        return this.defaultConstructor;
    }

    public ConstructorDescriptor getCtorDescriptor(Class<?> ... args) {
        block0: for (ConstructorDescriptor ctorDescriptor : this.allConstructors) {
            Class<?>[] arg = ctorDescriptor.getParameters();
            if (arg.length != args.length) continue;
            for (int j = 0; j < arg.length; ++j) {
                if (arg[j] != args[j]) continue block0;
            }
            return ctorDescriptor;
        }
        return null;
    }

    ConstructorDescriptor[] getAllCtorDescriptors() {
        return this.allConstructors;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Constructors [classDescriptor=").append(this.classDescriptor).append(", allConstructors=").append(Arrays.toString(this.allConstructors)).append(", defaultConstructor=").append(this.defaultConstructor).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.allConstructors);
        result = 31 * result + Objects.hash(this.classDescriptor, this.defaultConstructor);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Constructors other = (Constructors)obj;
        return Arrays.equals(this.allConstructors, other.allConstructors) && Objects.equals(this.classDescriptor, other.classDescriptor) && Objects.equals(this.defaultConstructor, other.defaultConstructor);
    }
}

