/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.AnnotationDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import java.lang.annotation.Annotation;
import java.util.Objects;

public abstract class Descriptor {
    protected final ClassDescriptor classDescriptor;
    protected final boolean isPublic;
    protected Annotations annotations;

    protected Descriptor(ClassDescriptor classDescriptor, boolean isPublic) {
        this.classDescriptor = classDescriptor;
        this.isPublic = isPublic;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean matchDeclared(boolean declared) {
        if (!declared) {
            return this.isPublic;
        }
        return true;
    }

    protected Annotations getAnnotations() {
        return this.annotations;
    }

    public AnnotationDescriptor getAnnotationDescriptor(Class<? extends Annotation> clazz) {
        return this.annotations.getAnnotationDescriptor(clazz);
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        AnnotationDescriptor annotationDescriptor = this.annotations.getAnnotationDescriptor(clazz);
        if (annotationDescriptor == null) {
            return null;
        }
        return annotationDescriptor.getAnnotation();
    }

    public AnnotationDescriptor[] getAllAnnotationDescriptors() {
        return this.annotations.getAllAnnotationDescriptors();
    }

    public abstract String getName();

    public int hashCode() {
        return Objects.hash(this.annotations, this.classDescriptor, this.isPublic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Descriptor other = (Descriptor)obj;
        return Objects.equals(this.annotations, other.annotations) && Objects.equals(this.classDescriptor, other.classDescriptor) && this.isPublic == other.isPublic;
    }
}

