/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Descriptor;
import com.introproventures.graphql.jpa.query.introspection.Getter;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import com.introproventures.graphql.jpa.query.introspection.Setter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Objects;

public class FieldDescriptor
extends Descriptor
implements Getter,
Setter {
    protected final Field field;
    protected final Type type;
    protected final Class<?> rawType;
    protected final Class<?> rawComponentType;
    protected final Class<?> rawKeyComponentType;

    public FieldDescriptor(ClassDescriptor classDescriptor, Field field) {
        super(classDescriptor, ReflectionUtil.isPublic(field));
        this.field = field;
        this.type = field.getGenericType();
        this.rawType = ReflectionUtil.getRawType(this.type, classDescriptor.getType());
        Class<?>[] componentTypes = ReflectionUtil.getComponentTypes(this.type, classDescriptor.getType());
        if (componentTypes != null) {
            this.rawComponentType = componentTypes[componentTypes.length - 1];
            this.rawKeyComponentType = componentTypes[0];
        } else {
            this.rawComponentType = null;
            this.rawKeyComponentType = null;
        }
        this.annotations = new Annotations(field);
        ReflectionUtil.forceAccess(field);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Class<?> getRawComponentType() {
        return this.rawComponentType;
    }

    public Class<?> getRawKeyComponentType() {
        return this.rawKeyComponentType;
    }

    public Class<?>[] resolveRawComponentTypes() {
        return ReflectionUtil.getComponentTypes(this.type, this.classDescriptor.getType());
    }

    @Override
    public Object invokeGetter(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.field.get(target);
    }

    @Override
    public Class<?> getGetterRawType() {
        return this.getRawType();
    }

    @Override
    public Class<?> getGetterRawComponentType() {
        return this.getRawComponentType();
    }

    @Override
    public Class<?> getGetterRawKeyComponentType() {
        return this.getRawKeyComponentType();
    }

    @Override
    public void invokeSetter(Object target, Object argument) throws IllegalAccessException {
        this.field.set(target, argument);
    }

    @Override
    public Class<?> getSetterRawType() {
        return this.getRawType();
    }

    @Override
    public Class<?> getSetterRawComponentType() {
        return this.getRawComponentType();
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.field.getName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.field, this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldDescriptor other = (FieldDescriptor)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.type, other.type);
    }
}

