/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.FieldDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Fields {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";
    protected final ClassDescriptor classDescriptor;
    protected final Map<String, FieldDescriptor> fieldsMap;
    private FieldDescriptor[] allFields;

    public Fields(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.fieldsMap = this.inspectFields();
    }

    protected Map<String, FieldDescriptor> inspectFields() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        boolean scanStatics = this.classDescriptor.isScanStatics();
        Class<?> type = this.classDescriptor.getType();
        Field[] fields = scanAccessible ? ReflectionUtil.getAccessibleFields(type) : ReflectionUtil.getAllFieldsOfClass(type);
        LinkedHashMap<String, FieldDescriptor> map = new LinkedHashMap<String, FieldDescriptor>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldName.equals(SERIAL_VERSION_UID) || !scanStatics && Modifier.isStatic(field.getModifiers())) continue;
            map.put(fieldName, this.createFieldDescriptor(field));
        }
        return map;
    }

    protected FieldDescriptor createFieldDescriptor(Field field) {
        return new FieldDescriptor(this.classDescriptor, field);
    }

    public FieldDescriptor getFieldDescriptor(String name) {
        return this.fieldsMap.get(name);
    }

    public FieldDescriptor[] getAllFieldDescriptors() {
        if (this.allFields == null) {
            FieldDescriptor[] allFields = new FieldDescriptor[this.fieldsMap.size()];
            int index = 0;
            Iterator<FieldDescriptor> iterator = this.fieldsMap.values().iterator();
            while (iterator.hasNext()) {
                FieldDescriptor fieldDescriptor;
                allFields[index] = fieldDescriptor = iterator.next();
                ++index;
            }
            Arrays.sort(allFields, new Comparator<FieldDescriptor>(){

                @Override
                public int compare(FieldDescriptor fd1, FieldDescriptor fd2) {
                    return fd1.getField().getName().compareTo(fd2.getField().getName());
                }
            });
            this.allFields = allFields;
        }
        return this.allFields;
    }
}

