/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Descriptor;
import com.introproventures.graphql.jpa.query.introspection.Getter;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import com.introproventures.graphql.jpa.query.introspection.Setter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class MethodDescriptor
extends Descriptor
implements Getter,
Setter {
    protected final Method method;
    protected final Type returnType;
    protected final Class<?> rawReturnType;
    protected final Class<?> rawReturnComponentType;
    protected final Class<?> rawReturnKeyComponentType;
    protected final Class<?>[] rawParameterTypes;
    protected final Class<?>[] rawParameterComponentTypes;

    public MethodDescriptor(ClassDescriptor classDescriptor, Method method) {
        super(classDescriptor, ReflectionUtil.isPublic(method));
        this.method = method;
        this.returnType = method.getGenericReturnType();
        this.rawReturnType = ReflectionUtil.getRawType(this.returnType, classDescriptor.getType());
        Class<?>[] componentTypes = ReflectionUtil.getComponentTypes(this.returnType, classDescriptor.getType());
        if (componentTypes != null) {
            this.rawReturnComponentType = componentTypes[componentTypes.length - 1];
            this.rawReturnKeyComponentType = componentTypes[0];
        } else {
            this.rawReturnComponentType = null;
            this.rawReturnKeyComponentType = null;
        }
        this.annotations = new Annotations(method);
        ReflectionUtil.forceAccess(method);
        Type[] params = method.getGenericParameterTypes();
        Type[] genericParams = method.getGenericParameterTypes();
        this.rawParameterTypes = new Class[params.length];
        this.rawParameterComponentTypes = genericParams.length == 0 ? null : new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Type type = params[i];
            this.rawParameterTypes[i] = ReflectionUtil.getRawType(type, classDescriptor.getType());
            if (this.rawParameterComponentTypes == null) continue;
            this.rawParameterComponentTypes[i] = ReflectionUtil.getComponentType(genericParams[i], classDescriptor.getType());
        }
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getRawReturnType() {
        return this.rawReturnType;
    }

    public Class<?> getRawReturnComponentType() {
        return this.rawReturnComponentType;
    }

    public Class<?> getRawReturnKeyComponentType() {
        return this.rawReturnKeyComponentType;
    }

    public Class<?>[] resolveRawReturnComponentTypes() {
        return ReflectionUtil.getComponentTypes(this.returnType, this.classDescriptor.getType());
    }

    public Class<?>[] getRawParameterTypes() {
        return this.rawParameterTypes;
    }

    public Class<?>[] getRawParameterComponentTypes() {
        return this.rawParameterComponentTypes;
    }

    @Override
    public Object invokeGetter(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, new Object[0]);
    }

    @Override
    public Class<?> getGetterRawType() {
        return this.getRawReturnType();
    }

    @Override
    public Class<?> getGetterRawComponentType() {
        return this.getRawReturnComponentType();
    }

    @Override
    public Class<?> getGetterRawKeyComponentType() {
        return this.getRawReturnKeyComponentType();
    }

    @Override
    public void invokeSetter(Object target, Object argument) throws IllegalAccessException, InvocationTargetException {
        this.method.invoke(target, argument);
    }

    @Override
    public Class<?> getSetterRawType() {
        return this.getRawParameterTypes()[0];
    }

    @Override
    public Class<?> getSetterRawComponentType() {
        Class<?>[] ts = this.getRawParameterComponentTypes();
        if (ts == null) {
            return null;
        }
        return ts[0];
    }

    public String toString() {
        return this.classDescriptor.getType().getSimpleName() + '#' + this.method.getName() + "()";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawParameterTypes);
        result = 31 * result + Objects.hash(this.method, this.returnType);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return Objects.equals(this.method, other.method) && Arrays.equals(this.rawParameterTypes, other.rawParameterTypes) && Objects.equals(this.returnType, other.returnType);
    }
}

