/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.MethodDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ObjectUtil;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Methods {
    protected final ClassDescriptor classDescriptor;
    protected final Map<String, MethodDescriptor[]> methodsMap;
    private MethodDescriptor[] allMethods;

    public Methods(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.methodsMap = this.inspectMethods();
    }

    protected Map<String, MethodDescriptor[]> inspectMethods() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        boolean scanStatics = this.classDescriptor.isScanStatics();
        Class<?> type = this.classDescriptor.getType();
        Method[] methods = scanAccessible ? ReflectionUtil.getAccessibleMethods(type) : ReflectionUtil.getAllMethodsOfClass(type);
        LinkedHashMap<String, MethodDescriptor[]> map = new LinkedHashMap<String, MethodDescriptor[]>(methods.length);
        for (Method method : methods) {
            if (!scanStatics && Modifier.isStatic(method.getModifiers())) continue;
            String methodName = method.getName();
            MethodDescriptor[] mds = (MethodDescriptor[])map.get(methodName);
            mds = mds == null ? new MethodDescriptor[1] : Arrays.copyOf(mds, mds.length + 1);
            map.put(methodName, mds);
            mds[mds.length - 1] = this.createMethodDescriptor(method);
        }
        return map;
    }

    protected MethodDescriptor createMethodDescriptor(Method method) {
        return new MethodDescriptor(this.classDescriptor, method);
    }

    public MethodDescriptor getMethodDescriptor(String name, Class<?>[] paramTypes) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        for (int i = 0; i < methodDescriptors.length; ++i) {
            Method method = methodDescriptors[i].getMethod();
            if (!ObjectUtil.isEquals(method.getParameterTypes(), paramTypes)) continue;
            return methodDescriptors[i];
        }
        return null;
    }

    public MethodDescriptor getMethodDescriptor(String name) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        if (methodDescriptors.length != 1) {
            throw new IllegalArgumentException("Method name not unique: " + name);
        }
        return methodDescriptors[0];
    }

    public MethodDescriptor[] getAllMethodDescriptors(String name) {
        return this.methodsMap.get(name);
    }

    public MethodDescriptor[] getAllMethodDescriptors() {
        if (this.allMethods == null) {
            ArrayList allMethodsList = new ArrayList();
            for (MethodDescriptor[] methodDescriptors : this.methodsMap.values()) {
                Collections.addAll(allMethodsList, methodDescriptors);
            }
            MethodDescriptor[] allMethods = allMethodsList.toArray(new MethodDescriptor[allMethodsList.size()]);
            Arrays.sort(allMethods, new Comparator<MethodDescriptor>(){

                @Override
                public int compare(MethodDescriptor md1, MethodDescriptor md2) {
                    return md1.getMethod().getName().compareTo(md2.getMethod().getName());
                }
            });
            this.allMethods = allMethods;
        }
        return this.allMethods;
    }
}

