/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.BeanUtil;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.FieldDescriptor;
import com.introproventures.graphql.jpa.query.introspection.MethodDescriptor;
import com.introproventures.graphql.jpa.query.introspection.PropertyDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Properties {
    protected final ClassDescriptor classDescriptor;
    protected final Map<String, PropertyDescriptor> propertyDescriptors;
    private PropertyDescriptor[] allProperties;

    public Properties(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.propertyDescriptors = this.inspectProperties();
    }

    protected Map<String, PropertyDescriptor> inspectProperties() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        Class<?> type = this.classDescriptor.getType();
        LinkedHashMap<String, PropertyDescriptor> map = new LinkedHashMap<String, PropertyDescriptor>();
        Method[] methods = scanAccessible ? ReflectionUtil.getAccessibleMethods(type) : ReflectionUtil.getAllMethodsOfClass(type);
        for (int iteration = 0; iteration < 2; ++iteration) {
            for (Method method : methods) {
                String propertyName;
                if (Modifier.isStatic(method.getModifiers())) continue;
                boolean add = false;
                boolean issetter = false;
                if (iteration == 0) {
                    propertyName = BeanUtil.getBeanGetterName(method);
                    if (propertyName != null) {
                        add = true;
                        issetter = false;
                    }
                } else {
                    propertyName = BeanUtil.getBeanSetterName(method);
                    if (propertyName != null) {
                        add = true;
                        issetter = true;
                    }
                }
                if (!add) continue;
                MethodDescriptor methodDescriptor = this.classDescriptor.getMethodDescriptor(method.getName(), method.getParameterTypes(), true);
                this.addProperty(map, propertyName, methodDescriptor, issetter);
            }
        }
        if (this.classDescriptor.isIncludeFieldsAsProperties()) {
            FieldDescriptor[] fieldDescriptors = this.classDescriptor.getAllFieldDescriptors();
            String prefix = this.classDescriptor.getPropertyFieldPrefix();
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                String name = fieldDescriptor.getField().getName();
                if (prefix != null) {
                    if (!name.startsWith(prefix)) continue;
                    name = name.substring(prefix.length());
                }
                if (map.containsKey(name)) continue;
                map.put(name, this.createPropertyDescriptor(name, fieldDescriptor));
            }
        }
        return map;
    }

    protected void addProperty(Map<String, PropertyDescriptor> map, String name, MethodDescriptor methodDescriptor, boolean isSetter) {
        MethodDescriptor setterMethod = isSetter ? methodDescriptor : null;
        MethodDescriptor getterMethod = isSetter ? null : methodDescriptor;
        PropertyDescriptor existing = map.get(name);
        if (existing == null) {
            PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(name, getterMethod, setterMethod);
            map.put(name, propertyDescriptor);
            return;
        }
        if (!isSetter) {
            setterMethod = existing.getWriteMethodDescriptor();
            MethodDescriptor existingMethodDescriptor = existing.getReadMethodDescriptor();
            if (existingMethodDescriptor != null) {
                String methodName = methodDescriptor.getMethod().getName();
                String existingMethodName = existingMethodDescriptor.getMethod().getName();
                if (existingMethodName.startsWith("is") && methodName.startsWith("get")) {
                    return;
                }
            }
        } else {
            getterMethod = existing.getReadMethodDescriptor();
            if (getterMethod.getMethod().getReturnType() != setterMethod.getMethod().getParameterTypes()[0]) {
                return;
            }
        }
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(name, getterMethod, setterMethod);
        map.put(name, propertyDescriptor);
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, MethodDescriptor getterMethod, MethodDescriptor setterMethod) {
        return new PropertyDescriptor(this.classDescriptor, name, getterMethod, setterMethod);
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, FieldDescriptor fieldDescriptor) {
        return new PropertyDescriptor(this.classDescriptor, name, fieldDescriptor);
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.propertyDescriptors.get(name);
    }

    public PropertyDescriptor[] getAllPropertyDescriptors() {
        if (this.allProperties == null) {
            PropertyDescriptor[] allProperties = new PropertyDescriptor[this.propertyDescriptors.size()];
            int index = 0;
            Iterator<PropertyDescriptor> iterator = this.propertyDescriptors.values().iterator();
            while (iterator.hasNext()) {
                PropertyDescriptor propertyDescriptor;
                allProperties[index] = propertyDescriptor = iterator.next();
                ++index;
            }
            Arrays.sort(allProperties, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor pd1, PropertyDescriptor pd2) {
                    return pd1.getName().compareTo(pd2.getName());
                }
            });
            this.allProperties = allProperties;
        }
        return this.allProperties;
    }
}

