/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.Annotations;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Descriptor;
import com.introproventures.graphql.jpa.query.introspection.FieldDescriptor;
import com.introproventures.graphql.jpa.query.introspection.Getter;
import com.introproventures.graphql.jpa.query.introspection.MethodDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import com.introproventures.graphql.jpa.query.introspection.Setter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;

public class PropertyDescriptor
extends Descriptor {
    protected final String name;
    protected final MethodDescriptor readMethodDescriptor;
    protected final MethodDescriptor writeMethodDescriptor;
    protected final FieldDescriptor fieldDescriptor;
    protected Class<?> type;
    protected Getter[] getters;
    protected Setter[] setters;

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, FieldDescriptor fieldDescriptor) {
        super(classDescriptor, false);
        this.name = propertyName;
        this.readMethodDescriptor = null;
        this.writeMethodDescriptor = null;
        this.fieldDescriptor = fieldDescriptor;
        this.annotations = new Annotations(fieldDescriptor.getField());
    }

    public PropertyDescriptor(ClassDescriptor classDescriptor, String propertyName, MethodDescriptor readMethod, MethodDescriptor writeMethod) {
        super(classDescriptor, (readMethod == null || readMethod.isPublic()) & (writeMethod == null || writeMethod.isPublic()));
        this.name = propertyName;
        this.readMethodDescriptor = readMethod;
        this.writeMethodDescriptor = writeMethod;
        if (classDescriptor.isExtendedProperties()) {
            this.fieldDescriptor = this.findField(propertyName);
            if (this.fieldDescriptor != null) {
                this.annotations = new Annotations(this.fieldDescriptor.getField());
            }
        } else {
            this.fieldDescriptor = null;
            if (readMethod != null) {
                this.annotations = new Annotations(readMethod.getMethod());
            } else if (writeMethod != null) {
                this.annotations = new Annotations(writeMethod.getMethod());
            }
        }
    }

    protected FieldDescriptor findField(String fieldName) {
        String prefix = this.classDescriptor.getPropertyFieldPrefix();
        if (prefix != null) {
            fieldName = prefix + fieldName;
        }
        return this.classDescriptor.getFieldDescriptor(fieldName, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MethodDescriptor getReadMethodDescriptor() {
        return this.readMethodDescriptor;
    }

    public MethodDescriptor getWriteMethodDescriptor() {
        return this.writeMethodDescriptor;
    }

    public FieldDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public boolean isFieldOnlyDescriptor() {
        return this.readMethodDescriptor == null && this.writeMethodDescriptor == null;
    }

    public Class<?> getType() {
        if (this.type == null) {
            if (this.readMethodDescriptor != null) {
                this.type = this.readMethodDescriptor.getMethod().getReturnType();
            } else if (this.writeMethodDescriptor != null) {
                this.type = this.writeMethodDescriptor.getMethod().getParameterTypes()[0];
            } else if (this.fieldDescriptor != null) {
                this.type = this.fieldDescriptor.getField().getType();
            }
        }
        return this.type;
    }

    public Getter getGetter(boolean declared) {
        if (this.getters == null) {
            this.getters = new Getter[]{this.createGetter(false), this.createGetter(true)};
        }
        return this.getters[declared ? 1 : 0];
    }

    protected Getter createGetter(boolean declared) {
        if (this.readMethodDescriptor != null && this.readMethodDescriptor.matchDeclared(declared)) {
            return this.readMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }

    public Setter getSetter(boolean declared) {
        if (this.setters == null) {
            this.setters = new Setter[]{this.createSetter(false), this.createSetter(true)};
        }
        return this.setters[declared ? 1 : 0];
    }

    protected Setter createSetter(boolean declared) {
        if (this.writeMethodDescriptor != null && this.writeMethodDescriptor.matchDeclared(declared)) {
            return this.writeMethodDescriptor;
        }
        if (this.fieldDescriptor != null && this.fieldDescriptor.matchDeclared(declared)) {
            return this.fieldDescriptor;
        }
        return null;
    }

    public Class<?> resolveKeyType(boolean declared) {
        FieldDescriptor fieldDescriptor;
        Class<?> keyType = null;
        Getter getter = this.getGetter(declared);
        if (getter != null) {
            keyType = getter.getGetterRawKeyComponentType();
        }
        if (keyType == null && (fieldDescriptor = this.getFieldDescriptor()) != null) {
            keyType = fieldDescriptor.getRawKeyComponentType();
        }
        return keyType;
    }

    public Class<?> resolveComponentType(boolean declared) {
        FieldDescriptor fieldDescriptor;
        Class<?> componentType = null;
        Getter getter = this.getGetter(declared);
        if (getter != null) {
            componentType = getter.getGetterRawComponentType();
        }
        if (componentType == null && (fieldDescriptor = this.getFieldDescriptor()) != null) {
            componentType = fieldDescriptor.getRawComponentType();
        }
        return componentType;
    }

    public Field getField() {
        Class<?> clazz = this.getClassDescriptor().getType();
        return ReflectionUtil.getField(clazz, this.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PropertyDescriptor [name=").append(this.name).append(", readMethodDescriptor=").append(this.readMethodDescriptor).append(", writeMethodDescriptor=").append(this.writeMethodDescriptor).append(", fieldDescriptor=").append(this.fieldDescriptor).append(", type=").append(this.type).append(", getters=").append(Arrays.toString(this.getters)).append(", setters=").append(Arrays.toString(this.setters)).append(", classDescriptor=").append(this.classDescriptor).append(", isPublic=").append(this.isPublic).append(", annotations=").append(this.annotations).append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.name, this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescriptor other = (PropertyDescriptor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }
}

