/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.introspection;

import com.introproventures.graphql.jpa.query.introspection.ArrayUtil;
import com.introproventures.graphql.jpa.query.introspection.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class ReflectionUtil {
    public static Field[] getAllFieldsOfClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ReflectionUtil.getAllFieldsOfClass0(clazz);
    }

    public static Method[] getAccessibleMethods(Class<?> clazz) {
        return ReflectionUtil.getAccessibleMethods(clazz, Object.class);
    }

    public static Method[] getAllMethodsOfClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Method[] methods = null;
        for (Class<?> itr = clazz; itr != null && !itr.equals(Object.class); itr = itr.getSuperclass()) {
            methods = ArrayUtil.addAll(itr.getDeclaredMethods(), methods);
        }
        return methods;
    }

    public static Method[] getAccessibleMethods(Class<?> clazz, Class<?> limit) {
        Package topPackage = clazz.getPackage();
        ArrayList<Method> methodList = new ArrayList<Method>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                int pckgHash;
                if (Modifier.isVolatile(method.getModifiers())) continue;
                if (top) {
                    methodList.add(method);
                    continue;
                }
                int modifier = method.getModifiers();
                if (Modifier.isPrivate(modifier) || Modifier.isAbstract(modifier)) continue;
                if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier)) {
                    ReflectionUtil.addMethodIfNotExist(methodList, method);
                    continue;
                }
                Package pckg = method.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ReflectionUtil.addMethodIfNotExist(methodList, method);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Method[] methods = new Method[methodList.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)methodList.get(i);
        }
        return methods;
    }

    private static void addMethodIfNotExist(List<Method> allMethods, Method newMethod) {
        for (Method method : allMethods) {
            if (!ObjectUtil.isEquals(method, newMethod)) continue;
            return;
        }
        allMethods.add(newMethod);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (ObjectUtil.isAnyNull(clazz, fieldName)) {
            return null;
        }
        return ReflectionUtil.getField0(clazz, fieldName);
    }

    static Field getField0(Class<?> clazz, String fieldName) {
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            Field[] fields;
            for (Field field : fields = itr.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            itr = itr.getSuperclass();
        }
        return null;
    }

    public static Class<?> getComponentType(Type type, Class<?> implClass) {
        Class<?>[] componentTypes = ReflectionUtil.getComponentTypes(type, implClass);
        if (componentTypes == null) {
            return null;
        }
        return componentTypes[componentTypes.length - 1];
    }

    public static Class<?> getComponentType(Type type) {
        return ReflectionUtil.getComponentType(type, null);
    }

    static Field[] getAllFieldsOfClass0(Class<?> clazz) {
        Field[] fields = null;
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            fields = ArrayUtil.addAll(itr.getDeclaredFields(), fields);
            itr = itr.getSuperclass();
        }
        return fields;
    }

    public static boolean hasSuperClass(Class<?> clazz) {
        return clazz != null && !clazz.equals(Object.class);
    }

    public static Annotation[] getAnnotation(AnnotatedElement annotatedElement) {
        if (Objects.isNull(annotatedElement)) {
            return null;
        }
        return annotatedElement.getAnnotations();
    }

    public static boolean isPublic(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers());
    }

    public static boolean isAccessible(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers());
    }

    public static void forceAccess(AccessibleObject object) {
        if (object == null || object.isAccessible()) {
            return;
        }
        try {
            object.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getRawType(Type type) {
        return ReflectionUtil.getRawType(type, null);
    }

    public static Class<?> getRawType(Type type, Class<?> implClass) {
        if (type == null) {
            return null;
        }
        GenericType gt = GenericType.find(type);
        if (gt != null) {
            return gt.toRawType(type, implClass);
        }
        return null;
    }

    public static Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
        if (type == null) {
            return null;
        }
        GenericType gt = GenericType.find(type);
        if (gt != null) {
            return gt.getComponentTypes(type, implClass);
        }
        return null;
    }

    public static Field[] getAccessibleFields(Class<?> clazz) {
        return ReflectionUtil.getAccessibleFields(clazz, Object.class);
    }

    public static Field[] getAccessibleFields(Class<?> clazz, Class<?> limit) {
        if (clazz == null) {
            return null;
        }
        Package topPackage = clazz.getPackage();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int topPackageHash = topPackage == null ? 0 : topPackage.hashCode();
        boolean top = true;
        while (clazz != null) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                int pckgHash;
                if (top) {
                    fieldList.add(field);
                    continue;
                }
                int modifier = field.getModifiers();
                if (Modifier.isPrivate(modifier)) continue;
                if (Modifier.isPublic(modifier) || Modifier.isProtected(modifier)) {
                    ReflectionUtil.addFieldIfNotExist(fieldList, field);
                    continue;
                }
                Package pckg = field.getDeclaringClass().getPackage();
                int n = pckgHash = pckg == null ? 0 : pckg.hashCode();
                if (pckgHash != topPackageHash) continue;
                ReflectionUtil.addFieldIfNotExist(fieldList, field);
            }
            top = false;
            if ((clazz = clazz.getSuperclass()) != limit) continue;
        }
        Field[] fields = new Field[fieldList.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (Field)fieldList.get(i);
        }
        return fields;
    }

    private static void addFieldIfNotExist(List<Field> allFields, Field newField) {
        for (Field field : allFields) {
            if (!ObjectUtil.isEquals(field, newField)) continue;
            return;
        }
        allFields.add(newField);
    }

    public static Type resolveVariable(TypeVariable<?> variable, Class<?> implClass) {
        Class<?> rawType = ReflectionUtil.getRawType(implClass, null);
        int index = ArrayUtil.indexOf(rawType.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] interfaces = rawType.getInterfaces();
        Type[] genericInterfaces = rawType.getGenericInterfaces();
        for (int i = 0; i <= interfaces.length; ++i) {
            Type type;
            Class<?> rawInterface;
            if (i < interfaces.length) {
                rawInterface = interfaces[i];
            } else {
                rawInterface = rawType.getSuperclass();
                if (rawInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, rawInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtil.indexOf(rawInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                throw new IllegalArgumentException("Invalid type variable:" + typeVariable);
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : rawType.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[index];
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null || methodName == null) {
            return null;
        }
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            Method[] methods;
            for (Method method : methods = itr.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameterTypes)) continue;
                return method;
            }
            itr = itr.getSuperclass();
        }
        return null;
    }

    public static Field[] getAllInstanceFields(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ReflectionUtil.getAllInstanceFields0(clazz);
    }

    static Field[] getAllInstanceFields0(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> itr = clazz;
        while (ReflectionUtil.hasSuperClass(itr)) {
            for (Field field : itr.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            itr = itr.getSuperclass();
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static <T, A extends Annotation> List<Method> getAnnotationMethods(Class<T> clazz, Class<A> annotationType) {
        if (clazz == null || annotationType == null) {
            return null;
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : ReflectionUtil.getAllMethodsOfClass(clazz)) {
            A type = method.getAnnotation(annotationType);
            if (type == null) continue;
            list.add(method);
        }
        return list;
    }

    public static Field[] getAnnotationFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null || annotationClass == null) {
            return null;
        }
        Field[] fields = ReflectionUtil.getAllFieldsOfClass0(clazz);
        if (ArrayUtil.isEmpty(fields)) {
            return null;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields) {
            if (null == field.getAnnotation(annotationClass)) continue;
            list.add(field);
            field.setAccessible(true);
        }
        return list.toArray(new Field[0]);
    }

    public static Class<?>[] getGenericSuperTypes(Class<?> type) {
        if (type == null) {
            return null;
        }
        return ReflectionUtil.getComponentTypes(type.getGenericSuperclass());
    }

    public static Class<?>[] getComponentTypes(Type type) {
        return ReflectionUtil.getComponentTypes(type, null);
    }

    public static <T> T invokeMethod(Method method, Object target, Object ... args) {
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        try {
            Object result = method.invoke(target, args);
            return (T)result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Method method;
        if (object == null || methodName == null) {
            return null;
        }
        if (parameterTypes == null) {
            parameterTypes = new Class[]{};
        }
        if (args == null) {
            args = new Object[]{};
        }
        try {
            method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (method == null) {
            return null;
        }
        return ReflectionUtil.invokeMethod(method, object, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) {
        if (object == null || methodName == null) {
            return null;
        }
        if (args == null) {
            args = new Object[]{};
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return ReflectionUtil.invokeMethod(object, methodName, parameterTypes, args);
    }

    static enum GenericType {
        CLASS_TYPE{

            @Override
            Class<?> type() {
                return Class.class;
            }

            @Override
            Class<?> toRawType(Type type, Class<?> implClass) {
                return (Class)type;
            }

            @Override
            Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
                Class clazz = (Class)type;
                if (clazz.isArray()) {
                    return new Class[]{clazz.getComponentType()};
                }
                return null;
            }
        }
        ,
        PARAMETERIZED_TYPE{

            @Override
            Class<?> type() {
                return ParameterizedType.class;
            }

            @Override
            Class<?> toRawType(Type type, Class<?> implClass) {
                ParameterizedType pType = (ParameterizedType)type;
                return ReflectionUtil.getRawType(pType.getRawType(), implClass);
            }

            @Override
            Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
                ParameterizedType pt = (ParameterizedType)type;
                Type[] generics = pt.getActualTypeArguments();
                if (generics.length == 0) {
                    return null;
                }
                Class[] types = new Class[generics.length];
                for (int i = 0; i < generics.length; ++i) {
                    types[i] = ReflectionUtil.getRawType(generics[i], implClass);
                }
                return types;
            }
        }
        ,
        WILDCARD_TYPE{

            @Override
            Class<?> type() {
                return WildcardType.class;
            }

            @Override
            Class<?> toRawType(Type type, Class<?> implClass) {
                WildcardType wType = (WildcardType)type;
                Type[] lowerTypes = wType.getLowerBounds();
                if (lowerTypes.length > 0) {
                    return ReflectionUtil.getRawType(lowerTypes[0], implClass);
                }
                Type[] upperTypes = wType.getUpperBounds();
                if (upperTypes.length != 0) {
                    return ReflectionUtil.getRawType(upperTypes[0], implClass);
                }
                return Object.class;
            }

            @Override
            Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
                return null;
            }
        }
        ,
        GENERIC_ARRAY_TYPE{

            @Override
            Class<?> type() {
                return GenericArrayType.class;
            }

            @Override
            Class<?> toRawType(Type type, Class<?> implClass) {
                Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
                Class<?> rawType = ReflectionUtil.getRawType(genericComponentType, implClass);
                return Array.newInstance(rawType, 0).getClass();
            }

            @Override
            Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
                GenericArrayType gat = (GenericArrayType)type;
                Class<?> rawType = ReflectionUtil.getRawType(gat.getGenericComponentType(), implClass);
                if (rawType == null) {
                    return null;
                }
                return new Class[]{rawType};
            }
        }
        ,
        TYPE_VARIABLE{

            @Override
            Class<?> type() {
                return TypeVariable.class;
            }

            @Override
            Class<?> toRawType(Type type, Class<?> implClass) {
                Type resolvedType;
                TypeVariable varType = (TypeVariable)type;
                if (implClass != null && (resolvedType = ReflectionUtil.resolveVariable(varType, implClass)) != null) {
                    return ReflectionUtil.getRawType(resolvedType, null);
                }
                Type[] boundsTypes = varType.getBounds();
                if (boundsTypes.length == 0) {
                    return Object.class;
                }
                return ReflectionUtil.getRawType(boundsTypes[0], implClass);
            }

            @Override
            Class<?>[] getComponentTypes(Type type, Class<?> implClass) {
                return null;
            }
        };


        abstract Class<?> toRawType(Type var1, Class<?> var2);

        abstract Class<?> type();

        abstract Class<?>[] getComponentTypes(Type var1, Class<?> var2);

        static GenericType find(Type type) {
            for (GenericType gt : GenericType.values()) {
                if (!gt.type().isInstance(type)) continue;
                return gt;
            }
            return null;
        }
    }
}

