/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema;

import graphql.Assert;
import graphql.Scalars;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.scalars.ExtendedScalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScalars {
    static final Logger log = LoggerFactory.getLogger(JavaScalars.class);
    private static Map<Class<?>, GraphQLScalarType> scalarsRegistry = new HashMap();
    private static JavaScalars instance = new JavaScalars();

    public static Optional<GraphQLScalarType> of(String name) {
        return scalarsRegistry.values().stream().filter(scalar -> name.equals(scalar.getName())).findFirst();
    }

    public static Collection<GraphQLScalarType> scalars() {
        return Collections.unmodifiableCollection(scalarsRegistry.values());
    }

    public static GraphQLScalarType of(Class<?> key) {
        return scalarsRegistry.computeIfAbsent(key, JavaScalars::computeGraphQLScalarType);
    }

    protected static GraphQLScalarType computeGraphQLScalarType(Class<?> key) {
        String typeName = key.getSimpleName();
        String description = typeName + " Scalar Object Type";
        return JavaScalars.newScalarType(typeName, description, new GraphQLObjectCoercing());
    }

    public static <T extends Coercing> GraphQLScalarType newScalarType(String name, String description, T coercing) {
        return GraphQLScalarType.newScalar().name(name).description(description).coercing(coercing).build();
    }

    public static JavaScalars register(Class<?> key, GraphQLScalarType value) {
        Assert.assertNotNull(key, () -> "key parameter cannot be null.");
        Assert.assertNotNull((Object)value, () -> "value parameter cannot be null.");
        scalarsRegistry.put(key, value);
        return instance;
    }

    static {
        scalarsRegistry.put(String.class, Scalars.GraphQLString);
        scalarsRegistry.put(Integer.class, Scalars.GraphQLInt);
        scalarsRegistry.put(Integer.TYPE, Scalars.GraphQLInt);
        scalarsRegistry.put(Short.class, ExtendedScalars.GraphQLShort);
        scalarsRegistry.put(Short.TYPE, ExtendedScalars.GraphQLShort);
        scalarsRegistry.put(Float.class, Scalars.GraphQLFloat);
        scalarsRegistry.put(Float.TYPE, Scalars.GraphQLFloat);
        scalarsRegistry.put(Double.class, Scalars.GraphQLFloat);
        scalarsRegistry.put(Double.TYPE, Scalars.GraphQLFloat);
        scalarsRegistry.put(Long.class, ExtendedScalars.GraphQLLong);
        scalarsRegistry.put(Long.TYPE, ExtendedScalars.GraphQLLong);
        scalarsRegistry.put(Boolean.class, Scalars.GraphQLBoolean);
        scalarsRegistry.put(Boolean.TYPE, Scalars.GraphQLBoolean);
        scalarsRegistry.put(BigInteger.class, ExtendedScalars.GraphQLBigInteger);
        scalarsRegistry.put(Character.TYPE, ExtendedScalars.GraphQLChar);
        scalarsRegistry.put(Character.class, ExtendedScalars.GraphQLChar);
        scalarsRegistry.put(Byte.class, ExtendedScalars.GraphQLByte);
        scalarsRegistry.put(Byte.TYPE, ExtendedScalars.GraphQLByte);
        scalarsRegistry.put(BigDecimal.class, ExtendedScalars.GraphQLBigDecimal);
        scalarsRegistry.put(LocalDateTime.class, JavaScalars.newScalarType("LocalDateTime", "LocalDateTime type", new GraphQLLocalDateTimeCoercing()));
        scalarsRegistry.put(LocalDate.class, JavaScalars.newScalarType("LocalDate", "LocalDate type", new GraphQLLocalDateCoercing()));
        scalarsRegistry.put(LocalTime.class, JavaScalars.newScalarType("LocalTime", "LocalTime type", new GraphQLLocalTimeCoercing()));
        scalarsRegistry.put(java.util.Date.class, JavaScalars.newScalarType("Date", "Date type", new GraphQLDateCoercing()));
        scalarsRegistry.put(UUID.class, JavaScalars.newScalarType("UUID", "UUID type", new GraphQLUUIDCoercing()));
        scalarsRegistry.put(Object.class, JavaScalars.newScalarType("Object", "Object type", new GraphQLObjectCoercing()));
        scalarsRegistry.put(Date.class, JavaScalars.newScalarType("SqlDate", "SQL Date type", new GraphQLSqlDateCoercing()));
        scalarsRegistry.put(Timestamp.class, JavaScalars.newScalarType("SqlTimestamp", "SQL Timestamp type", new GraphQLSqlTimestampCoercing()));
        scalarsRegistry.put(Byte[].class, JavaScalars.newScalarType("ByteArray", "ByteArray type", new GraphQLLOBCoercing()));
        scalarsRegistry.put(Instant.class, JavaScalars.newScalarType("Instant", "Instant type", new GraphQLInstantCoercing()));
        scalarsRegistry.put(ZonedDateTime.class, JavaScalars.newScalarType("ZonedDateTime", "ZonedDateTime type", new GraphQLZonedDateTimeCoercing()));
        scalarsRegistry.put(OffsetDateTime.class, JavaScalars.newScalarType("OffsetDateTime", "OffsetDateTime type", new GraphQLOffsetDateTimeCoercing()));
    }

    public static class GraphQLObjectCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object dataFetcherResult) {
            return dataFetcherResult;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return this.parseLiteral(input, Collections.emptyMap());
        }

        public Object parseLiteral(Object value, Map<String, Object> variables) {
            if (!(value instanceof Value)) {
                throw new IllegalArgumentException("Expected AST type 'StringValue' but was '" + value + "'.");
            }
            if (value instanceof StringValue) {
                return ((StringValue)value).getValue();
            }
            if (value instanceof IntValue) {
                return ((IntValue)value).getValue();
            }
            if (value instanceof FloatValue) {
                return ((FloatValue)value).getValue();
            }
            if (value instanceof BooleanValue) {
                return ((BooleanValue)value).isValue();
            }
            if (value instanceof EnumValue) {
                return ((EnumValue)value).getName();
            }
            if (value instanceof NullValue) {
                return null;
            }
            if (value instanceof VariableReference) {
                String varName = ((VariableReference)value).getName();
                return variables.get(varName);
            }
            if (value instanceof ArrayValue) {
                List values = ((ArrayValue)value).getValues();
                return values.stream().map(v -> this.parseLiteral(v, variables)).collect(Collectors.toList());
            }
            if (value instanceof ObjectValue) {
                List values = ((ObjectValue)value).getObjectFields();
                LinkedHashMap parsedValues = new LinkedHashMap();
                values.forEach(field -> {
                    Object parsedValue = this.parseLiteral(field.getValue(), variables);
                    parsedValues.put(field.getName(), parsedValue);
                });
                return parsedValues;
            }
            throw new IllegalArgumentException("Unsupported scalar value type: " + value.getClass().getName());
        }
    }

    public static class GraphQLLocalDateTimeCoercing
    implements Coercing<Object, Object> {
        private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToLocalDateTime((String)input);
            }
            if (input instanceof LocalDateTime) {
                return ((LocalDateTime)input).format(formatter);
            }
            if (input instanceof LocalDate) {
                return ((LocalDate)input).format(formatter);
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDateTime((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDateTime(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDateTime(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDateTime(value.longValue());
            }
            return null;
        }

        private LocalDateTime parseLongToLocalDateTime(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId());
        }

        private LocalDateTime parseStringToLocalDateTime(String input) {
            try {
                return LocalDateTime.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLLocalDateCoercing
    implements Coercing<Object, Object> {
        private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToLocalDate((String)input);
            }
            if (input instanceof LocalDate) {
                return ((LocalDate)input).format(formatter);
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDate((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDate(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDate(value.longValue());
            }
            return null;
        }

        private LocalDate parseLongToLocalDate(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId()).toLocalDate();
        }

        private LocalDate parseStringToLocalDate(String input) {
            try {
                return LocalDate.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLLocalTimeCoercing
    implements Coercing<LocalTime, String> {
        public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME.withZone(ZoneOffset.UTC);

        private LocalTime convertImpl(Object input) {
            if (input instanceof String) {
                try {
                    return LocalTime.parse((String)input, FORMATTER);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String serialize(Object input) {
            if (input instanceof LocalTime) {
                return DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)input);
            }
            LocalTime result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Invalid value '" + input + "' for LocalTime");
            }
            return DateTimeFormatter.ISO_LOCAL_TIME.format(result);
        }

        public LocalTime parseValue(Object input) {
            LocalTime result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Invalid value '" + input + "' for LocalTime");
            }
            return result;
        }

        public LocalTime parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            String value = ((StringValue)input).getValue();
            LocalTime result = this.convertImpl(value);
            return result;
        }
    }

    public static class GraphQLDateCoercing
    implements Coercing<Object, Object> {
        final String dateFormatString;

        public GraphQLDateCoercing() {
            this.dateFormatString = "yyyy-MM-dd";
        }

        public GraphQLDateCoercing(String dateFormatString) {
            this.dateFormatString = dateFormatString;
        }

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToDate((String)input);
            }
            if (input instanceof java.util.Date) {
                return new SimpleDateFormat(this.dateFormatString).format(input);
            }
            if (input instanceof Long) {
                return new java.util.Date((Long)input);
            }
            if (input instanceof Integer) {
                return new java.util.Date(((Integer)input).longValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return new java.util.Date(value.longValue());
            }
            return null;
        }

        private java.util.Date parseStringToDate(String input) {
            SimpleDateFormat df = new SimpleDateFormat(this.dateFormatString);
            try {
                return df.parse(input);
            }
            catch (ParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLUUIDCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input instanceof UUID) {
                return input;
            }
            return null;
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return this.parseStringToUUID((String)input);
            }
            return null;
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToUUID(((StringValue)input).getValue());
            }
            return null;
        }

        private UUID parseStringToUUID(String input) {
            try {
                return UUID.fromString(input);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to parse UUID from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLSqlDateCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToDate((String)input);
            }
            if (input instanceof java.util.Date) {
                return new Date(((java.util.Date)input).getTime());
            }
            if (input instanceof Long) {
                return new Date((Long)input);
            }
            if (input instanceof Integer) {
                return new Date(((Integer)input).longValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return new Date(value.longValue());
            }
            return null;
        }

        private Date parseStringToDate(String input) {
            try {
                return new Date(DateFormat.getInstance().parse(input).getTime());
            }
            catch (ParseException e) {
                log.warn("Failed to parse SQL Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLSqlTimestampCoercing
    implements Coercing<Timestamp, Object> {
        private Timestamp doConvert(Object input) {
            if (input instanceof Long) {
                return new Timestamp((Long)Long.class.cast(input));
            }
            if (input instanceof String) {
                Instant instant = DateTimeHelper.parseDate((String)String.class.cast(input));
                return Timestamp.from(instant);
            }
            if (input instanceof Timestamp) {
                return (Timestamp)Timestamp.class.cast(input);
            }
            return null;
        }

        public Object serialize(Object input) {
            Timestamp result = this.doConvert(input);
            if (result == null) {
                throw new CoercingSerializeException("Invalid value '" + input + "' for Timestamp");
            }
            return DateTimeFormatter.ISO_INSTANT.format(result.toInstant());
        }

        public Timestamp parseValue(Object input) {
            Timestamp result = this.doConvert(input);
            if (result == null) {
                throw new CoercingParseValueException("Invalid value '" + input + "' for Timestamp");
            }
            return result;
        }

        public Timestamp parseLiteral(Object input) {
            Object value = null;
            if (IntValue.class.isInstance(input)) {
                value = ((IntValue)IntValue.class.cast(input)).getValue().longValue();
            } else if (StringValue.class.isInstance(input)) {
                value = ((StringValue)StringValue.class.cast(input)).getValue();
            } else {
                throw new CoercingParseLiteralException("Invalid value '" + input + "' for Timestamp");
            }
            return this.doConvert(value);
        }
    }

    public static class GraphQLLOBCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input.getClass() == byte[].class) {
                return input;
            }
            return null;
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return this.parseStringToByteArray((String)input);
            }
            return null;
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToByteArray(((StringValue)input).getValue());
            }
            return null;
        }

        private byte[] parseStringToByteArray(String input) {
            try {
                return input.getBytes(StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to parse byte[] from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLInstantCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToInstant((String)input);
            }
            if (input instanceof Instant) {
                return input.toString();
            }
            if (input instanceof Long) {
                return Instant.ofEpochMilli((Long)input);
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToInstant(((StringValue)input).getValue());
            }
            return null;
        }

        private Instant parseStringToInstant(String input) {
            try {
                return Instant.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLZonedDateTimeCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToZonedDateTime((String)input);
            }
            if (input instanceof ZonedDateTime) {
                return ((ZonedDateTime)input).withZoneSameInstant(ZoneId.of("UTC"));
            }
            if (input instanceof LocalDate) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToZonedDateTime((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToZonedDateTime(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToZonedDateTime(((StringValue)input).getValue());
            }
            return null;
        }

        private ZonedDateTime parseLongToZonedDateTime(long input) {
            return ZonedDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId());
        }

        private ZonedDateTime parseStringToZonedDateTime(String input) {
            try {
                return ZonedDateTime.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static class GraphQLOffsetDateTimeCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToOffsetDateTime((String)input);
            }
            if (input instanceof OffsetDateTime) {
                return ((OffsetDateTime)input).withOffsetSameInstant(ZoneOffset.of("Z"));
            }
            if (input instanceof LocalDate) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToOffsetDateTime((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToOffsetDateTime(((Integer)input).intValue());
            }
            return null;
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToOffsetDateTime(((StringValue)input).getValue());
            }
            return null;
        }

        private OffsetDateTime parseLongToOffsetDateTime(long input) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId());
        }

        private OffsetDateTime parseStringToOffsetDateTime(String input) {
            try {
                return OffsetDateTime.parse(input);
            }
            catch (DateTimeParseException e) {
                log.warn("Failed to parse Date from input: " + input, (Throwable)e);
                return null;
            }
        }
    }

    public static final class DateTimeHelper {
        static final List<Function<String, Instant>> CONVERTERS = new CopyOnWriteArrayList<Function<String, Instant>>();

        public static Instant parseDate(String date) {
            Objects.requireNonNull(date, "date");
            for (Function<String, Instant> converter : CONVERTERS) {
                try {
                    return converter.apply(date);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            return null;
        }

        static {
            CONVERTERS.add(new InstantConverter());
            CONVERTERS.add(new OffsetDateTimeConverter());
            CONVERTERS.add(new ZonedDateTimeConverter());
            CONVERTERS.add(new LocalDateTimeConverter());
            CONVERTERS.add(new LocalDateConverter());
        }

        static class InstantConverter
        implements Function<String, Instant> {
            InstantConverter() {
            }

            @Override
            public Instant apply(String date) {
                return Instant.parse(date);
            }
        }

        static class OffsetDateTimeConverter
        implements Function<String, Instant> {
            static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);

            OffsetDateTimeConverter() {
            }

            @Override
            public Instant apply(String date) {
                return OffsetDateTime.parse(date, FORMATTER).toInstant();
            }
        }

        static class ZonedDateTimeConverter
        implements Function<String, Instant> {
            static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(ZoneOffset.UTC);

            ZonedDateTimeConverter() {
            }

            @Override
            public Instant apply(String date) {
                return ZonedDateTime.parse(date, FORMATTER).toInstant();
            }
        }

        static class LocalDateTimeConverter
        implements Function<String, Instant> {
            static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC);

            LocalDateTimeConverter() {
            }

            @Override
            public Instant apply(String date) {
                return LocalDateTime.parse(date, FORMATTER).toInstant(ZoneOffset.UTC);
            }
        }

        static class LocalDateConverter
        implements Function<String, Instant> {
            static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC);

            LocalDateConverter() {
            }

            @Override
            public Instant apply(String date) {
                LocalDate localDate = LocalDate.parse(date, FORMATTER);
                return localDate.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
        }
    }

    public static class GraphQLRawObjectCoercing
    implements Coercing<Object, Object> {
        public Object serialize(Object input) {
            return input;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return input;
        }
    }
}

