/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema;

import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import graphql.language.NamedNode;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.SchemaGeneratorPostProcessing;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.function.Function;

public class JavaScalarsWiringPostProcessor
implements SchemaGeneratorPostProcessing {
    public GraphQLSchema process(GraphQLSchema originalSchema) {
        Visitor visitor = new Visitor();
        return SchemaTransformer.transformSchema((GraphQLSchema)originalSchema, (GraphQLTypeVisitor)visitor);
    }

    class Visitor
    extends GraphQLTypeVisitorStub {
        private boolean schemaChanged = false;

        Visitor() {
        }

        public boolean schemaChanged() {
            return this.schemaChanged;
        }

        private TraversalControl changOrContinue(GraphQLSchemaElement node, GraphQLSchemaElement newNode, TraverserContext<GraphQLSchemaElement> context) {
            if (node != newNode) {
                TreeTransformerUtil.changeNode(context, (Object)newNode);
                this.schemaChanged = true;
            }
            return TraversalControl.CONTINUE;
        }

        private boolean isIntrospectionType(GraphQLNamedType type) {
            return type.getName().startsWith("__");
        }

        private <T extends GraphQLNamedType> boolean notSuitable(T node, Function<T, NamedNode<?>> suitableFunc) {
            if (this.isIntrospectionType(node)) {
                return true;
            }
            NamedNode<?> definition = suitableFunc.apply(node);
            return definition == null;
        }

        public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLSchemaElement> context) {
            if (this.notSuitable(node, GraphQLScalarType::getDefinition)) {
                return TraversalControl.CONTINUE;
            }
            GraphQLScalarType newNode = JavaScalars.of(node.getName()).orElse(node);
            return this.changOrContinue((GraphQLSchemaElement)node, (GraphQLSchemaElement)newNode, context);
        }
    }
}

