/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import graphql.Assert;
import graphql.AssertException;
import graphql.GraphQLException;
import graphql.Internal;
import graphql.Scalars;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.parser.Parser;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class AstValueHelper {
    public static Value astFromValue(Object value, GraphQLType type) {
        if (value == null) {
            return null;
        }
        if (GraphQLTypeUtil.isNonNull((GraphQLType)type)) {
            return AstValueHelper.handleNonNull(value, (GraphQLNonNull)type);
        }
        if (GraphQLTypeUtil.isList((GraphQLType)type)) {
            return AstValueHelper.handleList(value, (GraphQLList)type);
        }
        if (type instanceof GraphQLInputObjectType) {
            return AstValueHelper.handleInputObject(value, (GraphQLInputObjectType)type);
        }
        if (!(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType)) {
            throw new AssertException("Must provide Input Type, cannot use: " + String.valueOf(type.getClass()));
        }
        Object serialized = AstValueHelper.serialize(type, value);
        if (AstValueHelper.isNullish(serialized)) {
            return null;
        }
        if (serialized instanceof Boolean) {
            return BooleanValue.newBooleanValue().value(((Boolean)serialized).booleanValue()).build();
        }
        String stringValue = serialized.toString();
        if (serialized instanceof Number) {
            return AstValueHelper.handleNumber(stringValue);
        }
        if (serialized instanceof String) {
            if (type instanceof GraphQLEnumType) {
                return EnumValue.newEnumValue().name(stringValue).build();
            }
            if (type == Scalars.GraphQLID && stringValue.matches("^[0-9]+$")) {
                return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
            }
            return StringValue.newStringValue().value(AstValueHelper.jsonStringify(stringValue)).build();
        }
        throw new AssertException("'Cannot convert value to AST: " + String.valueOf(serialized));
    }

    private static Value handleInputObject(Object _value, GraphQLInputObjectType type) {
        Map mapValue = AstValueHelper.objToMap(_value);
        List fields = type.getFields();
        ArrayList fieldNodes = new ArrayList();
        fields.forEach(field -> {
            GraphQLInputType fieldType = field.getType();
            Value nodeValue = AstValueHelper.astFromValue(mapValue.get(field.getName()), (GraphQLType)fieldType);
            if (nodeValue != null) {
                fieldNodes.add(ObjectField.newObjectField().name(field.getName()).value(nodeValue).build());
            } else if (mapValue.containsKey(field.getName())) {
                fieldNodes.add(ObjectField.newObjectField().name(field.getName()).value((Value)NullValue.of()).build());
            }
        });
        return ObjectValue.newObjectValue().objectFields(fieldNodes).build();
    }

    private static Value handleNumber(String stringValue) {
        if (stringValue.matches("^[0-9]+$")) {
            return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
        }
        return FloatValue.newFloatValue().value(new BigDecimal(stringValue)).build();
    }

    private static Value handleList(Object _value, GraphQLList type) {
        GraphQLType itemType = type.getWrappedType();
        boolean isIterable = _value instanceof Iterable;
        if (isIterable || _value != null && _value.getClass().isArray()) {
            Iterable iterable = isIterable ? (Iterable)_value : FpKit.toCollection((Object)_value);
            ArrayList<Value> valuesNodes = new ArrayList<Value>();
            for (Object item : iterable) {
                Value itemNode = AstValueHelper.astFromValue(item, itemType);
                if (itemNode == null) continue;
                valuesNodes.add(itemNode);
            }
            return ArrayValue.newArrayValue().values(valuesNodes).build();
        }
        return AstValueHelper.astFromValue(_value, itemType);
    }

    private static Value handleNonNull(Object _value, GraphQLNonNull type) {
        GraphQLType wrappedType = type.getWrappedType();
        return AstValueHelper.astFromValue(_value, wrappedType);
    }

    static String jsonStringify(String stringValue) {
        StringBuilder sb = new StringBuilder();
        block10: for (char ch : stringValue.toCharArray()) {
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static Object serialize(GraphQLType type, Object value) {
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().serialize(value);
        }
        return ((GraphQLEnumType)type).serialize(value);
    }

    private static boolean isNullish(Object serialized) {
        if (serialized instanceof Number) {
            return Double.isNaN(((Number)serialized).doubleValue());
        }
        return serialized == null;
    }

    private static Map objToMap(Object value) {
        if (value instanceof Map) {
            return (Map)value;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            BeanInfo info = Introspector.getBeanInfo(value.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                Method reader = pd.getReadMethod();
                if (reader == null) continue;
                result.put(pd.getName(), reader.invoke(value, new Object[0]));
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException((Throwable)e);
        }
        return result;
    }

    public static Value valueFromAst(String astLiteral) {
        String toParse = "input X { x : String = " + astLiteral + "}";
        try {
            Document doc = new Parser().parseDocument(toParse);
            InputObjectTypeDefinition inputType = (InputObjectTypeDefinition)doc.getDefinitions().get(0);
            InputValueDefinition inputValueDefinition = (InputValueDefinition)inputType.getInputValueDefinitions().get(0);
            return inputValueDefinition.getDefaultValue();
        }
        catch (Exception e) {
            return (Value)Assert.assertShouldNeverHappen((String)"valueFromAst of '%s' failed because of '%s'", (Object[])new Object[]{astLiteral, e.getMessage()});
        }
    }
}

