/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.annotation.GraphQLDefaultOrderBy;
import com.introproventures.graphql.jpa.query.annotation.GraphQLDescription;
import com.introproventures.graphql.jpa.query.annotation.GraphQLIgnore;
import com.introproventures.graphql.jpa.query.introspection.ClassDescriptor;
import com.introproventures.graphql.jpa.query.introspection.ClassIntrospector;
import com.introproventures.graphql.jpa.query.introspection.FieldDescriptor;
import com.introproventures.graphql.jpa.query.introspection.MethodDescriptor;
import com.introproventures.graphql.jpa.query.introspection.PropertyDescriptor;
import jakarta.persistence.OrderBy;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityIntrospector {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityIntrospector.class);
    private static final Map<Class<?>, EntityIntrospectionResult> map = new LinkedHashMap();
    private static ClassIntrospector introspector = ClassIntrospector.builder().withScanAccessible(false).withEnhancedProperties(true).withIncludeFieldsAsProperties(false).withScanStatics(false).build();

    public static EntityIntrospectionResult resultOf(Class<?> entity) {
        return Optional.ofNullable(map.get(entity)).orElseThrow(() -> new NoSuchElementException(entity.getName()));
    }

    public static EntityIntrospectionResult introspect(ManagedType<?> entityType) {
        return map.computeIfAbsent(entityType.getJavaType(), cls -> new EntityIntrospectionResult(entityType));
    }

    public static <T> Stream<T> iterate(final T seed, final Function<T, Optional<T>> f) {
        Objects.requireNonNull(f);
        Iterator iterator = new Iterator<T>(){
            private Optional<T> t;
            {
                this.t = Optional.ofNullable(seed);
            }

            @Override
            public boolean hasNext() {
                return this.t.isPresent();
            }

            @Override
            public T next() {
                Object v = this.t.get();
                this.t = (Optional)f.apply(v);
                return v;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1040), false);
    }

    private static NoSuchElementException noSuchElementException(Class<?> containerClass, String propertyName) {
        return new NoSuchElementException(String.format(Locale.ROOT, "Could not locate field name [%s] on class [%s]", propertyName, containerClass.getName()));
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static class EntityIntrospectionResult {
        private final Map<String, AttributePropertyDescriptor> descriptors;
        private final Class<?> entity;
        private final ClassDescriptor classDescriptor;
        private final ManagedType<?> managedType;
        private final Map<String, Attribute<?, ?>> attributes;

        public EntityIntrospectionResult(ManagedType<?> managedType) {
            this.managedType = managedType;
            this.attributes = managedType.getAttributes().stream().collect(Collectors.toMap(Attribute::getName, Function.identity()));
            this.entity = managedType.getJavaType();
            this.classDescriptor = introspector.introspect(this.entity);
            this.descriptors = Stream.of(this.classDescriptor.getAllPropertyDescriptors()).filter(it -> !"class".equals(it.getName())).map(x$0 -> new AttributePropertyDescriptor((PropertyDescriptor)x$0)).collect(Collectors.toMap(AttributePropertyDescriptor::getName, Function.identity()));
        }

        public Collection<AttributePropertyDescriptor> getTransientPropertyDescriptors() {
            return this.descriptors.values().stream().filter(AttributePropertyDescriptor::isTransient).collect(Collectors.toList());
        }

        public Collection<AttributePropertyDescriptor> getPersistentPropertyDescriptors() {
            return this.descriptors.values().stream().filter(AttributePropertyDescriptor::isPersistent).collect(Collectors.toList());
        }

        public Collection<AttributePropertyDescriptor> getIgnoredPropertyDescriptors() {
            return this.descriptors.values().stream().filter(AttributePropertyDescriptor::isIgnored).collect(Collectors.toList());
        }

        public Map<String, Attribute<?, ?>> getAttributes() {
            return this.attributes;
        }

        public Boolean isIgnored(String propertyName) {
            return this.getPropertyDescriptor(propertyName).map(AttributePropertyDescriptor::isIgnored).orElseThrow(() -> EntityIntrospector.noSuchElementException(this.entity, propertyName));
        }

        public Boolean isNotIgnored(String propertyName) {
            return this.getPropertyDescriptor(propertyName).map(AttributePropertyDescriptor::isNotIgnored).orElseThrow(() -> EntityIntrospector.noSuchElementException(this.entity, propertyName));
        }

        public Collection<AttributePropertyDescriptor> getPropertyDescriptors() {
            return this.descriptors.values();
        }

        public Optional<AttributePropertyDescriptor> getPropertyDescriptor(String fieldName) {
            return Optional.ofNullable(this.descriptors.get(fieldName));
        }

        public Optional<AttributePropertyDescriptor> getPropertyDescriptor(Attribute<?, ?> attribute) {
            return this.getPropertyDescriptor(attribute.getName());
        }

        public boolean hasPropertyDescriptor(String fieldName) {
            return this.descriptors.containsKey(fieldName);
        }

        public Boolean isTransient(String propertyName) {
            return this.getPropertyDescriptor(propertyName).map(AttributePropertyDescriptor::isTransient).orElseThrow(() -> EntityIntrospector.noSuchElementException(this.entity, propertyName));
        }

        public Boolean isPersistent(String propertyName) {
            return this.isTransient(propertyName) == false;
        }

        public Class<?> getEntity() {
            return this.entity;
        }

        public ManagedType<?> getManagedType() {
            return this.managedType;
        }

        public ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        public Optional<String> getSchemaDescription() {
            return this.getClasses().filter(cls -> !Object.class.equals(cls)).map(cls -> Optional.ofNullable(cls.getAnnotation(GraphQLDescription.class)).map(GraphQLDescription::value)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }

        public boolean hasSchemaDescription() {
            return this.getSchemaDescription().isPresent();
        }

        public Optional<String> getSchemaDescription(String propertyName) {
            return this.getPropertyDescriptor(propertyName).flatMap(AttributePropertyDescriptor::getSchemaDescription);
        }

        public Stream<Class<?>> getClasses() {
            return EntityIntrospector.iterate(this.entity, k -> Optional.ofNullable(k.getSuperclass()));
        }

        public int hashCode() {
            return Objects.hash(this.classDescriptor, this.entity);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityIntrospectionResult other = (EntityIntrospectionResult)obj;
            return Objects.equals(this.classDescriptor, other.classDescriptor) && Objects.equals(this.entity, other.entity);
        }

        public String toString() {
            return "EntityIntrospectionResult [beanInfo=" + String.valueOf(this.classDescriptor) + "]";
        }

        public class AttributePropertyDescriptor {
            private final PropertyDescriptor delegate;
            private final Optional<Attribute<?, ?>> attribute;
            private final Optional<Field> field;
            private final Optional<Method> readMethod;

            public AttributePropertyDescriptor(PropertyDescriptor delegate) {
                this.delegate = delegate;
                String name = delegate.getName();
                this.readMethod = Optional.ofNullable(delegate.getReadMethodDescriptor()).map(MethodDescriptor::getMethod).filter(m -> !Modifier.isPrivate(m.getModifiers()));
                this.attribute = Optional.ofNullable(EntityIntrospectionResult.this.attributes.getOrDefault(name, EntityIntrospectionResult.this.attributes.get(EntityIntrospector.capitalize(name))));
                this.field = this.attribute.map(Attribute::getJavaMember).filter(Field.class::isInstance).map(Field.class::cast).map(Optional::of).orElseGet(() -> Optional.ofNullable(delegate.getFieldDescriptor()).map(FieldDescriptor::getField));
            }

            public ManagedType<?> getManagedType() {
                return EntityIntrospectionResult.this.managedType;
            }

            public PropertyDescriptor getDelegate() {
                return this.delegate;
            }

            public Class<?> getPropertyType() {
                return this.delegate.getType();
            }

            public String getName() {
                return this.attribute.map(Attribute::getName).orElseGet(() -> this.delegate.getName());
            }

            public Optional<Method> getReadMethod() {
                return this.readMethod;
            }

            public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
                return this.getReadMethod().map(m -> m.getAnnotation(annotationClass)).map(Optional::of).orElseGet(() -> this.getField().map(f -> f.getAnnotation(annotationClass)));
            }

            public Optional<Attribute<?, ?>> getAttribute() {
                return this.attribute;
            }

            public Optional<Field> getField() {
                return this.field;
            }

            public Optional<String> getSchemaDescription() {
                return this.getAnnotation(GraphQLDescription.class).map(GraphQLDescription::value);
            }

            public boolean hasSchemaDescription() {
                return this.getSchemaDescription().isPresent();
            }

            public boolean hasDefaultOrderBy() {
                return this.getDefaultOrderBy().isPresent();
            }

            public Optional<GraphQLDefaultOrderBy> getDefaultOrderBy() {
                return this.getAnnotation(GraphQLDefaultOrderBy.class);
            }

            public boolean hasOrderBy() {
                return this.getAnnotation(OrderBy.class).isPresent();
            }

            public Optional<OrderBy> getOrderBy() {
                return this.getAnnotation(OrderBy.class);
            }

            public boolean isTransient() {
                return !this.attribute.isPresent();
            }

            public boolean isPersistent() {
                return this.attribute.isPresent();
            }

            public boolean isIgnored() {
                return this.isAnnotationPresent(GraphQLIgnore.class);
            }

            public boolean isNotIgnored() {
                return !this.isIgnored();
            }

            public boolean hasReadMethod() {
                return this.getReadMethod().isPresent();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
                return this.getAnnotation(annotation).isPresent();
            }

            public String toString() {
                return "AttributePropertyDescriptor [delegate=" + String.valueOf(this.delegate) + "]";
            }

            private EntityIntrospectionResult getEnclosingInstance() {
                return EntityIntrospectionResult.this;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getEnclosingInstance().hashCode();
                result = 31 * result + Objects.hash(this.delegate);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AttributePropertyDescriptor other = (AttributePropertyDescriptor)obj;
                if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                    return false;
                }
                return Objects.equals(this.delegate, other.delegate);
            }
        }
    }
}

