/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.GraphQLExecutor;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutorContext;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutorContextFactory;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaExecutorContextFactory;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@Transactional(value=Transactional.TxType.SUPPORTS)
public class GraphQLJpaExecutor
implements GraphQLExecutor {
    private final GraphQLSchema graphQLSchema;
    private final GraphQLExecutorContextFactory contextFactory;

    public GraphQLJpaExecutor(GraphQLSchema graphQLSchema) {
        this(graphQLSchema, new GraphQLJpaExecutorContextFactory(){});
    }

    public GraphQLJpaExecutor(GraphQLSchema graphQLSchema, GraphQLExecutorContextFactory contextFactory) {
        this.graphQLSchema = graphQLSchema;
        this.contextFactory = contextFactory;
    }

    @Override
    public ExecutionResult execute(String query) {
        return this.execute(query, Collections.emptyMap());
    }

    @Override
    public ExecutionResult execute(String query, Map<String, Object> arguments) {
        return this.execute(query, null, arguments);
    }

    @Override
    public ExecutionResult execute(String query, String operationName, Map<String, Object> arguments) {
        Map variables = Optional.ofNullable(arguments).orElseGet(Collections::emptyMap);
        GraphQLExecutorContext executorContext = this.contextFactory.newExecutorContext(this.graphQLSchema);
        ExecutionInput.Builder executionInput = executorContext.newExecutionInput().query(query).variables(variables);
        Optional.ofNullable(operationName).ifPresent(arg_0 -> ((ExecutionInput.Builder)executionInput).operationName(arg_0));
        GraphQL.Builder graphQL = executorContext.newGraphQL();
        return graphQL.build().execute(executionInput);
    }
}

