/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.GraphQLExecutionInputFactory;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutorContext;
import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLJpaExecutorContext
implements GraphQLExecutorContext {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaExecutorContext.class);
    private final GraphQLSchema graphQLSchema;
    private final GraphQLExecutionInputFactory executionInputFactory;
    private final Supplier<GraphqlFieldVisibility> graphqlFieldVisibility;
    private final Supplier<Instrumentation> instrumentation;
    private final Supplier<GraphQLContext> graphqlContext;
    private final Supplier<DataLoaderRegistry> dataLoaderRegistry;
    private final Supplier<ExecutionStrategy> queryExecutionStrategy;
    private final Supplier<ExecutionStrategy> mutationExecutionStrategy;
    private final Supplier<ExecutionStrategy> subscriptionExecutionStrategy;

    private GraphQLJpaExecutorContext(Builder builder) {
        this.graphQLSchema = builder.graphQLSchema;
        this.executionInputFactory = builder.executionInputFactory;
        this.graphqlFieldVisibility = builder.graphqlFieldVisibility;
        this.instrumentation = builder.instrumentation;
        this.graphqlContext = builder.graphqlContext;
        this.dataLoaderRegistry = builder.dataLoaderRegistry;
        this.queryExecutionStrategy = builder.queryExecutionStrategy;
        this.mutationExecutionStrategy = builder.mutationExecutionStrategy;
        this.subscriptionExecutionStrategy = builder.subscriptionExecutionStrategy;
    }

    @Override
    public ExecutionInput.Builder newExecutionInput() {
        DataLoaderRegistry dataLoaderRegistry = this.newDataLoaderRegistry();
        GraphQLContext context = this.newGraphQLContext();
        return this.executionInputFactory.create().dataLoaderRegistry(dataLoaderRegistry).context((Object)context);
    }

    @Override
    public GraphQL.Builder newGraphQL() {
        Instrumentation instrumentation = this.newIstrumentation();
        return GraphQL.newGraphQL((GraphQLSchema)this.getGraphQLSchema()).instrumentation(instrumentation).queryExecutionStrategy(this.queryExecutionStrategy.get()).mutationExecutionStrategy(this.mutationExecutionStrategy.get()).subscriptionExecutionStrategy(this.subscriptionExecutionStrategy.get());
    }

    public GraphQLContext newGraphQLContext() {
        return this.graphqlContext.get();
    }

    public DataLoaderRegistry newDataLoaderRegistry() {
        return this.dataLoaderRegistry.get();
    }

    public Instrumentation newIstrumentation() {
        List<Instrumentation> list = Arrays.asList(this.instrumentation.get());
        return new ChainedInstrumentation(list);
    }

    @Override
    public GraphQLSchema getGraphQLSchema() {
        GraphQLCodeRegistry codeRegistry = this.graphQLSchema.getCodeRegistry().transform(builder -> builder.fieldVisibility(this.graphqlFieldVisibility.get()));
        return this.graphQLSchema.transform(builder -> builder.codeRegistry(codeRegistry));
    }

    public static IGraphQLSchemaStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IGraphQLSchemaStage,
    IBuildStage {
        private GraphQLSchema graphQLSchema;
        private GraphQLExecutionInputFactory executionInputFactory;
        private Supplier<GraphqlFieldVisibility> graphqlFieldVisibility;
        private Supplier<Instrumentation> instrumentation;
        private Supplier<GraphQLContext> graphqlContext;
        private Supplier<DataLoaderRegistry> dataLoaderRegistry;
        private Supplier<ExecutionStrategy> queryExecutionStrategy;
        private Supplier<ExecutionStrategy> mutationExecutionStrategy;
        private Supplier<ExecutionStrategy> subscriptionExecutionStrategy;

        private Builder() {
        }

        @Override
        public IBuildStage graphQLSchema(GraphQLSchema graphQLSchema) {
            this.graphQLSchema = graphQLSchema;
            return this;
        }

        @Override
        public IBuildStage executionInputFactory(GraphQLExecutionInputFactory executionInputFactory) {
            this.executionInputFactory = executionInputFactory;
            return this;
        }

        @Override
        public IBuildStage graphqlFieldVisibility(Supplier<GraphqlFieldVisibility> graphqlFieldVisibility) {
            this.graphqlFieldVisibility = graphqlFieldVisibility;
            return this;
        }

        @Override
        public IBuildStage instrumentation(Supplier<Instrumentation> instrumentation) {
            this.instrumentation = instrumentation;
            return this;
        }

        @Override
        public IBuildStage graphqlContext(Supplier<GraphQLContext> graphqlContext) {
            this.graphqlContext = graphqlContext;
            return this;
        }

        @Override
        public IBuildStage dataLoaderRegistry(Supplier<DataLoaderRegistry> dataLoaderRegistry) {
            this.dataLoaderRegistry = dataLoaderRegistry;
            return this;
        }

        @Override
        public IBuildStage queryExecutionStrategy(Supplier<ExecutionStrategy> queryExecutionStrategy) {
            this.queryExecutionStrategy = queryExecutionStrategy;
            return this;
        }

        @Override
        public IBuildStage mutationExecutionStrategy(Supplier<ExecutionStrategy> mutationExecutionStrategy) {
            this.mutationExecutionStrategy = mutationExecutionStrategy;
            return this;
        }

        @Override
        public IBuildStage subscriptionExecutionStrategy(Supplier<ExecutionStrategy> subscriptionExecutionStrategy) {
            this.subscriptionExecutionStrategy = subscriptionExecutionStrategy;
            return this;
        }

        @Override
        public GraphQLJpaExecutorContext build() {
            return new GraphQLJpaExecutorContext(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage executionInputFactory(GraphQLExecutionInputFactory var1);

        public IBuildStage graphqlFieldVisibility(Supplier<GraphqlFieldVisibility> var1);

        public IBuildStage instrumentation(Supplier<Instrumentation> var1);

        public IBuildStage graphqlContext(Supplier<GraphQLContext> var1);

        public IBuildStage dataLoaderRegistry(Supplier<DataLoaderRegistry> var1);

        public IBuildStage queryExecutionStrategy(Supplier<ExecutionStrategy> var1);

        public IBuildStage mutationExecutionStrategy(Supplier<ExecutionStrategy> var1);

        public IBuildStage subscriptionExecutionStrategy(Supplier<ExecutionStrategy> var1);

        public GraphQLJpaExecutorContext build();
    }

    public static interface IGraphQLSchemaStage {
        public IBuildStage graphQLSchema(GraphQLSchema var1);
    }
}

