/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.GraphQLExecutionInputFactory;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutorContext;
import com.introproventures.graphql.jpa.query.schema.GraphQLExecutorContextFactory;
import com.introproventures.graphql.jpa.query.schema.impl.BatchLoaderRegistry;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaExecutorContext;
import graphql.GraphQLContext;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.schema.GraphQLSchema;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.function.Supplier;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLJpaExecutorContextFactory
implements GraphQLExecutorContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaExecutorContext.class);
    private GraphQLExecutionInputFactory executionInputFactory = new GraphQLExecutionInputFactory(){};
    private Supplier<GraphqlFieldVisibility> graphqlFieldVisibility = () -> DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
    private Supplier<Instrumentation> instrumentation = () -> new SimpleInstrumentation();
    private Supplier<GraphQLContext> graphqlContext = () -> GraphQLContext.newContext().build();
    private Supplier<DataLoaderOptions> dataLoaderOptions = () -> DataLoaderOptions.newOptions();
    private Supplier<DataLoaderRegistry> dataLoaderRegistry = () -> {
        DataLoaderOptions options = this.dataLoaderOptions.get().setCachingEnabled(false);
        return BatchLoaderRegistry.newDataLoaderRegistry(options);
    };
    private Supplier<ExecutionStrategy> queryExecutionStrategy = AsyncExecutionStrategy::new;
    private Supplier<ExecutionStrategy> mutationExecutionStrategy = AsyncSerialExecutionStrategy::new;
    private Supplier<ExecutionStrategy> subscriptionExecutionStrategy = SubscriptionExecutionStrategy::new;

    @Override
    public GraphQLExecutorContext newExecutorContext(GraphQLSchema graphQLSchema) {
        return GraphQLJpaExecutorContext.builder().graphQLSchema(graphQLSchema).executionInputFactory(this.executionInputFactory).graphqlFieldVisibility(this.graphqlFieldVisibility).instrumentation(this.instrumentation).graphqlContext(this.graphqlContext).dataLoaderRegistry(this.dataLoaderRegistry).queryExecutionStrategy(this.queryExecutionStrategy).mutationExecutionStrategy(this.mutationExecutionStrategy).subscriptionExecutionStrategy(this.subscriptionExecutionStrategy).build();
    }

    public GraphQLJpaExecutorContextFactory withGraphqlFieldVisibility(Supplier<GraphqlFieldVisibility> graphqlFieldVisibility) {
        this.graphqlFieldVisibility = graphqlFieldVisibility;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withInstrumentation(Supplier<Instrumentation> instrumentation) {
        this.instrumentation = instrumentation;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withExecutionInputFactory(GraphQLExecutionInputFactory executionInputFactory) {
        this.executionInputFactory = executionInputFactory;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withGraphqlContext(Supplier<GraphQLContext> graphqlContext) {
        this.graphqlContext = graphqlContext;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withQueryExecutionStrategy(Supplier<ExecutionStrategy> queryExecutionStrategy) {
        this.queryExecutionStrategy = queryExecutionStrategy;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withMutationExecutionStrategy(Supplier<ExecutionStrategy> mutationExecutionStrategy) {
        this.mutationExecutionStrategy = mutationExecutionStrategy;
        return this;
    }

    public GraphQLJpaExecutorContextFactory withSubscriptionExecutionStrategy(Supplier<ExecutionStrategy> subscriptionExecutionStrategy) {
        this.subscriptionExecutionStrategy = subscriptionExecutionStrategy;
        return this;
    }

    public GraphQLExecutionInputFactory getExecutionInputFactory() {
        return this.executionInputFactory;
    }

    public Supplier<GraphqlFieldVisibility> getGraphqlFieldVisibility() {
        return this.graphqlFieldVisibility;
    }

    public Supplier<Instrumentation> getInstrumentation() {
        return this.instrumentation;
    }

    public Supplier<GraphQLContext> getGraphqlContext() {
        return this.graphqlContext;
    }
}

