/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import com.introproventures.graphql.jpa.query.schema.impl.PageArgument;
import com.introproventures.graphql.jpa.query.schema.impl.PagedResult;
import com.introproventures.graphql.jpa.query.support.GraphQLSupport;
import graphql.GraphQLException;
import graphql.language.Argument;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLJpaQueryDataFetcher
implements DataFetcher<PagedResult<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaQueryDataFetcher.class);
    private final int defaultMaxResults;
    private final int defaultPageLimitSize;
    private final boolean enableDefaultMaxResults;
    private final GraphQLJpaQueryFactory queryFactory;

    private GraphQLJpaQueryDataFetcher(Builder builder) {
        this.queryFactory = builder.queryFactory;
        this.defaultMaxResults = builder.defaultMaxResults;
        this.defaultPageLimitSize = builder.defaultPageLimitSize;
        this.enableDefaultMaxResults = builder.enableDefaultMaxResults;
    }

    public PagedResult<Object> get(DataFetchingEnvironment environment) {
        Field rootNode = environment.getField();
        Optional<Argument> pageArgument = GraphQLSupport.getPageArgument(environment.getField());
        PageArgument page = GraphQLSupport.extractPageArgument(environment, pageArgument, this.defaultPageLimitSize);
        Optional<Field> pagesSelection = GraphQLSupport.getSelectionField(rootNode, "pages");
        Optional<Field> totalSelection = GraphQLSupport.getSelectionField(rootNode, "total");
        Optional<Field> recordsSelection = GraphQLSupport.searchByFieldName(rootNode, "select");
        Optional<Field> aggregateSelection = GraphQLSupport.getSelectionField(rootNode, "aggregate");
        int firstResult = page.getOffset();
        int maxResults = Integer.min(page.getLimit(), this.defaultMaxResults);
        PagedResult.Builder<Object> pagedResult = PagedResult.builder().withOffset(firstResult).withLimit(maxResults);
        Optional<List<Object>> restrictedKeys = this.queryFactory.getRestrictedKeys(environment);
        if (recordsSelection.isPresent() && restrictedKeys.isPresent()) {
            ArrayList<Object> queryKeys = new ArrayList<Object>();
            if (pageArgument.isPresent() || this.enableDefaultMaxResults) {
                queryKeys.addAll(this.queryFactory.queryKeys(environment, firstResult, maxResults, restrictedKeys.get()));
            } else {
                queryKeys.addAll((Collection)restrictedKeys.get());
            }
            List<Object> resultList = this.queryFactory.queryResultList(environment, maxResults, queryKeys);
            pagedResult.withSelect(resultList);
        }
        if (totalSelection.isPresent() || pagesSelection.isPresent()) {
            Long total = this.queryFactory.queryTotalCount(environment, restrictedKeys);
            pagedResult.withTotal(total);
        }
        aggregateSelection.ifPresent(aggregateField -> {
            LinkedHashMap<String, Object> aggregate = new LinkedHashMap<String, Object>();
            GraphQLSupport.getFields(aggregateField.getSelectionSet(), "count").forEach(countField -> GraphQLJpaQueryDataFetcher.getCountOfArgument(countField).ifPresentOrElse(argument -> aggregate.put(GraphQLSupport.getAliasOrName(countField), this.queryFactory.queryAggregateCount((String)argument, environment, restrictedKeys)), () -> aggregate.put(GraphQLSupport.getAliasOrName(countField), this.queryFactory.queryTotalCount(environment, restrictedKeys))));
            GraphQLSupport.getFields(aggregateField.getSelectionSet(), "group").forEach(groupField -> {
                Field countField = (Field)GraphQLSupport.getFields(groupField.getSelectionSet(), "count").stream().findFirst().orElseThrow(() -> new GraphQLException("Missing aggregate count for group: " + String.valueOf(groupField)));
                Optional<String> countOfArgumentValue = GraphQLJpaQueryDataFetcher.getCountOfArgument(countField);
                Map.Entry[] groupings = (Map.Entry[])GraphQLSupport.getFields(groupField.getSelectionSet(), "by").stream().map(GraphQLJpaQueryDataFetcher::groupByFieldEntry).toArray(Map.Entry[]::new);
                if (groupings.length == 0) {
                    throw new GraphQLException("At least one field is required for aggregate group: " + String.valueOf(groupField));
                }
                List<Map> resultList = this.queryFactory.queryAggregateGroupByCount(GraphQLSupport.getAliasOrName(countField), countOfArgumentValue, environment, restrictedKeys, groupings).stream().peek(map -> Stream.of(groupings).forEach(group -> {
                    Object value = map.get(group.getKey());
                    Optional.ofNullable(value).map(Object::getClass).map(JavaScalars::of).map(GraphQLScalarType::getCoercing).ifPresent(coercing -> map.put(group.getKey(), coercing.serialize(value)));
                })).toList();
                aggregate.put(GraphQLSupport.getAliasOrName(groupField), resultList);
            });
            GraphQLSupport.getSelectionField(aggregateField, "by").map(byField -> byField.getSelectionSet().getSelections().stream().map(Field.class::cast).toList()).filter(Predicate.not(List::isEmpty)).ifPresent(aggregateBySelections -> {
                LinkedHashMap aggregatesBy = new LinkedHashMap();
                aggregate.put("by", aggregatesBy);
                aggregateBySelections.forEach(groupField -> {
                    Field countField = (Field)GraphQLSupport.getFields(groupField.getSelectionSet(), "count").stream().findFirst().orElseThrow(() -> new GraphQLException("Missing aggregate count for group: " + String.valueOf(groupField)));
                    Map.Entry[] groupings = (Map.Entry[])GraphQLSupport.getFields(groupField.getSelectionSet(), "by").stream().map(GraphQLJpaQueryDataFetcher::groupByFieldEntry).toArray(Map.Entry[]::new);
                    if (groupings.length == 0) {
                        throw new GraphQLException("At least one field is required for aggregate group: " + String.valueOf(groupField));
                    }
                    List<Map> resultList = this.queryFactory.queryAggregateGroupByAssociationCount(GraphQLSupport.getAliasOrName(countField), groupField.getName(), environment, restrictedKeys, groupings).stream().peek(map -> Stream.of(groupings).forEach(group -> {
                        Object value = map.get(group.getKey());
                        Optional.ofNullable(value).map(Object::getClass).map(JavaScalars::of).map(GraphQLScalarType::getCoercing).ifPresent(coercing -> map.put(group.getKey(), coercing.serialize(value)));
                    })).toList();
                    aggregatesBy.put(GraphQLSupport.getAliasOrName(groupField), resultList);
                });
            });
            pagedResult.withAggregate(aggregate);
        });
        return pagedResult.build();
    }

    static Map.Entry<String, String> groupByFieldEntry(Field selectedField) {
        String key = Optional.ofNullable(selectedField.getAlias()).orElse(selectedField.getName());
        String value = GraphQLSupport.findArgument(selectedField, "field").map(Argument::getValue).map(EnumValue.class::cast).map(EnumValue::getName).orElseThrow(() -> new GraphQLException("group by argument is required."));
        return Map.entry(key, value);
    }

    static Map.Entry<String, String> countFieldEntry(Field selectedField) {
        String key = Optional.ofNullable(selectedField.getAlias()).orElse(selectedField.getName());
        String value = GraphQLJpaQueryDataFetcher.getCountOfArgument(selectedField).orElse(selectedField.getName());
        return Map.entry(key, value);
    }

    static Optional<String> getCountOfArgument(Field selectedField) {
        return GraphQLSupport.findArgument(selectedField, "of").map(Argument::getValue).map(EnumValue.class::cast).map(EnumValue::getName);
    }

    public int getDefaultMaxResults() {
        return this.defaultMaxResults;
    }

    public int getDefaultPageLimitSize() {
        return this.defaultPageLimitSize;
    }

    public static IQueryFactoryStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IQueryFactoryStage,
    IDefaultMaxResultsStage,
    IDefaultPageLimitSizeStage,
    IBuildStage {
        private GraphQLJpaQueryFactory queryFactory;
        private int defaultMaxResults;
        private int defaultPageLimitSize;
        private boolean enableDefaultMaxResults;

        private Builder() {
        }

        @Override
        public IDefaultMaxResultsStage withQueryFactory(GraphQLJpaQueryFactory queryFactory) {
            this.queryFactory = queryFactory;
            return this;
        }

        @Override
        public IDefaultMaxResultsStage withDefaultMaxResults(int defaultMaxResults) {
            this.defaultMaxResults = defaultMaxResults;
            return this;
        }

        @Override
        public IBuildStage withDefaultPageLimitSize(int defaultPageLimitSize) {
            this.defaultPageLimitSize = defaultPageLimitSize;
            return this;
        }

        @Override
        public GraphQLJpaQueryDataFetcher build() {
            return new GraphQLJpaQueryDataFetcher(this);
        }

        @Override
        public IDefaultPageLimitSizeStage withEnableDefaultMaxResults(boolean enableDefaultMaxResults) {
            this.enableDefaultMaxResults = enableDefaultMaxResults;
            return this;
        }
    }

    public static interface IBuildStage {
        public GraphQLJpaQueryDataFetcher build();
    }

    public static interface IDefaultPageLimitSizeStage {
        public IBuildStage withDefaultPageLimitSize(int var1);
    }

    public static interface IDefaultMaxResultsStage {
        public IDefaultMaxResultsStage withDefaultMaxResults(int var1);

        public IDefaultPageLimitSizeStage withEnableDefaultMaxResults(boolean var1);
    }

    public static interface IQueryFactoryStage {
        public IDefaultMaxResultsStage withQueryFactory(GraphQLJpaQueryFactory var1);
    }
}

