/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.annotation.GraphQLDefaultOrderBy;
import com.introproventures.graphql.jpa.query.introspection.ReflectionUtil;
import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.RestrictedKeysProvider;
import com.introproventures.graphql.jpa.query.schema.impl.AstValueHelper;
import com.introproventures.graphql.jpa.query.schema.impl.DataFetchingEnvironmentBuilder;
import com.introproventures.graphql.jpa.query.schema.impl.EntityIntrospector;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLObjectTypeMetadata;
import com.introproventures.graphql.jpa.query.schema.impl.JpaPredicateBuilder;
import com.introproventures.graphql.jpa.query.schema.impl.Logical;
import com.introproventures.graphql.jpa.query.schema.impl.PredicateFilter;
import com.introproventures.graphql.jpa.query.schema.impl.ResultStreamWrapper;
import com.introproventures.graphql.jpa.query.support.GraphQLSupport;
import graphql.GraphQLContext;
import graphql.GraphQLException;
import graphql.execution.CoercedVariables;
import graphql.execution.MergedField;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import jakarta.persistence.TupleElement;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphQLJpaQueryFactory {
    private static final String DESC = "DESC";
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaQueryFactory.class);
    public static final String JAKARTA_PERSISTENCE_FETCHGRAPH = "jakarta.persistence.fetchgraph";
    private static Function<Object, Object> unproxy;
    protected static final String WHERE = "where";
    protected static final String OPTIONAL = "optional";
    protected static final String ORG_HIBERNATE_CACHEABLE = "org.hibernate.cacheable";
    protected static final String ORG_HIBERNATE_FETCH_SIZE = "org.hibernate.fetchSize";
    protected static final String ORG_HIBERNATE_READ_ONLY = "org.hibernate.readOnly";
    private final Map<GraphQLObjectType, EntityType> entityTypeMap = new ConcurrentHashMap<GraphQLObjectType, EntityType>();
    private final Map<GraphQLObjectType, EmbeddableType> embeddableTypeMap = new ConcurrentHashMap<GraphQLObjectType, EmbeddableType>();
    protected final EntityManager entityManager;
    protected final EntityType<?> entityType;
    private final boolean toManyDefaultOptional;
    private final boolean defaultDistinct;
    private final String selectNodeName;
    private final GraphQLObjectType entityObjectType;
    private final int defaultFetchSize;
    private final RestrictedKeysProvider restrictedKeysProvider;
    private final boolean resultStream;
    private final GraphQLObjectTypeMetadata graphQLObjectTypeMetadata;

    private GraphQLJpaQueryFactory(Builder builder) {
        this.entityManager = builder.entityManager;
        this.entityType = builder.entityType;
        this.entityObjectType = builder.entityObjectType;
        this.selectNodeName = builder.selectNodeName;
        this.toManyDefaultOptional = builder.toManyDefaultOptional;
        this.defaultDistinct = builder.defaultDistinct;
        this.defaultFetchSize = builder.defaultFetchSize;
        this.restrictedKeysProvider = builder.restrictedKeysProvider;
        this.resultStream = builder.resultStream;
        this.graphQLObjectTypeMetadata = builder.graphQLObjectTypeMetadata;
    }

    public DataFetchingEnvironment getQueryEnvironment(DataFetchingEnvironment environment, MergedField queryField) {
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).fieldType((GraphQLOutputType)this.getEntityObjectType()).mergedField(queryField).build();
    }

    public Optional<List<Object>> getRestrictedKeys(DataFetchingEnvironment environment) {
        EntityIntrospector.EntityIntrospectionResult entityDescriptor = EntityIntrospector.introspect(this.entityType);
        Optional<List<Object>> restrictedKeys = this.restrictedKeysProvider.apply(entityDescriptor);
        ArrayList restrictedKeysValues = new ArrayList();
        if (restrictedKeys.isPresent()) {
            restrictedKeys.get().stream().filter(key -> !"*".equals(key)).map(key -> {
                Type idType = this.entityType.getIdType();
                Class clazz = idType.getJavaType();
                GraphQLScalarType scalar = JavaScalars.of((Class)clazz);
                return scalar.getCoercing().parseValue(key);
            }).forEach(restrictedKeysValues::add);
            return Optional.of(restrictedKeysValues);
        }
        return Optional.empty();
    }

    public List<Object> queryKeys(DataFetchingEnvironment environment, int firstResult, int maxResults, List<Object> restrictedKeys) {
        MergedField queryField = this.resolveQueryField(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        TypedQuery<Object> keysQuery = this.getKeysQuery(queryEnvironment, queryEnvironment.getField(), restrictedKeys);
        keysQuery.setFirstResult(firstResult).setMaxResults(maxResults);
        if (logger.isDebugEnabled()) {
            logger.info("\nGraphQL JPQL Keys Query String:\n    {}", (Object)this.getJPQLQueryString(keysQuery));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Query keys in session {} for field {} on {}", new Object[]{this.entityManager, environment.getField().getName(), Thread.currentThread()});
        }
        return keysQuery.getResultList();
    }

    public List<Object> queryResultList(DataFetchingEnvironment environment, int maxResults, List<Object> keys) {
        Stream<Object> resultStream = this.queryResultStream(environment, maxResults, keys);
        int size = keys.isEmpty() ? maxResults : Integer.min(keys.size(), maxResults);
        return ResultStreamWrapper.wrap(resultStream, size);
    }

    protected Stream<Object> queryResultStream(DataFetchingEnvironment environment, int maxResults, List<Object> keys) {
        MergedField queryField = this.resolveQueryField(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        int fetchSize = Integer.min(maxResults, this.defaultFetchSize);
        boolean isDistinct = this.resolveDistinctArgument(queryEnvironment.getField());
        TypedQuery query = this.getQuery(queryEnvironment, queryEnvironment.getField(), isDistinct, keys.toArray());
        EntityGraph<?> entityGraph = this.createEntityGraph(queryEnvironment);
        return this.getResultStream(query, fetchSize, isDistinct, entityGraph);
    }

    protected <T> Stream<T> getResultStream(TypedQuery<T> query, int fetchSize, boolean isDistinct, EntityGraph<?> entityGraph) {
        query.setHint(ORG_HIBERNATE_READ_ONLY, (Object)true);
        query.setHint(ORG_HIBERNATE_FETCH_SIZE, (Object)fetchSize);
        query.setHint(ORG_HIBERNATE_CACHEABLE, (Object)false);
        if (entityGraph != null) {
            query.setHint(JAKARTA_PERSISTENCE_FETCHGRAPH, entityGraph);
        }
        if (logger.isDebugEnabled()) {
            logger.info("\nGraphQL JPQL Fetch Query String:\n    {}", (Object)this.getJPQLQueryString(query));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Query results in session {} for query {} running on {}", new Object[]{this.entityManager, this.getJPQLQueryString(query), Thread.currentThread()});
        }
        Stream resultStream = this.resultStream ? query.getResultStream() : query.getResultList().stream();
        return resultStream.map(this::unproxy).peek(this::detach);
    }

    protected Object querySingleResult(DataFetchingEnvironment environment) {
        MergedField queryField = this.flattenEmbeddedIdArguments(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        Optional<List<Object>> restrictedKeys = this.getRestrictedKeys(queryEnvironment);
        if (restrictedKeys.isPresent()) {
            TypedQuery query = this.getQuery(queryEnvironment, queryEnvironment.getField(), true, restrictedKeys.get().toArray());
            if (logger.isDebugEnabled()) {
                logger.info("\nGraphQL JPQL Single Result Query String:\n    {}", (Object)this.getJPQLQueryString(query));
            }
            return Optional.ofNullable(query.getSingleResult()).map(this::unproxyAndThenDetach).orElse(null);
        }
        return null;
    }

    public Long queryTotalCount(DataFetchingEnvironment environment, Optional<List<Object>> restrictedKeys) {
        MergedField queryField = this.flattenEmbeddedIdArguments(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        if (restrictedKeys.isPresent()) {
            TypedQuery<Long> countQuery = this.getCountQuery(queryEnvironment, queryEnvironment.getField(), restrictedKeys.get());
            if (logger.isDebugEnabled()) {
                logger.info("\nGraphQL JPQL Count Query String:\n    {}", (Object)this.getJPQLQueryString(countQuery));
            }
            return (Long)countQuery.getSingleResult();
        }
        return 0L;
    }

    public Long queryAggregateCount(String aggregate, DataFetchingEnvironment environment, Optional<List<Object>> restrictedKeys) {
        MergedField queryField = this.flattenEmbeddedIdArguments(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        if (restrictedKeys.isPresent()) {
            TypedQuery<Long> countQuery = this.getAggregateCountQuery(queryEnvironment, queryEnvironment.getField(), aggregate, restrictedKeys.get(), new String[0]);
            if (logger.isDebugEnabled()) {
                logger.info("\nGraphQL JPQL Count Query String:\n    {}", (Object)this.getJPQLQueryString(countQuery));
            }
            return (Long)countQuery.getSingleResult();
        }
        return 0L;
    }

    public List<Map> queryAggregateGroupByCount(String alias, Optional<String> countOf, DataFetchingEnvironment environment, Optional<List<Object>> restrictedKeys, Map.Entry<String, String> ... groupings) {
        MergedField queryField = this.flattenEmbeddedIdArguments(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        if (restrictedKeys.isPresent()) {
            TypedQuery<Map> countQuery = this.getAggregateGroupByCountQuery(queryEnvironment, queryEnvironment.getField(), alias, countOf, restrictedKeys.get(), groupings);
            if (logger.isDebugEnabled()) {
                logger.info("\nGraphQL JPQL Count Query String:\n    {}", (Object)this.getJPQLQueryString(countQuery));
            }
            return countQuery.getResultList();
        }
        return Collections.emptyList();
    }

    public List<Map> queryAggregateGroupByAssociationCount(String countAlias, String association, DataFetchingEnvironment environment, Optional<List<Object>> restrictedKeys, Map.Entry<String, String> ... groupings) {
        MergedField queryField = this.flattenEmbeddedIdArguments(environment.getField());
        DataFetchingEnvironment queryEnvironment = this.getQueryEnvironment(environment, queryField);
        if (restrictedKeys.isPresent()) {
            TypedQuery<Map> countQuery = this.getAggregateGroupByAssociationCountQuery(queryEnvironment, queryEnvironment.getField(), countAlias, association, restrictedKeys.get(), groupings);
            if (logger.isDebugEnabled()) {
                logger.info("\nGraphQL JPQL Count Query String:\n    {}", (Object)this.getJPQLQueryString(countQuery));
            }
            return countQuery.getResultList();
        }
        return Collections.emptyList();
    }

    protected <T> TypedQuery<T> getQuery(DataFetchingEnvironment environment, graphql.language.Field field, boolean isDistinct, Object ... keys) {
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).localContext((Object)Boolean.TRUE).build();
        CriteriaQuery<T> criteriaQuery = this.getCriteriaQuery(queryEnvironment, field, isDistinct, keys);
        return this.entityManager.createQuery(criteriaQuery);
    }

    protected TypedQuery<Long> getCountQuery(DataFetchingEnvironment environment, graphql.language.Field field, List<Object> keys) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(this.entityType);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.FALSE).build();
        root.alias("root");
        query.select((Selection)cb.count((Expression)root));
        List<Predicate> predicates = field.getArguments().stream().map(it -> this.getPredicate(field, cb, (Root<?>)root, null, queryEnvironment, (Argument)it)).filter(it -> it != null).collect(Collectors.toList());
        if (!keys.isEmpty() && this.hasIdAttribute()) {
            Predicate restrictions = root.get(this.idAttributeName()).in(keys);
            predicates.add(restrictions);
        }
        query.where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(query);
    }

    protected TypedQuery<Long> getAggregateCountQuery(DataFetchingEnvironment environment, graphql.language.Field field, String aggregate, List<Object> keys, String ... groupings) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root root = query.from(this.entityType);
        Join join = root.join(aggregate);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.FALSE).build();
        query.select((Selection)cb.count((Expression)join));
        List<Predicate> predicates = field.getArguments().stream().map(it -> this.getPredicate(field, cb, (Root<?>)root, null, queryEnvironment, (Argument)it)).filter(it -> it != null).collect(Collectors.toList());
        if (!keys.isEmpty() && this.hasIdAttribute()) {
            Predicate restrictions = root.get(this.idAttributeName()).in(keys);
            predicates.add(restrictions);
        }
        query.where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(query);
    }

    protected TypedQuery<Map> getAggregateGroupByCountQuery(DataFetchingEnvironment environment, graphql.language.Field field, String alias, Optional<String> countOfJoin, List<Object> keys, Map.Entry<String, String> ... groupBy) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Map.class);
        Root root = query.from(this.entityType);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.FALSE).build();
        ArrayList selections = new ArrayList();
        Stream.of(groupBy).map(group -> root.get((String)group.getValue()).alias((String)group.getKey())).forEach(selections::add);
        Expression[] groupings = (Expression[])Stream.of(groupBy).map(group -> root.get((String)group.getValue())).toArray(Expression[]::new);
        countOfJoin.ifPresentOrElse(it -> selections.add(cb.count((Expression)root.join(it)).alias(alias)), () -> selections.add(cb.count((Expression)root).alias(alias)));
        query.multiselect(selections).groupBy(groupings);
        List<Predicate> predicates = field.getArguments().stream().map(it -> this.getPredicate(field, cb, (Root<?>)root, null, queryEnvironment, (Argument)it)).filter(it -> it != null).collect(Collectors.toList());
        if (!keys.isEmpty() && this.hasIdAttribute()) {
            Predicate restrictions = root.get(this.idAttributeName()).in(keys);
            predicates.add(restrictions);
        }
        query.where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(query);
    }

    protected TypedQuery<Map> getAggregateGroupByAssociationCountQuery(DataFetchingEnvironment environment, graphql.language.Field field, String countAlias, String association, List<Object> keys, Map.Entry<String, String> ... groupBy) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Map.class);
        Root root = query.from(this.entityType);
        Join join = root.join(association);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.FALSE).build();
        ArrayList<Selection> selections = new ArrayList<Selection>();
        Stream.of(groupBy).map(group -> join.get((String)group.getValue()).alias((String)group.getKey())).forEach(selections::add);
        selections.add(cb.count((Expression)join).alias(countAlias));
        Expression[] groupings = (Expression[])Stream.of(groupBy).map(group -> join.get((String)group.getValue())).toArray(Expression[]::new);
        query.multiselect(selections).groupBy(groupings);
        List<Predicate> predicates = field.getArguments().stream().map(it -> this.getPredicate(field, cb, (Root<?>)root, null, queryEnvironment, (Argument)it)).filter(it -> it != null).collect(Collectors.toList());
        if (!keys.isEmpty() && this.hasIdAttribute()) {
            Predicate restrictions = root.get(this.idAttributeName()).in(keys);
            predicates.add(restrictions);
        }
        query.where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(query);
    }

    protected TypedQuery<Object> getKeysQuery(DataFetchingEnvironment environment, graphql.language.Field field, List<Object> keys) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Object.class);
        Root from = query.from(this.entityType);
        from.alias("root");
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.FALSE).build();
        if (this.hasIdAttribute()) {
            query.select((Selection)from.get(this.idAttributeName()));
        } else if (this.hasIdClassAttribue()) {
            List selection2 = Stream.of(this.idClassAttributeNames()).map(arg_0 -> ((Root)from).get(arg_0)).collect(Collectors.toList());
            query.multiselect(selection2);
        }
        List<Predicate> predicates = field.getArguments().stream().map(it -> this.getPredicate(field, cb, (Root<?>)from, null, queryEnvironment, (Argument)it)).filter(it -> it != null).collect(Collectors.toList());
        if (!keys.isEmpty() && this.hasIdAttribute()) {
            Predicate restrictions = from.get(this.idAttributeName()).in(keys);
            predicates.add(restrictions);
        }
        query.where(predicates.toArray(new Predicate[0]));
        GraphQLSupport.fields(field.getSelectionSet()).filter(it -> this.isPersistent(environment, it.getName())).forEach(selection -> {
            Path selectionPath = from.get(selection.getName());
            this.mayBeAddOrderBy((graphql.language.Field)selection, (CriteriaQuery<?>)query, cb, (Path<?>)selectionPath, queryEnvironment);
        });
        this.mayBeAddDefaultOrderBy((CriteriaQuery<?>)query, (From<?, ?>)from, cb);
        return this.entityManager.createQuery(query);
    }

    protected Map<Object, List<Object>> loadOneToMany(DataFetchingEnvironment environment, Set<Object> keys) {
        graphql.language.Field field = environment.getField();
        TypedQuery<Object[]> query = this.getBatchQuery(environment, field, this.isDefaultDistinct(), keys);
        EntityGraph<?> entityGraph = this.createEntityGraph(environment);
        List<Object[]> resultList = this.getResultList(query, entityGraph);
        if (logger.isTraceEnabled()) {
            logger.trace("loadOneToMany in session {} for field {} with keys {} on {}", new Object[]{this.entityManager, environment.getField().getName(), keys, Thread.currentThread()});
        }
        Map<Object, List<Object>> batch = resultList.stream().collect(Collectors.groupingBy(t -> t[0], Collectors.mapping(t -> this.unproxyAndThenDetach(t[1]), GraphQLSupport.toResultList())));
        LinkedHashMap<Object, List<Object>> resultMap = new LinkedHashMap<Object, List<Object>>(keys.size());
        keys.forEach(it -> {
            List list = batch.getOrDefault(it, Collections.emptyList());
            resultMap.put(it, list);
        });
        return resultMap;
    }

    protected Map<Object, Object> loadManyToOne(DataFetchingEnvironment environment, Set<Object> keys) {
        graphql.language.Field field = environment.getField();
        TypedQuery<Object[]> query = this.getBatchQuery(environment, field, this.isDefaultDistinct(), keys);
        EntityGraph<?> entityGraph = this.createEntityGraph(environment);
        List<Object[]> resultList = this.getResultList(query, entityGraph);
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>(resultList.size());
        resultList.forEach(item -> resultMap.put(item[0], this.unproxyAndThenDetach(item[1])));
        return resultMap;
    }

    protected <T> List<T> getResultList(TypedQuery<T> query, EntityGraph<?> entityGraph) {
        if (logger.isDebugEnabled()) {
            logger.info("\nGraphQL JPQL Batch Query String:\n    {}", (Object)this.getJPQLQueryString(query));
        }
        query.setHint(ORG_HIBERNATE_READ_ONLY, (Object)true);
        query.setHint(ORG_HIBERNATE_FETCH_SIZE, (Object)this.defaultFetchSize);
        query.setHint(ORG_HIBERNATE_CACHEABLE, (Object)false);
        if (entityGraph != null) {
            query.setHint(JAKARTA_PERSISTENCE_FETCHGRAPH, entityGraph);
        }
        return query.getResultList();
    }

    protected TypedQuery<Object[]> getBatchQuery(DataFetchingEnvironment environment, graphql.language.Field field, boolean isDistinct, Set<Object> keys) {
        SingularAttribute parentIdAttribute = this.entityType.getId(Object.class);
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root from = query.from(this.entityType);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.TRUE).build();
        from.alias("owner");
        Join join = from.join(field.getName()).on((Expression)from.get(parentIdAttribute.getName()).in(keys));
        query.multiselect(new Selection[]{from.get(parentIdAttribute.getName()), join.alias(field.getName())});
        List<Predicate> predicates = this.getFieldPredicates(field, (CriteriaQuery<?>)query, cb, (Root<?>)from, (From<?, ?>)join, queryEnvironment);
        query.where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(query.distinct(isDistinct));
    }

    protected TypedQuery<Object> getBatchCollectionQuery(DataFetchingEnvironment environment, graphql.language.Field field, boolean isDistinct, Set<Object> keys) {
        SingularAttribute parentIdAttribute = this.entityType.getId(Object.class);
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery();
        Root from = query.from(this.entityType);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).localContext((Object)Boolean.TRUE).build();
        from.alias("owner");
        Join join = from.join(field.getName()).on((Expression)from.get(parentIdAttribute.getName()).in(keys));
        query.select(join.alias(field.getName()));
        List<Predicate> predicates = this.getFieldPredicates(field, (CriteriaQuery<?>)query, cb, (Root<?>)from, (From<?, ?>)join, queryEnvironment);
        query.where(predicates.toArray(new Predicate[0]));
        this.mayBeAddDefaultOrderBy((CriteriaQuery<?>)query, (From<?, ?>)join, cb);
        return this.entityManager.createQuery(query.distinct(isDistinct));
    }

    protected <T> CriteriaQuery<T> getCriteriaQuery(DataFetchingEnvironment environment, graphql.language.Field field, boolean isDistinct, Object ... keys) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(this.entityType.getJavaType());
        Root from = query.from(this.entityType);
        DataFetchingEnvironment queryEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)query).build();
        from.alias(from.getModel().getName().toLowerCase());
        List<Predicate> predicates = this.getFieldPredicates(field, (CriteriaQuery<?>)query, cb, (Root<?>)from, (From<?, ?>)from, queryEnvironment);
        if (keys.length > 0) {
            if (this.hasIdAttribute()) {
                predicates.add(from.get(this.idAttributeName()).in(keys));
            } else if (this.hasIdClassAttribue()) {
                String[] names = this.idClassAttributeNames();
                HashMap idKeys = new HashMap();
                IntStream.range(0, keys.length).mapToObj(i -> (Object[])keys[i]).forEach(values -> IntStream.range(0, ((Object[])values).length).forEach(i -> idKeys.computeIfAbsent(names[i], key -> new ArrayList()).add(values[i])));
                List<Predicate> idPredicates = Stream.of(names).map(name -> from.get(name).in(((List)idKeys.get(name)).toArray(new Object[0]))).collect(Collectors.toList());
                predicates.add(cb.and(idPredicates.toArray(new Predicate[0])));
            }
        }
        if (!predicates.isEmpty()) {
            query.where(predicates.toArray(new Predicate[0]));
        }
        this.mayBeAddDefaultOrderBy((CriteriaQuery<?>)query, (From<?, ?>)from, cb);
        return query.distinct(isDistinct);
    }

    protected void mayBeAddOrderBy(graphql.language.Field selectedField, CriteriaQuery<?> query, CriteriaBuilder cb, Path<?> fieldPath, DataFetchingEnvironment environment) {
        Attribute<?, ?> attribute = this.getAttribute(environment, selectedField.getName());
        if (attribute instanceof SingularAttribute) {
            selectedField.getArguments().stream().filter(this::isOrderByArgument).findFirst().map(argument -> this.getOrderByValue((Argument)argument, environment)).ifPresent(orderBy -> {
                ArrayList<Order> orders = new ArrayList<Order>(query.getOrderList());
                if (DESC.equals(orderBy.getName())) {
                    orders.add(cb.desc((Expression)fieldPath));
                } else {
                    orders.add(cb.asc((Expression)fieldPath));
                }
                query.orderBy(orders);
            });
        }
    }

    protected List<Predicate> getFieldPredicates(graphql.language.Field field, CriteriaQuery<?> query, CriteriaBuilder cb, Root<?> root, From<?, ?> from, DataFetchingEnvironment environment) {
        ArrayList arguments = new ArrayList();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        GraphQLSupport.fields(field.getSelectionSet()).filter(selection -> this.isPersistent(environment, selection.getName())).forEach(selection -> {
            Path fieldPath = from.get(selection.getName());
            From<?, ?> fetch = null;
            Optional<Argument> whereArgument = this.getArgument((graphql.language.Field)selection, WHERE);
            Attribute<?, ?> fieldAttribute = this.getAttribute(environment, selection.getName());
            if (fieldAttribute instanceof SingularAttribute) {
                this.mayBeAddOrderBy((graphql.language.Field)selection, query, cb, (Path<?>)fieldPath, environment);
                SingularAttribute attribute = (SingularAttribute)fieldAttribute;
                if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                    Boolean isOptional = this.getOptionalArgumentValue(environment, (graphql.language.Field)selection, (Attribute<?, ?>)attribute);
                    if (!isOptional.booleanValue() || !whereArgument.isPresent()) {
                        fetch = this.reuseFetch(from, selection.getName(), isOptional);
                    }
                } else if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
                    arguments.addAll(selection.getArguments().stream().filter(this::isPredicateArgument).map(it -> new Argument(selection.getName() + "." + it.getName(), it.getValue())).collect(Collectors.toList()));
                }
            } else {
                GraphQLObjectType objectType = this.getObjectType(environment);
                EntityType<?> entityType = this.getEntityType(objectType);
                PluralAttribute attribute = (PluralAttribute)entityType.getAttribute(selection.getName());
                Boolean isOptional = this.getOptionalArgumentValue(environment, (graphql.language.Field)selection, (Attribute<?, ?>)attribute);
                if (Attribute.PersistentAttributeType.ELEMENT_COLLECTION == attribute.getPersistentAttributeType()) {
                    from.fetch(selection.getName(), JoinType.LEFT);
                } else if (!whereArgument.isPresent() && !this.hasAnySelectionOrderBy((graphql.language.Field)selection)) {
                    fetch = this.reuseFetch(from, selection.getName(), isOptional);
                }
            }
            if (selection.getSelectionSet() != null && fetch != null) {
                Map variables = environment.getVariables();
                GraphQLFieldDefinition fieldDefinition = this.getFieldDefinition(environment.getGraphQLSchema(), this.getObjectType(environment), (graphql.language.Field)selection);
                List values = whereArgument.map(Collections::singletonList).orElse(Collections.emptyList());
                Map fieldArguments = ValuesResolver.getArgumentValues((List)fieldDefinition.getArguments(), values, (CoercedVariables)new CoercedVariables(variables), (GraphQLContext)environment.getGraphQlContext(), (Locale)Locale.ROOT);
                DataFetchingEnvironment fieldEnvironment = this.wherePredicateEnvironment(environment, fieldDefinition, fieldArguments);
                predicates.addAll(this.getFieldPredicates((graphql.language.Field)selection, query, cb, root, fetch, fieldEnvironment));
            }
        });
        arguments.addAll(field.getArguments());
        arguments.stream().filter(this::isPredicateArgument).map(it -> this.getPredicate(field, cb, root, from, environment, (Argument)it)).filter(it -> it != null).forEach(predicates::add);
        return predicates;
    }

    protected Boolean getOptionalArgumentValue(DataFetchingEnvironment environment, graphql.language.Field selection, Attribute<?, ?> attribute) {
        return this.getArgument(selection, OPTIONAL).map(it -> this.getArgumentValue(environment, (Argument)it, (Class)Boolean.class)).orElseGet(() -> this.isOptionalAttribute(attribute));
    }

    protected void mayBeAddDefaultOrderBy(CriteriaQuery<?> query, From<?, ?> from, CriteriaBuilder cb) {
        if (query.getOrderList() == null || query.getOrderList().isEmpty()) {
            Optional<EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor> attributePropertyDescriptor = EntityIntrospector.introspect(this.entityType).getPersistentPropertyDescriptors().stream().filter(EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor::hasDefaultOrderBy).findFirst();
            if (!attributePropertyDescriptor.isPresent()) {
                if (this.hasIdAttribute()) {
                    query.orderBy(new Order[]{cb.asc((Expression)from.get(this.idAttributeName()))});
                } else if (this.hasIdClassAttribue()) {
                    List orders = Stream.of(this.idClassAttributeNames()).map(name -> cb.asc((Expression)from.get(name))).collect(Collectors.toList());
                    query.orderBy(orders);
                }
            } else {
                EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor attribute = attributePropertyDescriptor.get();
                GraphQLDefaultOrderBy order = attribute.getDefaultOrderBy().get();
                if (order.asc()) {
                    query.orderBy(new Order[]{cb.asc((Expression)from.get(attribute.getName()))});
                } else {
                    query.orderBy(new Order[]{cb.desc((Expression)from.get(attribute.getName()))});
                }
            }
        }
    }

    protected boolean isPredicateArgument(Argument argument) {
        return !this.isOrderByArgument(argument) && !this.isOptionalArgument(argument);
    }

    protected boolean isOrderByArgument(Argument argument) {
        return "orderBy".equals(argument.getName());
    }

    protected boolean isOptionalArgument(Argument argument) {
        return OPTIONAL.equals(argument.getName());
    }

    protected Optional<Argument> getArgument(graphql.language.Field selectedField, String argumentName) {
        return selectedField.getArguments().stream().filter(it -> it.getName().equals(argumentName)).findFirst();
    }

    protected <R extends Attribute<?, ?>> R getAttribute(String attributeName) {
        return (R)this.entityType.getAttribute(attributeName);
    }

    protected Predicate getPredicate(graphql.language.Field field, CriteriaBuilder cb, Root<?> from, From<?, ?> path, DataFetchingEnvironment environment, Argument argument) {
        if (GraphQLSupport.isLogicalArgument(argument).booleanValue() || GraphQLSupport.isDistinctArgument(argument).booleanValue() || GraphQLSupport.isPageArgument(argument).booleanValue() || GraphQLSupport.isAfterArgument(argument).booleanValue() || GraphQLSupport.isFirstArgument(argument).booleanValue()) {
            return null;
        }
        if (GraphQLSupport.isWhereArgument(argument).booleanValue()) {
            return this.getWherePredicate(cb, from, path, this.argumentEnvironment(environment, argument), argument);
        }
        if (!argument.getName().contains(".")) {
            Attribute<?, ?> argumentEntityAttribute = this.getAttribute(environment, argument.getName());
            if (argumentEntityAttribute instanceof PluralAttribute) {
                Boolean isFetch = (Boolean)environment.getLocalContext();
                return (isFetch != false ? this.reuseFetch((From<?, ?>)from, argument.getName(), false) : this.reuseJoin((From<?, ?>)from, argument.getName(), false)).in(new Object[]{this.convertValue(environment, argument, argument.getValue())});
            }
            return cb.equal((Expression)path.get(argument.getName()), this.convertValue(environment, argument, argument.getValue()));
        }
        if (!argument.getName().endsWith(".where")) {
            Path<?> argumentPath = this.getCompoundJoinedPath(path, argument.getName(), false);
            return cb.equal(argumentPath, this.convertValue(environment, argument, argument.getValue()));
        }
        String fieldName = argument.getName().split("\\.")[0];
        From<?, ?> join = this.getCompoundJoin(path, argument.getName(), true);
        Argument where = new Argument(WHERE, argument.getValue());
        Map variables = environment.getVariables();
        GraphQLFieldDefinition fieldDef = this.getFieldDefinition(environment.getGraphQLSchema(), this.getObjectType(environment), new graphql.language.Field(fieldName));
        Map arguments = (Map)ValuesResolver.getArgumentValues((List)fieldDef.getArguments(), Collections.singletonList(where), (CoercedVariables)new CoercedVariables(variables), (GraphQLContext)environment.getGraphQlContext(), (Locale)Locale.ROOT).get(WHERE);
        return this.getWherePredicate(cb, from, join, this.wherePredicateEnvironment(environment, fieldDef, arguments), where);
    }

    private <R extends Value<?>> R getValue(Argument argument, DataFetchingEnvironment environment) {
        Value value = argument.getValue();
        if (VariableReference.class.isInstance(value)) {
            Object variableValue = this.getVariableReferenceValue((VariableReference)value, environment);
            GraphQLArgument graphQLArgument = environment.getExecutionStepInfo().getFieldDefinition().getArgument(argument.getName());
            return (R)AstValueHelper.astFromValue(variableValue, (GraphQLType)graphQLArgument.getType());
        }
        return (R)value;
    }

    private EnumValue getOrderByValue(Argument argument, DataFetchingEnvironment environment) {
        Value value = argument.getValue();
        if (VariableReference.class.isInstance(value)) {
            Object variableValue = this.getVariableReferenceValue((VariableReference)value, environment);
            return EnumValue.newEnumValue((String)variableValue.toString()).build();
        }
        return (EnumValue)value;
    }

    private Object getVariableReferenceValue(VariableReference variableReference, DataFetchingEnvironment env) {
        return env.getVariables().get(variableReference.getName());
    }

    protected Predicate getWherePredicate(CriteriaBuilder cb, Root<?> root, From<?, ?> path, DataFetchingEnvironment environment, Argument argument) {
        ObjectValue whereValue = (ObjectValue)this.getValue(argument, environment);
        if (whereValue.getChildren().isEmpty()) {
            return cb.conjunction();
        }
        Logical logical = this.extractLogical(argument);
        LinkedHashMap<String, Map> predicateArguments = new LinkedHashMap<String, Map>();
        predicateArguments.put(logical.name(), environment.getArguments());
        DataFetchingEnvironment predicateDataFetchingEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(predicateArguments).build();
        Argument predicateArgument = new Argument(logical.name(), (Value)whereValue);
        return this.getArgumentPredicate(cb, (From<?, ?>)(path != null ? path : root), predicateDataFetchingEnvironment, predicateArgument);
    }

    protected Predicate getArgumentPredicate(CriteriaBuilder cb, From<?, ?> from, DataFetchingEnvironment environment, Argument argument) {
        ObjectValue whereValue = (ObjectValue)this.getValue(argument, environment);
        if (whereValue.getChildren().isEmpty()) {
            return cb.disjunction();
        }
        Logical logical = this.extractLogical(argument);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        whereValue.getObjectFields().stream().filter(it -> Logical.names().contains(it.getName())).map(it -> {
            Map<String, Object> arguments = this.getFieldArguments(environment, (ObjectField)it, argument);
            if (it.getValue() instanceof ArrayValue) {
                return this.getArgumentsPredicate(cb, from, this.argumentEnvironment(environment, arguments), new Argument(it.getName(), it.getValue()));
            }
            return this.getArgumentPredicate(cb, from, this.argumentEnvironment(environment, arguments), new Argument(it.getName(), it.getValue()));
        }).forEach(predicates::add);
        whereValue.getObjectFields().stream().filter(it -> !Logical.names().contains(it.getName())).map(it -> {
            Map<String, Object> args = this.getFieldArguments(environment, (ObjectField)it, argument);
            Argument arg = new Argument(it.getName(), it.getValue());
            return this.getObjectFieldPredicate(environment, cb, from, logical, (ObjectField)it, arg, args);
        }).filter(predicate -> predicate != null).forEach(predicates::add);
        return this.getCompoundPredicate(cb, predicates, logical);
    }

    protected Predicate getObjectFieldPredicate(DataFetchingEnvironment environment, CriteriaBuilder cb, From<?, ?> from, Logical logical, ObjectField objectField, Argument argument, Map<String, Object> arguments) {
        Attribute<?, ?> attribute;
        if (this.isEntityType(environment) && (attribute = this.getAttribute(environment, argument.getName())).isAssociation()) {
            boolean isMultipleLogical;
            GraphQLFieldDefinition fieldDefinition = this.getFieldDefinition(environment.getGraphQLSchema(), this.getObjectType(environment), new graphql.language.Field(objectField.getName()));
            List logicalArguments = Optional.ofNullable(environment.getArgument(logical.name())).filter(List.class::isInstance).map(List.class::cast).orElseGet(List::of);
            boolean bl = isMultipleLogical = logicalArguments.stream().filter(it -> it.containsKey(objectField.getName())).count() >= 1L;
            if (Arrays.asList(Logical.EXISTS, Logical.NOT_EXISTS).contains((Object)logical) || isMultipleLogical) {
                AbstractQuery query = (AbstractQuery)environment.getRoot();
                Subquery subquery = query.subquery(attribute.getJavaType());
                Root correlation = Root.class.isInstance(from) ? subquery.correlate((Root)from) : subquery.correlate((Join)from);
                Join correlationJoin = correlation.join(objectField.getName());
                DataFetchingEnvironment existsEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).root((Object)subquery).build();
                Predicate restriction = this.getArgumentPredicate(cb, (From<?, ?>)correlationJoin, this.wherePredicateEnvironment(existsEnvironment, fieldDefinition, arguments), argument);
                Predicate exists = cb.exists(subquery.select((Expression)correlationJoin).where((Expression)restriction));
                return logical == Logical.NOT_EXISTS ? cb.not((Expression)exists) : exists;
            }
            AbstractQuery query = (AbstractQuery)environment.getRoot();
            Boolean isFetch = (Boolean)environment.getLocalContext();
            boolean isOptional = this.isOptionalAttribute(attribute);
            From<?, ?> context = this.isSubquery(query) || this.isCountQuery(query) || isFetch == false ? this.reuseJoin(from, objectField.getName(), isOptional) : this.reuseFetch(from, objectField.getName(), isOptional);
            return this.getArgumentPredicate(cb, context, this.wherePredicateEnvironment(environment, fieldDefinition, arguments), argument);
        }
        return this.getLogicalPredicate(objectField.getName(), cb, from, objectField, this.argumentEnvironment(environment, arguments), argument);
    }

    protected boolean isSubquery(AbstractQuery<?> query) {
        return Subquery.class.isInstance(query);
    }

    protected boolean isCountQuery(AbstractQuery<?> query) {
        return Optional.ofNullable(query.getSelection()).map(TupleElement::getJavaType).map(Long.class::equals).orElse(false);
    }

    protected Predicate getArgumentsPredicate(CriteriaBuilder cb, From<?, ?> from, DataFetchingEnvironment environment, Argument argument) {
        ArrayValue whereValue = (ArrayValue)this.getValue(argument, environment);
        if (whereValue.getValues().isEmpty()) {
            return cb.disjunction();
        }
        Logical logical = this.extractLogical(argument);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        List arguments = (List)environment.getArgument(logical.name());
        List values = whereValue.getValues().stream().map(ObjectValue.class::cast).collect(Collectors.toList());
        List tuples = IntStream.range(0, values.size()).mapToObj(i -> new AbstractMap.SimpleEntry<ObjectValue, Map>((ObjectValue)values.get(i), (Map)arguments.get(i))).collect(Collectors.toList());
        tuples.stream().flatMap(e -> ((ObjectValue)e.getKey()).getObjectFields().stream().filter(it -> Logical.names().contains(it.getName())).map(it -> {
            Map args = (Map)e.getValue();
            Argument arg = new Argument(it.getName(), it.getValue());
            if (ArrayValue.class.isInstance(it.getValue())) {
                return this.getArgumentsPredicate(cb, from, this.argumentEnvironment(environment, args), arg);
            }
            return this.getArgumentPredicate(cb, from, this.argumentEnvironment(environment, args), arg);
        })).forEach(predicates::add);
        tuples.stream().flatMap(e -> ((ObjectValue)e.getKey()).getObjectFields().stream().filter(it -> !Logical.names().contains(it.getName())).map(it -> {
            Map args = (Map)e.getValue();
            Argument arg = new Argument(it.getName(), it.getValue());
            return this.getObjectFieldPredicate(environment, cb, from, logical, (ObjectField)it, arg, args);
        })).filter(predicate -> predicate != null).forEach(predicates::add);
        return this.getCompoundPredicate(cb, predicates, logical);
    }

    private Map<String, Object> getFieldArguments(DataFetchingEnvironment environment, ObjectField field, Argument argument) {
        Map arguments;
        if (environment.getArgument(argument.getName()) instanceof Collection) {
            Collection list = (Collection)environment.getArgument(argument.getName());
            arguments = list.stream().filter(args -> args.get(field.getName()) != null).findFirst().orElse((Map)list.stream().findFirst().get());
        } else {
            arguments = (Map)environment.getArgument(argument.getName());
        }
        return arguments;
    }

    private Logical extractLogical(Argument argument) {
        return Optional.of(argument.getName()).filter(it -> Logical.names().contains(it)).map(it -> Logical.valueOf(it)).orElse(Logical.AND);
    }

    private Predicate getLogicalPredicates(String fieldName, CriteriaBuilder cb, From<?, ?> path, ObjectField objectField, DataFetchingEnvironment environment, Argument argument) {
        ArrayValue value = (ArrayValue)ArrayValue.class.cast(objectField.getValue());
        Logical logical = this.extractLogical(argument);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        value.getValues().stream().map(ObjectValue.class::cast).flatMap(it -> it.getObjectFields().stream()).map(it -> {
            Map<String, Object> args = this.getFieldArguments(environment, (ObjectField)it, argument);
            Argument arg = new Argument(it.getName(), it.getValue());
            return this.getLogicalPredicate(it.getName(), cb, path, (ObjectField)it, this.argumentEnvironment(environment, args), arg);
        }).forEach(predicates::add);
        return this.getCompoundPredicate(cb, predicates, logical);
    }

    private Predicate getLogicalPredicate(String fieldName, CriteriaBuilder cb, From<?, ?> path, ObjectField objectField, DataFetchingEnvironment environment, Argument argument) {
        ObjectValue expressionValue = objectField.getValue() instanceof ObjectValue ? (ObjectValue)objectField.getValue() : new ObjectValue(Arrays.asList(objectField));
        if (expressionValue.getChildren().isEmpty()) {
            return cb.disjunction();
        }
        Logical logical = this.extractLogical(argument);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        expressionValue.getObjectFields().stream().filter(it -> Logical.names().contains(it.getName())).map(it -> {
            Map<String, Object> args = this.getFieldArguments(environment, (ObjectField)it, argument);
            Argument arg = new Argument(it.getName(), it.getValue());
            if (it.getValue() instanceof ArrayValue) {
                return this.getLogicalPredicates(fieldName, cb, path, (ObjectField)it, this.argumentEnvironment(environment, args), arg);
            }
            return this.getLogicalPredicate(fieldName, cb, path, (ObjectField)it, this.argumentEnvironment(environment, args), arg);
        }).forEach(predicates::add);
        if (expressionValue.getObjectFields().stream().anyMatch(it -> !Logical.names().contains(it.getName()) && !PredicateFilter.Criteria.names().contains(it.getName()))) {
            GraphQLFieldDefinition fieldDefinition = this.getFieldDefinition(environment.getGraphQLSchema(), this.getObjectType(environment), new graphql.language.Field(fieldName));
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
            Argument arg = new Argument(logical.name(), (Value)expressionValue);
            boolean isOptional = false;
            if (Logical.names().contains(argument.getName())) {
                args.put(logical.name(), environment.getArgument(argument.getName()));
            } else {
                args.put(logical.name(), environment.getArgument(fieldName));
                isOptional = this.isOptionalAttribute(this.getAttribute(environment, argument.getName()));
            }
            return this.getArgumentPredicate(cb, this.reuseJoin(path, fieldName, isOptional), this.wherePredicateEnvironment(environment, fieldDefinition, args), arg);
        }
        JpaPredicateBuilder pb = new JpaPredicateBuilder(cb);
        expressionValue.getObjectFields().stream().filter(it -> PredicateFilter.Criteria.names().contains(it.getName())).map(it -> this.getPredicateFilter(new ObjectField(fieldName, it.getValue()), this.argumentEnvironment(environment, argument), new Argument(it.getName(), it.getValue()))).sorted().map(it -> pb.getPredicate(path, (Path<?>)path.get(it.getField()), (PredicateFilter)it)).filter(predicate -> predicate != null).forEach(predicates::add);
        return this.getCompoundPredicate(cb, predicates, logical);
    }

    private Predicate getCompoundPredicate(CriteriaBuilder cb, List<Predicate> predicates, Logical logical) {
        if (predicates.isEmpty()) {
            return cb.disjunction();
        }
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        return logical == Logical.OR ? cb.or(predicates.toArray(new Predicate[0])) : cb.and(predicates.toArray(new Predicate[0]));
    }

    private PredicateFilter getPredicateFilter(ObjectField objectField, DataFetchingEnvironment environment, Argument argument) {
        EnumSet<PredicateFilter.Criteria> options = EnumSet.of(PredicateFilter.Criteria.valueOf(argument.getName()));
        LinkedHashMap<String, Object> valueArguments = new LinkedHashMap<String, Object>();
        valueArguments.put(objectField.getName(), environment.getArgument(argument.getName()));
        DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(valueArguments).build();
        Argument dataFetchingArgument = new Argument(objectField.getName(), argument.getValue());
        Object filterValue = this.convertValue(dataFetchingEnvironment, dataFetchingArgument, argument.getValue());
        Attribute<?, ?> attribute = this.getAttribute(environment, objectField.getName());
        return new PredicateFilter(objectField.getName(), filterValue, options, attribute);
    }

    protected DataFetchingEnvironment argumentEnvironment(DataFetchingEnvironment environment, Map<String, Object> arguments) {
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).build();
    }

    protected DataFetchingEnvironment argumentEnvironment(DataFetchingEnvironment environment, Argument argument) {
        Map arguments = (Map)environment.getArgument(argument.getName());
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).build();
    }

    protected DataFetchingEnvironment wherePredicateEnvironment(DataFetchingEnvironment environment, GraphQLFieldDefinition fieldDefinition, Map<String, Object> arguments) {
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(environment).arguments(arguments).fieldDefinition(fieldDefinition).fieldType(fieldDefinition.getType()).build();
    }

    private From<?, ?> getCompoundJoin(From<?, ?> rootPath, String fieldName, boolean outer) {
        String[] compoundField = fieldName.split("\\.");
        if (compoundField.length == 1) {
            return rootPath;
        }
        From<?, ?> join = this.reuseJoin(rootPath, compoundField[0], outer);
        for (int i = 1; i < compoundField.length; ++i) {
            if (i >= compoundField.length - 1) {
                return join;
            }
            join = this.reuseJoin(join, compoundField[i], outer);
        }
        return null;
    }

    private Path<?> getCompoundJoinedPath(From<?, ?> rootPath, String fieldName, boolean outer) {
        String[] compoundField = fieldName.split("\\.");
        if (compoundField.length == 1) {
            return rootPath.get(compoundField[0]);
        }
        From<?, ?> join = this.reuseJoin(rootPath, compoundField[0], outer);
        for (int i = 1; i < compoundField.length; ++i) {
            if (i >= compoundField.length - 1) {
                return join.get(compoundField[i]);
            }
            join = this.reuseJoin(join, compoundField[i], outer);
        }
        return null;
    }

    private From<?, ?> reuseJoin(From<?, ?> from, String fieldName, boolean outer) {
        for (Join join : from.getJoins()) {
            if (!join.getAttribute().getName().equals(fieldName)) continue;
            return join;
        }
        return outer ? from.join(fieldName, JoinType.LEFT) : from.join(fieldName);
    }

    private From<?, ?> reuseFetch(From<?, ?> from, String fieldName, boolean outer) {
        for (Fetch fetch : from.getFetches()) {
            if (!fetch.getAttribute().getName().equals(fieldName)) continue;
            return (From)fetch;
        }
        return outer ? (From)from.fetch(fieldName, JoinType.LEFT) : (From)from.fetch(fieldName);
    }

    protected Object convertValue(DataFetchingEnvironment environment, Argument argument, Value value) {
        if (value instanceof NullValue) {
            return value;
        }
        if (value instanceof StringValue) {
            Object convertedValue = environment.getArgument(argument.getName());
            if (convertedValue != null) {
                Class<?> javaType = this.getJavaType(environment, argument);
                return javaType.isInstance(convertedValue) ? convertedValue : JavaScalars.of(javaType).getCoercing().parseValue(convertedValue);
            }
            return ((StringValue)value).getValue();
        }
        if (value instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)value;
            Class<?> javaType = this.getJavaType(environment, argument);
            Object argumentValue = environment.getVariables().get(variableReference.getName());
            if (javaType.isEnum()) {
                if (argumentValue instanceof Collection) {
                    Collection argumentValues = (Collection)argumentValue;
                    ArrayList values = new ArrayList();
                    argumentValues.forEach(it -> values.add(Enum.valueOf(javaType, it.toString())));
                    return values;
                }
                return Enum.valueOf(javaType, argumentValue.toString());
            }
            Coercing coercing = JavaScalars.of(javaType).getCoercing();
            Function<Object, Object> valueConverter = it -> javaType.isInstance(it) ? it : coercing.parseValue(it);
            if (argumentValue instanceof Collection) {
                Collection argumentValues = (Collection)argumentValue;
                return argumentValues.stream().map(valueConverter).toList();
            }
            return valueConverter.apply(argumentValue);
        }
        if (value instanceof ArrayValue) {
            Collection arrayValue = (Collection)environment.getArgument(argument.getName());
            if (arrayValue != null) {
                if (arrayValue.stream().allMatch(it -> it instanceof Collection)) {
                    arrayValue = (Collection)Collection.class.cast(arrayValue.iterator().next());
                }
                if (this.getJavaType(environment, argument).isEnum()) {
                    Function<Object, Value> objectValue = obj -> Value.class.isInstance(obj) ? (Value)Value.class.cast(obj) : new EnumValue(obj.toString());
                    return arrayValue.stream().map(it -> this.convertValue(environment, argument, (Value)objectValue.apply(it))).collect(Collectors.toList());
                }
                if (arrayValue.stream().anyMatch(it -> it instanceof Value)) {
                    return arrayValue.stream().map(it -> this.convertValue(environment, argument, (Value)Value.class.cast(it))).collect(Collectors.toList());
                }
                return arrayValue;
            }
            return ((ArrayValue)value).getValues().stream().map(it -> this.convertValue(environment, argument, (Value)it)).collect(Collectors.toList());
        }
        if (value instanceof EnumValue) {
            Class<?> enumType = this.getJavaType(environment, argument);
            return Enum.valueOf(enumType, ((EnumValue)value).getName());
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof ObjectValue) {
            Class<?> javaType = this.getJavaType(environment, argument);
            Map values = (Map)environment.getArgument(argument.getName());
            try {
                return this.getJavaBeanValue(javaType, values);
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        }
        return value;
    }

    private Object getJavaBeanValue(Class<?> javaType, Map<String, Object> values) throws Exception {
        Constructor<?> constructor = javaType.getConstructor(new Class[0]);
        constructor.setAccessible(true);
        Object javaBean = constructor.newInstance(new Object[0]);
        values.entrySet().stream().forEach(entry -> this.setPropertyValue(javaBean, (String)entry.getKey(), entry.getValue()));
        return javaBean;
    }

    private void setPropertyValue(Object javaBean, String propertyName, Object propertyValue) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo bi = Introspector.getBeanInfo(javaBean.getClass());
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(propertyName)) continue;
                Method setter = pd.getWriteMethod();
                setter.setAccessible(true);
                if (setter == null) continue;
                setter.invoke(javaBean, propertyValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Class<?> getJavaType(DataFetchingEnvironment environment, Argument argument) {
        Attribute<?, ?> argumentEntityAttribute = this.getAttribute(environment, argument.getName());
        if (argumentEntityAttribute instanceof PluralAttribute) {
            return ((PluralAttribute)argumentEntityAttribute).getElementType().getJavaType();
        }
        return argumentEntityAttribute.getJavaType();
    }

    private Attribute<?, ?> getAttribute(DataFetchingEnvironment environment, String argument) {
        GraphQLObjectType objectType = this.getObjectType(environment);
        if (!this.isEntityType(objectType)) {
            return this.getEmbeddableType(objectType).getAttribute(argument);
        }
        return this.getEntityType(objectType).getAttribute(argument);
    }

    private boolean isOptionalAttribute(Attribute<?, ?> attribute) {
        if (SingularAttribute.class.isInstance(attribute)) {
            return ((SingularAttribute)SingularAttribute.class.cast(attribute)).isOptional();
        }
        return PluralAttribute.class.isInstance(attribute);
    }

    private EntityType<?> getEntityType(GraphQLObjectType objectType) {
        return this.entityTypeMap.computeIfAbsent(objectType, this::computeEntityType);
    }

    private boolean isEntityType(DataFetchingEnvironment environment) {
        GraphQLObjectType objectType = this.getObjectType(environment);
        return this.isEntityType(objectType);
    }

    private boolean isEntityType(GraphQLObjectType objectType) {
        return this.getEntityType(objectType) != null;
    }

    private EntityType<?> computeEntityType(GraphQLObjectType objectType) {
        return this.graphQLObjectTypeMetadata.entity(objectType.getName());
    }

    private EmbeddableType<?> getEmbeddableType(GraphQLObjectType objectType) {
        return this.embeddableTypeMap.computeIfAbsent(objectType, this::computeEmbeddableType);
    }

    private EmbeddableType<?> computeEmbeddableType(GraphQLObjectType objectType) {
        return this.graphQLObjectTypeMetadata.embeddable(objectType.getName());
    }

    private GraphQLObjectType getObjectType(DataFetchingEnvironment environment) {
        return this.getObjectType((GraphQLType)environment.getFieldType());
    }

    private GraphQLObjectType getObjectType(GraphQLType outputType) {
        if (outputType instanceof GraphQLList) {
            outputType = ((GraphQLList)outputType).getWrappedType();
        }
        if (outputType instanceof GraphQLObjectType) {
            return (GraphQLObjectType)outputType;
        }
        return null;
    }

    protected Optional<Argument> extractArgument(graphql.language.Field field, String argumentName) {
        return field.getArguments().stream().filter(it -> argumentName.equals(it.getName())).findFirst();
    }

    protected Argument extractArgument(graphql.language.Field field, String argumentName, Value defaultValue) {
        return this.extractArgument(field, argumentName).orElse(new Argument(argumentName, defaultValue));
    }

    protected GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, GraphQLObjectType parentType, graphql.language.Field field) {
        if (schema.getQueryType() == parentType) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return Introspection.SchemaMetaFieldDef;
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return Introspection.TypeMetaFieldDef;
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return Introspection.TypeNameMetaFieldDef;
        }
        GraphQLFieldDefinition fieldDefinition = parentType.getFieldDefinition(field.getName());
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        throw new GraphQLException("unknown field " + field.getName());
    }

    protected boolean hasSelectionSet(graphql.language.Field field) {
        return field.getSelectionSet() != null;
    }

    protected <T> T getArgumentValue(DataFetchingEnvironment environment, Argument argument, Class<T> type) {
        Value value = argument.getValue();
        if (VariableReference.class.isInstance(value)) {
            return (T)environment.getVariables().get(((VariableReference)VariableReference.class.cast(value)).getName());
        }
        if (BooleanValue.class.isInstance(value)) {
            return (T)Boolean.valueOf(((BooleanValue)BooleanValue.class.cast(value)).isValue());
        }
        if (IntValue.class.isInstance(value)) {
            return (T)((IntValue)IntValue.class.cast(value)).getValue();
        }
        if (StringValue.class.isInstance(value)) {
            return (T)((StringValue)StringValue.class.cast(value)).getValue();
        }
        if (FloatValue.class.isInstance(value)) {
            return (T)((FloatValue)FloatValue.class.cast(value)).getValue();
        }
        if (NullValue.class.isInstance(value)) {
            return null;
        }
        throw new IllegalArgumentException("Not supported");
    }

    protected boolean isPersistent(DataFetchingEnvironment environment, String attributeName) {
        GraphQLObjectType objectType = this.getObjectType(environment);
        EntityType<?> entityType = this.getEntityType(objectType);
        return this.isPersistent(entityType, attributeName);
    }

    protected boolean isPersistent(EntityType<?> entityType, String attributeName) {
        try {
            return entityType.getAttribute(attributeName) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getJPQLQueryString(TypedQuery<?> query) {
        try {
            Method getQueryString = ReflectionUtil.getMethod((Class)query.getClass(), (String)"getQueryString", (Class[])new Class[0]);
            if (getQueryString != null) {
                return getQueryString.invoke(query, new Object[0]).toString();
            }
        }
        catch (Exception ignored) {
            logger.error("Error getting JPQL string", (Throwable)ignored);
        }
        return null;
    }

    protected boolean hasIdAttribute() {
        return this.entityType.getIdType() != null;
    }

    protected String idAttributeName() {
        return this.entityType.getId(this.entityType.getIdType().getJavaType()).getName();
    }

    protected boolean hasIdClassAttribue() {
        return this.entityType.getIdClassAttributes() != null;
    }

    protected String[] idClassAttributeNames() {
        return this.entityType.getIdClassAttributes().stream().map(Attribute::getName).sorted().collect(Collectors.toList()).toArray(new String[0]);
    }

    protected <T> T getParentIdAttributeValue(T entity) {
        SingularAttribute parentIdAttribute = this.entityType.getId(Object.class);
        return this.getAttributeValue(entity, parentIdAttribute);
    }

    protected <E, T> T getAttributeValue(T entity, SingularAttribute<E, T> field) {
        try {
            Member member = field.getJavaMember();
            if (member instanceof Method) {
                return (T)((Method)member).invoke(entity, new Object[0]);
            }
            if (member instanceof Field) {
                return (T)((Field)member).get(entity);
            }
            throw new IllegalArgumentException("Unexpected java member type. Expecting method or field, found: " + String.valueOf(member));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <EntityType, FieldType> FieldType getAttributeValue(EntityType entity, PluralAttribute<EntityType, ?, FieldType> field) {
        try {
            Member member = field.getJavaMember();
            if (member instanceof Method) {
                return (FieldType)((Method)member).invoke(entity, new Object[0]);
            }
            if (member instanceof Field) {
                return (FieldType)((Field)member).get(entity);
            }
            throw new IllegalArgumentException("Unexpected java member type. Expecting method or field, found: " + String.valueOf(member));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean resolveDistinctArgument(graphql.language.Field field) {
        Argument distinctArg = this.extractArgument(field, "distinct", (Value)new BooleanValue(this.defaultDistinct));
        return ((BooleanValue)BooleanValue.class.cast(distinctArg.getValue())).isValue();
    }

    public boolean isDefaultDistinct() {
        return this.defaultDistinct;
    }

    public String getSelectNodeName() {
        return this.selectNodeName;
    }

    public MergedField resolveQueryField(graphql.language.Field rootNode) {
        Optional<graphql.language.Field> recordsSelection = GraphQLSupport.searchByFieldName(rootNode, this.getSelectNodeName());
        graphql.language.Field queryField = recordsSelection.map(selectNode -> graphql.language.Field.newField((String)selectNode.getName()).selectionSet(selectNode.getSelectionSet()).arguments(rootNode.getArguments()).directives(selectNode.getDirectives()).build()).orElse(rootNode);
        return MergedField.newMergedField((graphql.language.Field)queryField).build();
    }

    public GraphQLObjectType getEntityObjectType() {
        return this.entityObjectType;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    private MergedField flattenEmbeddedIdArguments(graphql.language.Field field) {
        List argumentsWhereObjectsAreFlattened = field.getArguments().stream().flatMap(argument -> {
            if (!GraphQLSupport.isWhereArgument(argument).booleanValue() && !GraphQLSupport.isPageArgument(argument).booleanValue() && argument.getValue() instanceof ObjectValue) {
                return ((ObjectValue)argument.getValue()).getObjectFields().stream().map(objectField -> new Argument(argument.getName() + "." + objectField.getName(), objectField.getValue()));
            }
            return Stream.of(argument);
        }).collect(Collectors.toList());
        return MergedField.newMergedField((graphql.language.Field)field.transform(builder -> builder.arguments(argumentsWhereObjectsAreFlattened))).build();
    }

    protected boolean hasAnySelectionOrderBy(graphql.language.Field field) {
        if (!this.hasSelectionSet(field)) {
            return false;
        }
        return field.getSelectionSet().getSelections().stream().filter(graphql.language.Field.class::isInstance).map(graphql.language.Field.class::cast).anyMatch(selectedField -> {
            Optional<Argument> orderBy = selectedField.getArguments().stream().filter(this::isOrderByArgument).findFirst();
            return orderBy.isPresent();
        });
    }

    private <T> T unproxy(T entityProxy) {
        return (T)unproxy.apply(entityProxy);
    }

    private <T> T unproxyAndThenDetach(T entityProxy) {
        return (T)unproxy.andThen(this::detach).apply(entityProxy);
    }

    private <T> T detach(T entity) {
        this.entityManager.detach(entity);
        return entity;
    }

    EntityGraph<?> createEntityGraph(DataFetchingEnvironment environment) {
        graphql.language.Field root = environment.getMergedField().getSingleField();
        GraphQLObjectType fieldType = this.getObjectType(environment);
        EntityType<?> entityType = this.getEntityType(fieldType);
        EntityGraph entityGraph = this.entityManager.createEntityGraph(entityType.getJavaType());
        EntityIntrospector.EntityIntrospectionResult entityDescriptor = EntityIntrospector.introspect(entityType);
        GraphQLSupport.selections(root).forEach(selectedField -> {
            Optional<EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor> propertyDescriptor = entityDescriptor.getPropertyDescriptor(selectedField.getName());
            propertyDescriptor.flatMap(EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor::getAttribute).ifPresent(attribute -> {
                if (GraphQLJpaQueryFactory.isManagedType(attribute) && this.hasSelectionSet((graphql.language.Field)selectedField) && GraphQLJpaQueryFactory.hasNoArguments(selectedField)) {
                    GraphQLFieldDefinition attributeFieldDefinition = fieldType.getFieldDefinition(attribute.getName());
                    entityGraph.addAttributeNodes(new String[]{attribute.getName()});
                    this.addSubgraph((graphql.language.Field)selectedField, attributeFieldDefinition, (Subgraph<?>)entityGraph.addSubgraph(attribute.getName()));
                } else if (GraphQLJpaQueryFactory.isBasic(attribute)) {
                    entityGraph.addAttributeNodes(new String[]{attribute.getName()});
                }
            });
        });
        return entityGraph;
    }

    void addSubgraph(graphql.language.Field field, GraphQLFieldDefinition fieldDefinition, Subgraph<?> subgraph) {
        GraphQLObjectType fieldObjectType = this.getObjectType((GraphQLType)fieldDefinition.getType());
        EntityType<?> fieldEntityType = this.getEntityType(fieldObjectType);
        EntityIntrospector.EntityIntrospectionResult fieldEntityDescriptor = EntityIntrospector.introspect(fieldEntityType);
        GraphQLSupport.selections(field).forEach(selectedField -> {
            Optional<EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor> propertyDescriptor = fieldEntityDescriptor.getPropertyDescriptor(selectedField.getName());
            propertyDescriptor.flatMap(EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor::getAttribute).ifPresent(attribute -> {
                String selectedName = selectedField.getName();
                if (this.hasSelectionSet((graphql.language.Field)selectedField) && GraphQLJpaQueryFactory.isManagedType(attribute) && GraphQLJpaQueryFactory.hasNoArguments(selectedField)) {
                    GraphQLFieldDefinition selectedFieldDefinition = fieldObjectType.getFieldDefinition(selectedName);
                    subgraph.addAttributeNodes(new String[]{selectedName});
                    this.addSubgraph((graphql.language.Field)selectedField, selectedFieldDefinition, (Subgraph<?>)subgraph.addSubgraph(selectedName));
                } else if (GraphQLJpaQueryFactory.isBasic(attribute)) {
                    subgraph.addAttributeNodes(new String[]{selectedName});
                }
            });
        });
    }

    static boolean isManagedType(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.EMBEDDED && attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC && attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    static boolean isBasic(Attribute<?, ?> attribute) {
        return !GraphQLJpaQueryFactory.isManagedType(attribute);
    }

    static boolean hasNoArguments(graphql.language.Field field) {
        return !GraphQLJpaQueryFactory.hasArguments(field);
    }

    static boolean hasArguments(graphql.language.Field field) {
        return field.getArguments() != null && !field.getArguments().isEmpty();
    }

    public static IEntityManagerStage builder() {
        return new Builder();
    }

    public RestrictedKeysProvider getRestrictedKeysProvider() {
        return this.restrictedKeysProvider;
    }

    static {
        try {
            Class<?> hibernateClass = Class.forName("org.hibernate.Hibernate");
            Method unproxyMethod = hibernateClass.getDeclaredMethod("unproxy", Object.class);
            unproxy = proxy -> {
                try {
                    return unproxyMethod.invoke(null, proxy);
                }
                catch (Exception exception) {
                    return proxy;
                }
            };
        }
        catch (Exception ignored) {
            unproxy = Function.identity();
        }
    }

    public static final class Builder
    implements IEntityManagerStage,
    IEntityTypeStage,
    IGraphQLObjectTypeMetadataStage,
    IEntityObjectTypeStage,
    ISelectNodeNameStage,
    IBuildStage {
        private RestrictedKeysProvider restrictedKeysProvider;
        private EntityManager entityManager;
        private EntityType<?> entityType;
        private GraphQLObjectType entityObjectType;
        private String selectNodeName;
        private boolean toManyDefaultOptional = true;
        private boolean defaultDistinct = true;
        private int defaultFetchSize = 100;
        private boolean resultStream = false;
        private GraphQLObjectTypeMetadata graphQLObjectTypeMetadata;

        private Builder() {
        }

        @Override
        public IEntityTypeStage withEntityManager(EntityManager entityManager) {
            this.entityManager = entityManager;
            return this;
        }

        @Override
        public IGraphQLObjectTypeMetadataStage withEntityType(EntityType<?> entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public IEntityObjectTypeStage withGraphQLObjectTypeMetadata(GraphQLObjectTypeMetadata graphQLObjectTypeMetadata) {
            this.graphQLObjectTypeMetadata = graphQLObjectTypeMetadata;
            return this;
        }

        @Override
        public ISelectNodeNameStage withEntityObjectType(GraphQLObjectType entityObjectType) {
            this.entityObjectType = entityObjectType;
            return this;
        }

        @Override
        public IBuildStage withSelectNodeName(String selectNodeName) {
            this.selectNodeName = selectNodeName;
            return this;
        }

        @Override
        public IBuildStage withToManyDefaultOptional(boolean toManyDefaultOptional) {
            this.toManyDefaultOptional = toManyDefaultOptional;
            return this;
        }

        @Override
        public IBuildStage withDefaultDistinct(boolean defaultDistinct) {
            this.defaultDistinct = defaultDistinct;
            return this;
        }

        @Override
        public IBuildStage withResultStream(boolean resultStream) {
            this.resultStream = resultStream;
            return this;
        }

        @Override
        public IBuildStage withDefaultFetchSize(int defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
            return this;
        }

        @Override
        public IBuildStage withRestrictedKeysProvider(RestrictedKeysProvider restrictedKeysProvider) {
            this.restrictedKeysProvider = restrictedKeysProvider;
            return this;
        }

        @Override
        public GraphQLJpaQueryFactory build() {
            Objects.requireNonNull(this.restrictedKeysProvider, "restrictedKeysProvider must not be null");
            return new GraphQLJpaQueryFactory(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withToManyDefaultOptional(boolean var1);

        public IBuildStage withDefaultDistinct(boolean var1);

        public IBuildStage withResultStream(boolean var1);

        public IBuildStage withDefaultFetchSize(int var1);

        public IBuildStage withRestrictedKeysProvider(RestrictedKeysProvider var1);

        public GraphQLJpaQueryFactory build();
    }

    public static interface ISelectNodeNameStage {
        public IBuildStage withSelectNodeName(String var1);
    }

    public static interface IEntityObjectTypeStage {
        public ISelectNodeNameStage withEntityObjectType(GraphQLObjectType var1);
    }

    public static interface IGraphQLObjectTypeMetadataStage {
        public IEntityObjectTypeStage withGraphQLObjectTypeMetadata(GraphQLObjectTypeMetadata var1);
    }

    public static interface IEntityTypeStage {
        public IGraphQLObjectTypeMetadataStage withEntityType(EntityType<?> var1);
    }

    public static interface IEntityManagerStage {
        public IEntityTypeStage withEntityManager(EntityManager var1);
    }
}

