/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.annotation.GraphQLIgnore;
import com.introproventures.graphql.jpa.query.annotation.GraphQLIgnoreFilter;
import com.introproventures.graphql.jpa.query.annotation.GraphQLIgnoreOrder;
import com.introproventures.graphql.jpa.query.schema.GraphQLSchemaBuilder;
import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.NamingStrategy;
import com.introproventures.graphql.jpa.query.schema.RestrictedKeysProvider;
import com.introproventures.graphql.jpa.query.schema.impl.BatchLoaderRegistry;
import com.introproventures.graphql.jpa.query.schema.impl.EntityIntrospector;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryDataFetcher;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaSimpleDataFetcher;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaStreamDataFetcher;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaToManyDataFetcher;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaToManyMappedBatchLoader;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaToOneDataFetcher;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaToOneMappedBatchLoader;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLObjectTypeMetadata;
import com.introproventures.graphql.jpa.query.schema.impl.Logical;
import com.introproventures.graphql.jpa.query.schema.impl.PredicateFilter;
import com.introproventures.graphql.jpa.query.schema.relay.GraphQLJpaRelayDataFetcher;
import com.introproventures.graphql.jpa.query.support.GraphQLSupport;
import graphql.Assert;
import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.PropertyDataFetcher;
import jakarta.persistence.Convert;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLJpaSchemaBuilder
implements GraphQLSchemaBuilder {
    private static final Logger log = LoggerFactory.getLogger(GraphQLJpaSchemaBuilder.class);
    private static final String NODE = "node";
    public static final String PAGE_PARAM_NAME = "page";
    public static final String PAGE_TOTAL_PARAM_NAME = "total";
    public static final String PAGE_PAGES_PARAM_NAME = "pages";
    public static final String PAGE_START_PARAM_NAME = "start";
    public static final String PAGE_LIMIT_PARAM_NAME = "limit";
    public static final String QUERY_SELECT_PARAM_NAME = "select";
    public static final String QUERY_WHERE_PARAM_NAME = "where";
    public static final String QUERY_LOGICAL_PARAM_NAME = "logical";
    public static final String SELECT_DISTINCT_PARAM_NAME = "distinct";
    protected NamingStrategy namingStrategy = new NamingStrategy(){};
    public static final String ORDER_BY_PARAM_NAME = "orderBy";
    private final Map<Class<?>, GraphQLOutputType> classCache = new HashMap();
    private final Map<EntityType<?>, GraphQLObjectType> entityCache = new HashMap();
    private final Map<String, EntityType<?>> entityTypeMap = new ConcurrentHashMap();
    private final Map<String, EmbeddableType<?>> embeddableTypeMap = new ConcurrentHashMap();
    private final Map<ManagedType<?>, GraphQLInputObjectType> inputObjectCache = new HashMap();
    private final Map<ManagedType<?>, GraphQLInputObjectType> subqueryInputObjectCache = new HashMap();
    private final Map<Class<?>, GraphQLObjectType> embeddableOutputCache = new HashMap();
    private final Map<Class<?>, GraphQLInputObjectType> embeddableInputCache = new HashMap();
    private Function<String, String> queryByIdFieldNameCustomizer = Function.identity();
    private Function<String, String> queryAllFieldNameCustomizer = Function.identity();
    private Function<String, String> queryResultTypeNameCustomizer = Function.identity();
    private Function<String, String> queryTypeNameCustomizer = it -> it.concat("Query");
    private Function<String, String> queryWhereArgumentTypeNameCustomizer = name -> name.concat("CriteriaExpression");
    private Function<String, String> queryEmbeddableTypeNameCustomizer = it -> it.concat("EmbeddableType");
    private Function<String, String> subqueryArgumentTypeNameCustomizer = it -> it.concat("SubqueryCriteriaExpression");
    private Function<String, String> queryWhereInputTypeNameCustomizer = it -> it.concat("RelationCriteriaExpression");
    private final Function<String, String> singularize = word -> this.namingStrategy.singularize((String)word);
    private final Function<String, String> pluralize = word -> this.namingStrategy.pluralize((String)word);
    private final EntityManager entityManager;
    private String name = "GraphQLJPA";
    private String description = "GraphQL Schema for all entities in this JPA application";
    private boolean isUseDistinctParameter = false;
    private boolean isDefaultDistinct = true;
    private boolean toManyDefaultOptional = true;
    private boolean enableSubscription = false;
    private boolean enableRelay = false;
    private boolean enableAggregate = false;
    private int defaultMaxResults = 100;
    private int defaultFetchSize = 100;
    private int defaultPageLimitSize = 100;
    private boolean enableDefaultMaxResults = true;
    private boolean enableResultStream = false;
    private boolean graphQLIDType = false;
    private RestrictedKeysProvider restrictedKeysProvider = entityDescriptor -> Optional.of(Collections.emptyList());
    private final Map<Class<?>, GraphQLScalarType> scalars = new LinkedHashMap();
    private final Relay relay = new Relay();
    private final List<String> entityPaths = new ArrayList<String>();
    private final Supplier<BatchLoaderRegistry> batchLoadersRegistry = BatchLoaderRegistry::getInstance;
    private final Function<String, EntityType<?>> entityObjectTypeResolver = this.entityTypeMap::get;
    private final Function<String, EmbeddableType<?>> embeddableObjectTypeResolver = this.embeddableTypeMap::get;
    private final GraphQLObjectTypeMetadata graphQLObjectTypeMetadata = new GraphQLObjectTypeMetadataImpl();
    private Map<Class<?>, GraphQLArgument> whereArgumentsMap = new HashMap();
    private Map<String, GraphQLInputType> whereAttributesMap = new HashMap<String, GraphQLInputType>();
    private static final GraphQLArgument paginationArgument = GraphQLArgument.newArgument().name("page").description("Page object for pageble requests, specifying the requested start page and limit size.").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("Page").description("Page fields for pageble requests.").field(GraphQLInputObjectField.newInputObjectField().name("start").description("Start page that should be returned. Page numbers start with 1 (1-indexed)").defaultValue((Object)1).type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("limit").description("Limit how many results should this page contain").type((GraphQLInputType)Scalars.GraphQLInt).build()).build()).build();
    private static final GraphQLEnumType orderByDirectionEnum = GraphQLEnumType.newEnum().name("OrderBy").description("Specifies the direction (Ascending / Descending) to sort a field.").value("ASC", (Object)"ASC", "Ascending").value("DESC", (Object)"DESC", "Descending").build();

    public GraphQLJpaSchemaBuilder(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public GraphQLSchema build() {
        this.scalars.forEach(JavaScalars::register);
        GraphQLSchema.Builder schema = GraphQLSchema.newSchema().query(this.getQueryType());
        if (this.enableSubscription) {
            schema.subscription(this.getSubscriptionType());
        }
        if (this.enableRelay) {
            schema.additionalType((GraphQLType)Relay.pageInfoType);
        }
        this.entityCache.forEach((entity, type) -> this.entityTypeMap.put(type.getName(), (EntityType<?>)entity));
        this.entityManager.getMetamodel().getEmbeddables().stream().filter(it -> this.embeddableOutputCache.containsKey(it.getJavaType())).forEach(it -> this.embeddableTypeMap.put(this.embeddableOutputCache.get(it.getJavaType()).getName(), (EmbeddableType<?>)it));
        return schema.build();
    }

    @Override
    public GraphQLJpaSchemaBuilder scalar(Class<?> javaType, GraphQLScalarType scalarType) {
        this.scalars.put(javaType, scalarType);
        return this;
    }

    private GraphQLObjectType getQueryType() {
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name(this.queryTypeNameCustomizer.apply(this.name)).description(this.description);
        queryType.fields(this.entityManager.getMetamodel().getEntities().stream().filter(this::isNotIgnored).map(this::getQueryFieldByIdDefinition).toList());
        queryType.fields(this.entityManager.getMetamodel().getEntities().stream().filter(this::isNotIgnored).map(this::getQueryFieldSelectDefinition).toList());
        return queryType.build();
    }

    private GraphQLObjectType getSubscriptionType() {
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name(this.name + "Subscription").description(this.description);
        queryType.fields(this.entityManager.getMetamodel().getEntities().stream().filter(this::isNotIgnored).map(this::getQueryFieldStreamDefinition).collect(Collectors.toList()));
        return queryType.build();
    }

    private GraphQLFieldDefinition getQueryFieldByIdDefinition(EntityType<?> entityType) {
        GraphQLObjectType entityObjectType = this.getEntityObjectType(entityType);
        GraphQLJpaQueryFactory queryFactory = GraphQLJpaQueryFactory.builder().withEntityManager(this.entityManager).withEntityType(entityType).withGraphQLObjectTypeMetadata(this.graphQLObjectTypeMetadata).withEntityObjectType(entityObjectType).withSelectNodeName(entityObjectType.getName()).withToManyDefaultOptional(this.toManyDefaultOptional).withRestrictedKeysProvider(this.restrictedKeysProvider).withResultStream(this.enableResultStream).build();
        GraphQLJpaSimpleDataFetcher dataFetcher = GraphQLJpaSimpleDataFetcher.builder().withQueryFactory(queryFactory).build();
        String fieldName = this.singularize.andThen(this.queryByIdFieldNameCustomizer).apply(entityType.getName());
        return GraphQLFieldDefinition.newFieldDefinition().name(this.enableRelay ? Introspector.decapitalize(fieldName) : fieldName).description(this.getSchemaDescription(entityType)).type((GraphQLOutputType)entityObjectType).dataFetcher((DataFetcher)dataFetcher).arguments(entityType.getAttributes().stream().filter(this::isValidInput).filter(this::isNotIgnored).filter(this::isIdentity).map(this::getArgument).collect(Collectors.toList())).build();
    }

    private GraphQLObjectType getConnectionType(GraphQLObjectType nodeType) {
        GraphQLObjectType edgeType = this.relay.edgeType(nodeType.getName(), (GraphQLOutputType)nodeType, null, Collections.emptyList());
        return this.relay.connectionType(nodeType.getName(), edgeType, Collections.emptyList());
    }

    private GraphQLFieldDefinition getQueryFieldSelectDefinition(EntityType<?> entityType) {
        GraphQLObjectType entityObjectType = this.getEntityObjectType(entityType);
        GraphQLObjectType outputType = this.enableRelay ? this.getConnectionType(entityObjectType) : this.getSelectType(entityType);
        GraphQLJpaQueryFactory queryFactory = GraphQLJpaQueryFactory.builder().withEntityManager(this.entityManager).withEntityType(entityType).withGraphQLObjectTypeMetadata(this.graphQLObjectTypeMetadata).withEntityObjectType(entityObjectType).withSelectNodeName(this.enableRelay ? NODE : QUERY_SELECT_PARAM_NAME).withToManyDefaultOptional(this.toManyDefaultOptional).withDefaultDistinct(this.isDefaultDistinct).withDefaultFetchSize(this.defaultFetchSize).withRestrictedKeysProvider(this.restrictedKeysProvider).withResultStream(this.enableResultStream).build();
        Object dataFetcher = this.enableRelay ? GraphQLJpaRelayDataFetcher.builder().withQueryFactory(queryFactory).withDefaultMaxResults(this.defaultMaxResults).withEnableDefaultMaxResults(this.enableDefaultMaxResults).withDefaultFirstSize(this.defaultPageLimitSize).build() : GraphQLJpaQueryDataFetcher.builder().withQueryFactory(queryFactory).withDefaultMaxResults(this.defaultMaxResults).withEnableDefaultMaxResults(this.enableDefaultMaxResults).withDefaultPageLimitSize(this.defaultPageLimitSize).build();
        String fieldName = this.pluralize.andThen(this.queryAllFieldNameCustomizer).apply(entityType.getName());
        GraphQLFieldDefinition.Builder fieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name(this.enableRelay ? Introspector.decapitalize(fieldName) : fieldName).description("Query request wrapper for " + entityType.getName() + " to request paginated data. Use query request arguments to specify query filter criterias. Use the 'select' field to request actual fields. Use the 'orderBy' on a field to specify sort order for each field. ").type((GraphQLOutputType)outputType).dataFetcher((DataFetcher)dataFetcher).argument(this.getWhereArgument((ManagedType<?>)entityType)).arguments(this.enableRelay ? this.relay.getForwardPaginationConnectionFieldArguments() : Collections.singletonList(paginationArgument));
        if (this.isUseDistinctParameter) {
            fieldDefinition.argument(this.distinctArgument(entityType));
        }
        return fieldDefinition.build();
    }

    private String resolveSelectTypeName(EntityType<?> entityType) {
        return this.pluralize.andThen(this.queryResultTypeNameCustomizer).apply(entityType.getName());
    }

    private GraphQLObjectType getSelectType(EntityType<?> entityType) {
        GraphQLObjectType selectObjectType = this.getEntityObjectType(entityType);
        String selectTypeName = this.resolveSelectTypeName(entityType);
        GraphQLObjectType.Builder selectPagedResultType = GraphQLObjectType.newObject().name(selectTypeName).description("Query response wrapper object for " + entityType.getName() + ".  When page is requested, this object will be returned with query metadata.").field(GraphQLFieldDefinition.newFieldDefinition().name(PAGE_PAGES_PARAM_NAME).description("Total number of pages calculated on the database for this page size.").type((GraphQLOutputType)JavaScalars.of(Long.class)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name(PAGE_TOTAL_PARAM_NAME).description("Total number of records in the database for this query.").type((GraphQLOutputType)JavaScalars.of(Long.class)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name(QUERY_SELECT_PARAM_NAME).description("The queried records container").type((GraphQLOutputType)new GraphQLList((GraphQLType)selectObjectType)).build());
        if (this.enableAggregate) {
            selectPagedResultType.field(this.getAggregateFieldDefinition(entityType));
        }
        return selectPagedResultType.build();
    }

    private GraphQLFieldDefinition getAggregateFieldDefinition(EntityType<?> entityType) {
        String selectTypeName = this.resolveSelectTypeName(entityType);
        String aggregateObjectTypeName = selectTypeName.concat("Aggregate");
        GraphQLObjectType.Builder aggregateObjectType = GraphQLObjectType.newObject().name(aggregateObjectTypeName).description("%s entity aggregate object type".formatted(selectTypeName));
        DataFetcher aggregateDataFetcher = environment -> {
            Map source = (Map)environment.getSource();
            return source.get(GraphQLSupport.getAliasOrName(environment.getField()));
        };
        GraphQLFieldDefinition.Builder countFieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name("count").description("Count the number of records in the database for the %s aggregate".formatted(selectTypeName)).dataFetcher(aggregateDataFetcher).type((GraphQLOutputType)Scalars.GraphQLInt);
        List<GraphQLEnumValueDefinition> associationEnumValueDefinitions = entityType.getAttributes().stream().filter(it -> EntityIntrospector.introspect(entityType).isNotIgnored(it.getName())).filter(Attribute::isAssociation).map(Attribute::getName).map(name -> GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description("%s entity associated %s child entity".formatted(selectTypeName, name)).build()).toList();
        List<GraphQLEnumValueDefinition> fieldsEnumValueDefinitions = entityType.getAttributes().stream().filter(it -> EntityIntrospector.introspect(entityType).isNotIgnored(it.getName())).filter(it -> this.isBasic((Attribute<?, ?>)it) || this.isEmbeddable((Attribute<?, ?>)it)).map(Attribute::getName).map(name -> GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description("%s entity %s attribute".formatted(selectTypeName, name)).build()).toList();
        if (entityType.getAttributes().stream().anyMatch(Attribute::isAssociation)) {
            countFieldDefinition.argument(GraphQLArgument.newArgument().name("of").description("Count the number of associated records in the database for the %s aggregate".formatted(selectTypeName)).type((GraphQLInputType)GraphQLEnumType.newEnum().name(aggregateObjectTypeName.concat("CountOfAssociationsEnum")).description("%s entity associated entity name values".formatted(selectTypeName)).values(associationEnumValueDefinitions).build()));
        }
        GraphQLFieldDefinition.Builder groupFieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name("group").description("Group by %s entity query field aggregated by multiple fields".formatted(selectTypeName)).dataFetcher(aggregateDataFetcher).type((GraphQLOutputType)new GraphQLList((GraphQLType)GraphQLObjectType.newObject().name(aggregateObjectTypeName.concat("GroupBy")).description("%s entity group by object type".formatted(selectTypeName)).field(GraphQLFieldDefinition.newFieldDefinition().name("by").description("Group by %s field container used to query aggregate data by one or more fields".formatted(selectTypeName)).dataFetcher(aggregateDataFetcher).argument(GraphQLArgument.newArgument().name("field").description("Group by field argument used to specify %s entity field name".formatted(selectTypeName)).type((GraphQLInputType)GraphQLEnumType.newEnum().name(aggregateObjectTypeName.concat("GroupByFieldsEnum")).description("%s entity field name values".formatted(selectTypeName)).values(fieldsEnumValueDefinitions).build())).type((GraphQLOutputType)JavaScalars.GraphQLObjectScalar)).field(countFieldDefinition).build()));
        GraphQLObjectType.Builder aggregateByObjectType = GraphQLObjectType.newObject().name(selectTypeName.concat("AggregateBy")).description("%s aggregate query type groups by nested associations".formatted(selectTypeName));
        entityType.getAttributes().stream().filter(it -> EntityIntrospector.introspect(entityType).isNotIgnored(it.getName())).filter(Attribute::isAssociation).forEach(association -> {
            Class javaType = this.isPlural((Attribute<?, ?>)association) ? ((PluralAttribute)PluralAttribute.class.cast(association)).getBindableJavaType() : association.getJavaType();
            Map<String, Attribute<?, ?>> attributes = EntityIntrospector.resultOf(javaType).getAttributes();
            List<GraphQLEnumValueDefinition> fields = attributes.values().stream().filter(it -> this.isBasic((Attribute<?, ?>)it) || this.isEmbeddable((Attribute<?, ?>)it)).map(Attribute::getName).map(name -> GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).build()).toList();
            if (!fields.isEmpty()) {
                aggregateByObjectType.field(GraphQLFieldDefinition.newFieldDefinition().name(association.getName()).description("Aggregate by %s query field definition for the associated %s entity".formatted(selectTypeName, association.getName())).dataFetcher(aggregateDataFetcher).type((GraphQLOutputType)new GraphQLList((GraphQLType)GraphQLObjectType.newObject().name(aggregateObjectTypeName.concat(EntityIntrospector.capitalize(association.getName())).concat("GroupByNestedAssociation")).description("Aggregate %s query object type for the associated %s entity".formatted(selectTypeName, association.getName())).field(GraphQLFieldDefinition.newFieldDefinition().name("by").dataFetcher(aggregateDataFetcher).description("Group by %s attribute field used to query aggregate data by one or more fields".formatted(association.getName())).argument(GraphQLArgument.newArgument().name("field").description("Group by field argument used to specify associated %s entity field name".formatted(association.getName())).type((GraphQLInputType)GraphQLEnumType.newEnum().name(aggregateObjectTypeName.concat(EntityIntrospector.capitalize(association.getName())).concat("GroupByNestedAssociationEnum")).values(fields).build())).type((GraphQLOutputType)JavaScalars.GraphQLObjectScalar)).field(GraphQLFieldDefinition.newFieldDefinition().name("count").description("Count the number of records in the database for the %s associated nested aggregate".formatted(association.getName())).type((GraphQLOutputType)Scalars.GraphQLInt)).build())));
            }
        });
        aggregateObjectType.field(countFieldDefinition).field(groupFieldDefinition);
        if (!aggregateByObjectType.build().getFieldDefinitions().isEmpty()) {
            aggregateObjectType.field(GraphQLFieldDefinition.newFieldDefinition().name("by").description("Nested aggregate by query field for %s entity".formatted(selectTypeName)).type(aggregateByObjectType));
        }
        GraphQLFieldDefinition.Builder aggregateFieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name("aggregate").description("Aggregate data query field for %s entity".formatted(selectTypeName)).type(aggregateObjectType);
        return aggregateFieldDefinition.build();
    }

    private GraphQLFieldDefinition getQueryFieldStreamDefinition(EntityType<?> entityType) {
        GraphQLObjectType entityObjectType = this.getEntityObjectType(entityType);
        GraphQLJpaQueryFactory queryFactory = GraphQLJpaQueryFactory.builder().withEntityManager(this.entityManager).withEntityType(entityType).withGraphQLObjectTypeMetadata(this.graphQLObjectTypeMetadata).withEntityObjectType(entityObjectType).withSelectNodeName(SELECT_DISTINCT_PARAM_NAME).withToManyDefaultOptional(this.toManyDefaultOptional).withDefaultDistinct(this.isDefaultDistinct).withRestrictedKeysProvider(this.restrictedKeysProvider).withResultStream(this.enableResultStream).build();
        GraphQLJpaStreamDataFetcher dataFetcher = GraphQLJpaStreamDataFetcher.builder().withQueryFactory(queryFactory).build();
        String fieldName = this.pluralize.andThen(this.queryResultTypeNameCustomizer).apply(entityType.getName());
        GraphQLFieldDefinition.Builder fieldDefinition = GraphQLFieldDefinition.newFieldDefinition().name(fieldName).description("Query request wrapper for " + entityType.getName() + " to request paginated data. Use query request arguments to specify query filter criterias. Use the 'orderBy' on a field to specify sort order for each field. ").type((GraphQLOutputType)entityObjectType).dataFetcher((DataFetcher)dataFetcher).argument(paginationArgument).argument(this.getWhereArgument((ManagedType<?>)entityType));
        if (this.isUseDistinctParameter) {
            fieldDefinition.argument(this.distinctArgument(entityType));
        }
        return fieldDefinition.build();
    }

    private GraphQLArgument distinctArgument(EntityType<?> entityType) {
        return GraphQLArgument.newArgument().name(SELECT_DISTINCT_PARAM_NAME).description("Distinct logical specification").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)this.isDefaultDistinct).build();
    }

    private GraphQLArgument getWhereArgument(ManagedType<?> managedType) {
        return this.whereArgumentsMap.computeIfAbsent(managedType.getJavaType(), javaType -> this.computeWhereArgument(managedType));
    }

    private GraphQLArgument computeWhereArgument(ManagedType<?> managedType) {
        String type = this.resolveWhereArgumentTypeName(managedType);
        GraphQLInputObjectType whereInputObject = GraphQLInputObjectType.newInputObject().name(type).description("Where logical AND specification of the provided list of criteria expressions").field(GraphQLInputObjectField.newInputObjectField().name(Logical.OR.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.AND.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.EXISTS.name()).description("Logical EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getSubqueryInputType(managedType))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.NOT_EXISTS.name()).description("Logical NOT EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getSubqueryInputType(managedType))).build()).fields(managedType.getAttributes().stream().filter(this::isValidInput).filter(this::isNotIgnored).filter(this::isNotIgnoredFilter).map(this::getWhereInputField).collect(Collectors.toList())).fields(managedType.getAttributes().stream().filter(Attribute::isAssociation).filter(this::isNotIgnored).filter(this::isNotIgnoredFilter).map(this::getInputObjectField).collect(Collectors.toList())).build();
        return GraphQLArgument.newArgument().name(QUERY_WHERE_PARAM_NAME).description("Where logical specification").type((GraphQLInputType)whereInputObject).build();
    }

    private String resolveWhereArgumentTypeName(ManagedType<?> managedType) {
        String typeName = this.resolveManagedTypeName(managedType);
        return this.pluralize.andThen(this.queryWhereArgumentTypeNameCustomizer).apply(typeName);
    }

    private String resolveSubqueryArgumentTypeName(ManagedType<?> managedType) {
        String typeName = this.resolveManagedTypeName(managedType);
        return this.pluralize.andThen(this.subqueryArgumentTypeNameCustomizer).apply(typeName);
    }

    private GraphQLInputObjectType getSubqueryInputType(ManagedType<?> managedType) {
        return this.subqueryInputObjectCache.computeIfAbsent(managedType, this::computeSubqueryInputType);
    }

    private GraphQLInputObjectType computeSubqueryInputType(ManagedType<?> managedType) {
        String type = this.resolveSubqueryArgumentTypeName(managedType);
        GraphQLInputObjectType.Builder whereInputObject = GraphQLInputObjectType.newInputObject().name(type).description("Where logical AND specification of the provided list of criteria expressions").field(GraphQLInputObjectField.newInputObjectField().name(Logical.OR.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.AND.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.EXISTS.name()).description("Logical EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.NOT_EXISTS.name()).description("Logical NOT EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).fields(managedType.getAttributes().stream().filter(Attribute::isAssociation).filter(this::isNotIgnored).filter(this::isNotIgnoredFilter).map(this::getWhereInputRelationField).collect(Collectors.toList()));
        return whereInputObject.build();
    }

    private String resolveManagedTypeName(ManagedType<?> managedType) {
        String typeName = "";
        if (managedType instanceof EmbeddableType) {
            typeName = managedType.getJavaType().getSimpleName();
        } else if (managedType instanceof EntityType) {
            EntityType entityType = (EntityType)managedType;
            typeName = entityType.getName();
        }
        return typeName;
    }

    private GraphQLInputObjectType getWhereInputType(ManagedType<?> managedType) {
        GraphQLInputObjectType type = this.inputObjectCache.get(managedType);
        if (type == null) {
            type = this.computeWhereInputType(managedType);
            this.inputObjectCache.put(managedType, type);
            return type;
        }
        return type;
    }

    private String resolveWhereInputTypeName(ManagedType<?> managedType) {
        String typeName = this.resolveManagedTypeName(managedType);
        return this.pluralize.andThen(this.queryWhereInputTypeNameCustomizer).apply(typeName);
    }

    private GraphQLInputObjectType computeWhereInputType(ManagedType<?> managedType) {
        String type = this.resolveWhereInputTypeName(managedType);
        GraphQLInputObjectType.Builder whereInputObject = GraphQLInputObjectType.newInputObject().name(type).description("Where logical AND specification of the provided list of criteria expressions").field(GraphQLInputObjectField.newInputObjectField().name(Logical.OR.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.AND.name()).description("Logical operation for expressions").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.EXISTS.name()).description("Logical EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getSubqueryInputType(managedType))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.NOT_EXISTS.name()).description("Logical NOT EXISTS subquery expression").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getSubqueryInputType(managedType))).build()).fields(managedType.getAttributes().stream().filter(this::isValidInput).filter(this::isNotIgnored).filter(this::isNotIgnoredFilter).map(this::getWhereInputField).collect(Collectors.toList())).fields(managedType.getAttributes().stream().filter(Attribute::isAssociation).filter(this::isNotIgnored).filter(this::isNotIgnoredFilter).map(this::getWhereInputRelationField).collect(Collectors.toList()));
        return whereInputObject.build();
    }

    private GraphQLInputObjectField getWhereInputRelationField(Attribute<?, ?> attribute) {
        ManagedType<?> foreignType = this.getForeignType(attribute);
        String type = this.resolveWhereInputTypeName(foreignType);
        String description = this.getSchemaDescription(attribute);
        return GraphQLInputObjectField.newInputObjectField().name(attribute.getName()).description(description).type((GraphQLInputType)new GraphQLTypeReference(type)).build();
    }

    private GraphQLInputObjectField getWhereInputField(Attribute<?, ?> attribute) {
        GraphQLInputType type = this.getWhereAttributeType(attribute);
        String description = this.getSchemaDescription(attribute);
        if (type instanceof GraphQLInputType) {
            return GraphQLInputObjectField.newInputObjectField().name(attribute.getName()).description(description).type(type).build();
        }
        throw new IllegalArgumentException("Attribute " + attribute.getName() + " cannot be mapped as an Input Argument");
    }

    private GraphQLInputType getWhereAttributeType(Attribute<?, ?> attribute) {
        String type = this.namingStrategy.singularize(attribute.getName()) + attribute.getDeclaringType().getJavaType().getSimpleName() + "Criteria";
        if (this.whereAttributesMap.containsKey(type)) {
            return this.whereAttributesMap.get(type);
        }
        if (this.isEmbeddable(attribute)) {
            EmbeddableType embeddableType = (EmbeddableType)((SingularAttribute)attribute).getType();
            return this.getWhereInputType((ManagedType<?>)embeddableType);
        }
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(type).description("Criteria expression specification of " + this.namingStrategy.singularize(attribute.getName()) + " attribute in entity " + String.valueOf(attribute.getDeclaringType().getJavaType())).field(GraphQLInputObjectField.newInputObjectField().name(Logical.OR.name()).description("Logical OR criteria expression").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(Logical.AND.name()).description("Logical AND criteria expression").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(type))).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.EQ.name()).description("Equals criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.NE.name()).description("Not Equals criteria").type(this.getAttributeInputType(attribute)).build());
        if (!attribute.getJavaType().isEnum()) {
            if (!attribute.getJavaType().equals(String.class)) {
                builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LE.name()).description("Less then or Equals criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.GE.name()).description("Greater or Equals criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.GT.name()).description("Greater Then criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LT.name()).description("Less Then criteria").type(this.getAttributeInputType(attribute)).build());
            }
            if (attribute.getJavaType().equals(String.class)) {
                builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LIKE.name()).description("Like criteria, case sensitive").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LIKE_.name()).description("Like criteria, case insensitive").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LOWER.name()).description("Case insensitive match criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.EQ_.name()).description("Case equals case insensitive match criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.NE_.name()).description("Not equals case insensitive match criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.CASE.name()).description("Case sensitive match criteria").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.STARTS.name()).description("Starts with criteria, case sensitive").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.STARTS_.name()).description("Starts with criteria, case insensitive").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.ENDS.name()).description("Ends with criteria, case sensitive").type(this.getAttributeInputType(attribute)).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.ENDS_.name()).description("Ends with criteria, case insensitive").type(this.getAttributeInputType(attribute)).build());
            } else if (attribute.getJavaMember().getClass().isAssignableFrom(Field.class) && ((Field)Field.class.cast(attribute.getJavaMember())).isAnnotationPresent(Convert.class)) {
                builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.LOCATE.name()).description("Locate search criteria").type(this.getAttributeInputType(attribute)).build());
            }
        }
        builder.field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.IS_NULL.name()).description("Is Null criteria").type((GraphQLInputType)Scalars.GraphQLBoolean).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.NOT_NULL.name()).description("Is Not Null criteria").type((GraphQLInputType)Scalars.GraphQLBoolean).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.IN.name()).description("In criteria").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getAttributeInputType(attribute))).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.NIN.name()).description("Not In criteria").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getAttributeInputType(attribute))).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.BETWEEN.name()).description("Between criteria").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getAttributeInputType(attribute))).build()).field(GraphQLInputObjectField.newInputObjectField().name(PredicateFilter.Criteria.NOT_BETWEEN.name()).description("Not Between criteria").type((GraphQLInputType)new GraphQLList((GraphQLType)this.getAttributeInputType(attribute))).build());
        GraphQLInputObjectType answer = builder.build();
        this.whereAttributesMap.putIfAbsent(type, (GraphQLInputType)answer);
        return answer;
    }

    private GraphQLArgument getArgument(Attribute<?, ?> attribute) {
        GraphQLInputType type = this.getAttributeInputTypeForSearchByIdArg(attribute);
        String description = this.getSchemaDescription(attribute);
        return GraphQLArgument.newArgument().name(attribute.getName()).type(type).description(description).build();
    }

    private GraphQLType getEmbeddableType(EmbeddableType<?> embeddableType, boolean input, boolean searchByIdArg) {
        GraphQLInputObjectType graphQLType;
        if (input) {
            if (searchByIdArg) {
                if (this.embeddableInputCache.containsKey(embeddableType.getJavaType())) {
                    return (GraphQLType)this.embeddableInputCache.get(embeddableType.getJavaType());
                }
                GraphQLInputObjectType graphQLType2 = GraphQLInputObjectType.newInputObject().name(this.namingStrategy.singularize(embeddableType.getJavaType().getSimpleName()) + "InputEmbeddableIdType").description(this.getSchemaDescription(embeddableType)).fields(embeddableType.getAttributes().stream().filter(this::isNotIgnored).map(this::getInputObjectField).collect(Collectors.toList())).build();
                this.embeddableInputCache.put(embeddableType.getJavaType(), graphQLType2);
                return graphQLType2;
            }
            graphQLType = this.getWhereInputType((ManagedType<?>)embeddableType);
        } else {
            if (this.embeddableOutputCache.containsKey(embeddableType.getJavaType())) {
                return (GraphQLType)this.embeddableOutputCache.get(embeddableType.getJavaType());
            }
            String embeddableTypeName = this.singularize.andThen(this.queryEmbeddableTypeNameCustomizer).apply(embeddableType.getJavaType().getSimpleName());
            graphQLType = GraphQLObjectType.newObject().name(embeddableTypeName).description(this.getSchemaDescription(embeddableType)).fields(embeddableType.getAttributes().stream().filter(this::isNotIgnored).map(this::getObjectField).collect(Collectors.toList())).build();
            this.embeddableOutputCache.putIfAbsent(embeddableType.getJavaType(), (GraphQLObjectType)graphQLType);
        }
        return graphQLType;
    }

    private GraphQLObjectType getEntityObjectType(EntityType<?> entityType) {
        return this.entityCache.computeIfAbsent(entityType, this::computeEntityObjectType);
    }

    private String resolveEntityObjectTypeName(EntityType<?> entityType) {
        String entityTypeName = this.resolveManagedTypeName((ManagedType<?>)entityType);
        return this.singularize.andThen(this.queryResultTypeNameCustomizer).apply(entityTypeName);
    }

    private GraphQLObjectType computeEntityObjectType(EntityType<?> entityType) {
        String typeName = this.resolveEntityObjectTypeName(entityType);
        return GraphQLObjectType.newObject().name(typeName).description(this.getSchemaDescription(entityType)).fields(this.getEntityAttributesFields(entityType)).fields(this.getTransientFields((ManagedType<?>)entityType)).build();
    }

    private List<GraphQLFieldDefinition> getEntityAttributesFields(EntityType<?> entityType) {
        return entityType.getAttributes().stream().filter(attribute -> EntityIntrospector.introspect(entityType).isNotIgnored(attribute.getName())).map(it -> this.getObjectField((Attribute)it, (EntityType)entityType)).collect(Collectors.toList());
    }

    private List<GraphQLFieldDefinition> getTransientFields(ManagedType<?> managedType) {
        return EntityIntrospector.introspect(managedType).getTransientPropertyDescriptors().stream().filter(EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor::isNotIgnored).map(this::getJavaFieldDefinition).collect(Collectors.toList());
    }

    private GraphQLFieldDefinition getJavaFieldDefinition(EntityIntrospector.EntityIntrospectionResult.AttributePropertyDescriptor propertyDescriptor) {
        GraphQLOutputType type = this.getGraphQLTypeFromJavaType(propertyDescriptor.getPropertyType());
        PropertyDataFetcher dataFetcher = PropertyDataFetcher.fetching((String)propertyDescriptor.getName());
        String description = propertyDescriptor.getSchemaDescription().orElse(null);
        return GraphQLFieldDefinition.newFieldDefinition().name(propertyDescriptor.getName()).description(description).type(type).dataFetcher((DataFetcher)dataFetcher).build();
    }

    private GraphQLFieldDefinition getObjectField(Attribute<?, ?> attribute) {
        return this.getObjectField(attribute, null);
    }

    private GraphQLFieldDefinition getObjectField(Attribute attribute, EntityType baseEntity) {
        GraphQLOutputType type = this.getAttributeOutputType(attribute);
        ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        Object dataFetcher = PropertyDataFetcher.fetching((String)attribute.getName());
        if (this.isBasic(attribute) && this.isNotIgnoredOrder(attribute)) {
            arguments.add(GraphQLArgument.newArgument().name(ORDER_BY_PARAM_NAME).description("Specifies field sort direction in the query results.").type((GraphQLInputType)orderByDirectionEnum).defaultValue((Object)"ASC").build());
        }
        if (this.isSingular(attribute)) {
            ManagedType<?> foreignType = this.getForeignType(attribute);
            SingularAttribute singularAttribute = (SingularAttribute)SingularAttribute.class.cast(attribute);
            arguments.add(this.getWhereArgument(foreignType));
            arguments.add(this.optionalArgument(singularAttribute.isOptional()));
            GraphQLObjectType entityObjectType = GraphQLObjectType.newObject().name(this.resolveEntityObjectTypeName(baseEntity)).build();
            GraphQLJpaQueryFactory graphQLJpaQueryFactory = GraphQLJpaQueryFactory.builder().withEntityManager(this.entityManager).withEntityType(baseEntity).withGraphQLObjectTypeMetadata(this.graphQLObjectTypeMetadata).withEntityObjectType(entityObjectType).withSelectNodeName(baseEntity.getName()).withDefaultDistinct(this.isDefaultDistinct).withRestrictedKeysProvider(this.restrictedKeysProvider).withResultStream(this.enableResultStream).build();
            String dataLoaderKey = entityObjectType.getName() + "." + attribute.getName();
            GraphQLJpaToOneMappedBatchLoader mappedBatchLoader = new GraphQLJpaToOneMappedBatchLoader(graphQLJpaQueryFactory);
            this.batchLoadersRegistry.get();
            BatchLoaderRegistry.registerToOne(dataLoaderKey, mappedBatchLoader);
            dataFetcher = new GraphQLJpaToOneDataFetcher(graphQLJpaQueryFactory, (SingularAttribute<Object, Object>)((SingularAttribute)attribute));
        } else if (this.isPlural(attribute)) {
            Assert.assertNotNull((Object)baseEntity, () -> "For attribute " + attribute.getName() + " cannot find declaring type!");
            EntityType elementType = (EntityType)((PluralAttribute)attribute).getElementType();
            arguments.add(this.getWhereArgument((ManagedType<?>)elementType));
            arguments.add(this.optionalArgument(this.toManyDefaultOptional));
            GraphQLObjectType entityObjectType = GraphQLObjectType.newObject().name(this.resolveEntityObjectTypeName(baseEntity)).build();
            GraphQLJpaQueryFactory graphQLJpaQueryFactory = GraphQLJpaQueryFactory.builder().withEntityManager(this.entityManager).withEntityType(baseEntity).withGraphQLObjectTypeMetadata(this.graphQLObjectTypeMetadata).withEntityObjectType(entityObjectType).withSelectNodeName(baseEntity.getName()).withDefaultDistinct(this.isDefaultDistinct).withRestrictedKeysProvider(this.restrictedKeysProvider).withResultStream(this.enableResultStream).build();
            String dataLoaderKey = entityObjectType.getName() + "." + attribute.getName();
            GraphQLJpaToManyMappedBatchLoader mappedBatchLoader = new GraphQLJpaToManyMappedBatchLoader(graphQLJpaQueryFactory);
            this.batchLoadersRegistry.get();
            BatchLoaderRegistry.registerToMany(dataLoaderKey, mappedBatchLoader);
            dataFetcher = new GraphQLJpaToManyDataFetcher(graphQLJpaQueryFactory, (PluralAttribute<Object, Object, Object>)((PluralAttribute)attribute));
        }
        return GraphQLFieldDefinition.newFieldDefinition().name(attribute.getName()).description(this.getSchemaDescription(attribute)).type(type).dataFetcher((DataFetcher)dataFetcher).arguments(arguments).build();
    }

    private GraphQLArgument optionalArgument(Boolean defaultValue) {
        return GraphQLArgument.newArgument().name("optional").description("Optional association specification").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)defaultValue).build();
    }

    protected ManagedType<?> getForeignType(Attribute<?, ?> attribute) {
        if (SingularAttribute.class.isInstance(attribute)) {
            return (ManagedType)((SingularAttribute)attribute).getType();
        }
        return (EntityType)((PluralAttribute)attribute).getElementType();
    }

    private GraphQLInputObjectField getInputObjectField(Attribute attribute) {
        GraphQLInputType type = this.getAttributeInputType(attribute);
        return GraphQLInputObjectField.newInputObjectField().name(attribute.getName()).description(this.getSchemaDescription(attribute)).type(type).build();
    }

    private Stream<Attribute<?, ?>> findBasicAttributes(Collection<Attribute<?, ?>> attributes) {
        return attributes.stream().filter(it -> it.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC);
    }

    private GraphQLInputType getAttributeInputType(Attribute<?, ?> attribute) {
        return this.getAttributeInputType(attribute, false);
    }

    private GraphQLInputType getAttributeInputTypeForSearchByIdArg(Attribute<?, ?> attribute) {
        return this.getAttributeInputType(attribute, true);
    }

    private GraphQLInputType getAttributeInputType(Attribute<?, ?> attribute, boolean searchByIdArgType) {
        try {
            return (GraphQLInputType)this.getAttributeType(attribute, true, searchByIdArgType);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Attribute " + String.valueOf(attribute) + " cannot be mapped as an Input Argument");
        }
    }

    private GraphQLOutputType getAttributeOutputType(Attribute<?, ?> attribute) {
        try {
            return (GraphQLOutputType)this.getAttributeType(attribute, false, false);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Attribute " + String.valueOf(attribute) + " cannot be mapped as an Output Argument");
        }
    }

    protected GraphQLType getAttributeType(Attribute<?, ?> attribute, boolean input, boolean searchByIdArgType) {
        if (this.isBasic(attribute)) {
            return searchByIdArgType && this.isGraphQLIDType() ? Scalars.GraphQLID : this.getGraphQLTypeFromJavaType(attribute.getJavaType());
        }
        if (this.isEmbeddable(attribute)) {
            EmbeddableType embeddableType = (EmbeddableType)((SingularAttribute)attribute).getType();
            return this.getEmbeddableType(embeddableType, input, searchByIdArgType);
        }
        if (this.isToMany(attribute)) {
            EntityType foreignType = (EntityType)((PluralAttribute)attribute).getElementType();
            return input ? this.getWhereInputType((ManagedType<?>)foreignType) : new GraphQLList((GraphQLType)new GraphQLTypeReference(this.resolveEntityObjectTypeName(foreignType)));
        }
        if (this.isToOne(attribute)) {
            EntityType foreignType = (EntityType)((SingularAttribute)attribute).getType();
            return input ? this.getWhereInputType((ManagedType<?>)foreignType) : new GraphQLTypeReference(this.resolveEntityObjectTypeName(foreignType));
        }
        if (this.isElementCollection(attribute)) {
            Type foreignType = ((PluralAttribute)attribute).getElementType();
            if (foreignType.getPersistenceType() == Type.PersistenceType.BASIC) {
                GraphQLOutputType graphQLType = this.getGraphQLTypeFromJavaType(foreignType.getJavaType());
                return input ? graphQLType : new GraphQLList((GraphQLType)graphQLType);
            }
            if (foreignType.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                EmbeddableType embeddableType = (EmbeddableType)EmbeddableType.class.cast(foreignType);
                GraphQLType graphQLType = this.getEmbeddableType(embeddableType, input, searchByIdArgType);
                return input ? graphQLType : new GraphQLList(graphQLType);
            }
        }
        String declaringType = attribute.getDeclaringType().getJavaType().getName();
        String declaringMember = attribute.getJavaMember().getName();
        throw new UnsupportedOperationException("Attribute could not be mapped to GraphQL: field '" + declaringMember + "' of entity class '" + declaringType + "'");
    }

    protected final boolean isEmbeddable(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
    }

    protected final boolean isBasic(Attribute<?, ?> attribute) {
        return attribute instanceof SingularAttribute && attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC;
    }

    protected final boolean isElementCollection(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    protected final boolean isToMany(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY;
    }

    protected final boolean isOneToMany(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY;
    }

    protected final boolean isToOne(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    private boolean isPlural(Attribute<?, ?> attribute) {
        return attribute instanceof PluralAttribute && (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY);
    }

    private boolean isSingular(Attribute<?, ?> attribute) {
        return attribute instanceof SingularAttribute && attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC;
    }

    protected final boolean isValidInput(Attribute<?, ?> attribute) {
        return attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.BASIC || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
    }

    private String getSchemaDescription(Attribute<?, ?> attribute) {
        return EntityIntrospector.introspect(attribute.getDeclaringType()).getSchemaDescription(attribute.getName()).orElse(null);
    }

    private String getSchemaDescription(EntityType<?> entityType) {
        return EntityIntrospector.introspect(entityType).getSchemaDescription().orElse(null);
    }

    private String getSchemaDescription(EmbeddableType<?> embeddableType) {
        return EntityIntrospector.introspect(embeddableType).getSchemaDescription().orElse(null);
    }

    private boolean isNotIgnored(EmbeddableType<?> attribute) {
        return this.isNotIgnored(attribute.getJavaType());
    }

    private boolean isNotIgnored(Attribute<?, ?> attribute) {
        return this.isNotIgnored(attribute.getJavaMember()) && this.isNotIgnored(attribute.getJavaType());
    }

    private boolean isIdentity(Attribute<?, ?> attribute) {
        return attribute instanceof SingularAttribute && ((SingularAttribute)attribute).isId();
    }

    private boolean isNotIgnored(EntityType<?> entityType) {
        return this.isNotIgnored(entityType.getJavaType()) && this.isNotIgnored(entityType.getJavaType().getName());
    }

    private boolean isNotIgnored(String name) {
        return this.entityPaths.isEmpty() || this.entityPaths.stream().anyMatch(prefix -> name.startsWith((String)prefix));
    }

    private boolean isNotIgnored(Member member) {
        return member instanceof AnnotatedElement && this.isNotIgnored((AnnotatedElement)((Object)member));
    }

    private boolean isNotIgnored(AnnotatedElement annotatedElement) {
        return annotatedElement != null && annotatedElement.getAnnotation(GraphQLIgnore.class) == null;
    }

    protected boolean isNotIgnoredFilter(Attribute<?, ?> attribute) {
        return this.isNotIgnoredFilter(attribute.getJavaMember()) && this.isNotIgnoredFilter(attribute.getJavaType());
    }

    protected boolean isNotIgnoredFilter(EntityType<?> entityType) {
        return this.isNotIgnoredFilter(entityType.getJavaType());
    }

    protected boolean isNotIgnoredFilter(Member member) {
        return member instanceof AnnotatedElement && this.isNotIgnoredFilter((AnnotatedElement)((Object)member));
    }

    protected boolean isNotIgnoredFilter(AnnotatedElement annotatedElement) {
        if (annotatedElement != null) {
            GraphQLIgnoreFilter schemaDocumentation = annotatedElement.getAnnotation(GraphQLIgnoreFilter.class);
            return schemaDocumentation == null;
        }
        return false;
    }

    protected boolean isNotIgnoredOrder(Attribute<?, ?> attribute) {
        AnnotatedElement annotatedElement = (AnnotatedElement)((Object)attribute.getJavaMember());
        if (annotatedElement != null) {
            GraphQLIgnoreOrder schemaDocumentation = annotatedElement.getAnnotation(GraphQLIgnoreOrder.class);
            return schemaDocumentation == null;
        }
        return false;
    }

    private GraphQLOutputType getGraphQLTypeFromJavaType(Class<?> clazz) {
        if (clazz.isEnum()) {
            if (this.classCache.containsKey(clazz)) {
                return this.classCache.get(clazz);
            }
            GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(clazz.getSimpleName());
            boolean ordinal = false;
            for (Enum enumValue : (Enum[])clazz.getEnumConstants()) {
                enumBuilder.value(enumValue.name());
            }
            GraphQLEnumType enumType = enumBuilder.build();
            this.classCache.putIfAbsent(clazz, (GraphQLOutputType)enumType);
            return enumType;
        }
        if (clazz.isArray() && !JavaScalars.contains(clazz)) {
            return GraphQLList.list((GraphQLType)JavaScalars.of(clazz.getComponentType()));
        }
        return JavaScalars.of(clazz);
    }

    protected GraphQLInputType getFieldsEnumType(EntityType<?> entityType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(entityType.getName() + "FieldsEnum");
        AtomicInteger ordinal = new AtomicInteger();
        entityType.getAttributes().stream().filter(this::isValidInput).filter(this::isNotIgnored).forEach(it -> enumBuilder.value(it.getName()));
        GraphQLEnumType answer = enumBuilder.build();
        return answer;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public GraphQLJpaSchemaBuilder name(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public GraphQLJpaSchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public GraphQLJpaSchemaBuilder useDistinctParameter(boolean isUseDistinctParameter) {
        this.isUseDistinctParameter = isUseDistinctParameter;
        return this;
    }

    public boolean isDistinctParameter() {
        return this.isUseDistinctParameter;
    }

    public boolean isDistinctFetcher() {
        return this.isDefaultDistinct;
    }

    @Deprecated
    public GraphQLJpaSchemaBuilder setDefaultDistinct(boolean distinctFetcher) {
        this.isDefaultDistinct = distinctFetcher;
        return this;
    }

    public GraphQLJpaSchemaBuilder defaultDistinct(boolean isDefaultDistinct) {
        this.isDefaultDistinct = isDefaultDistinct;
        return this;
    }

    @Deprecated
    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public GraphQLSchemaBuilder enableAggregate(boolean enableAggregate) {
        this.enableAggregate = enableAggregate;
        return this;
    }

    @Override
    public GraphQLJpaSchemaBuilder entityPath(String path) {
        Assert.assertNotNull((Object)path, () -> "path is null");
        this.entityPaths.add(path);
        return this;
    }

    public GraphQLJpaSchemaBuilder queryByIdFieldNameCustomizer(Function<String, String> queryByIdFieldNameCustomizer) {
        this.queryByIdFieldNameCustomizer = queryByIdFieldNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryAllFieldNameCustomizer(Function<String, String> queryAllFieldNameCustomizer) {
        this.queryAllFieldNameCustomizer = queryAllFieldNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryTypeNameCustomizer(Function<String, String> queryTypeNameCustomizer) {
        this.queryTypeNameCustomizer = queryTypeNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryResultTypeNameCustomizer(Function<String, String> queryResultTypeNameCustomizer) {
        this.queryResultTypeNameCustomizer = queryResultTypeNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryWhereArgumentTypeNameCustomizer(Function<String, String> queryWhereArgumentTypeNameCustomizer) {
        this.queryWhereArgumentTypeNameCustomizer = queryWhereArgumentTypeNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryEmbeddableTypeNameCustomizer(Function<String, String> queryEmbeddableTypeNameCustomizer) {
        this.queryEmbeddableTypeNameCustomizer = queryEmbeddableTypeNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder subqueryArgumentTypeNameCustomizer(Function<String, String> subqueryArgumentTypeNameCustomizer) {
        this.subqueryArgumentTypeNameCustomizer = subqueryArgumentTypeNameCustomizer;
        return this;
    }

    public GraphQLJpaSchemaBuilder queryWhereInputTypeNameCustomizer(Function<String, String> queryWhereInputTypeNameCustomizer) {
        this.queryWhereInputTypeNameCustomizer = queryWhereInputTypeNameCustomizer;
        return this;
    }

    @Override
    public GraphQLJpaSchemaBuilder namingStrategy(NamingStrategy instance) {
        Assert.assertNotNull((Object)instance, () -> "instance is null");
        this.namingStrategy = instance;
        return this;
    }

    public boolean isToManyDefaultOptional() {
        return this.toManyDefaultOptional;
    }

    @Deprecated
    public void setToManyDefaultOptional(boolean toManyDefaultOptional) {
        this.toManyDefaultOptional = toManyDefaultOptional;
    }

    public GraphQLJpaSchemaBuilder toManyDefaultOptional(boolean toManyDefaultOptional) {
        this.toManyDefaultOptional = toManyDefaultOptional;
        return this;
    }

    public boolean isEnableSubscription() {
        return this.enableSubscription;
    }

    public GraphQLJpaSchemaBuilder enableSubscription(boolean enableSubscription) {
        this.enableSubscription = enableSubscription;
        return this;
    }

    public boolean isEnableRelay() {
        return this.enableRelay;
    }

    public GraphQLJpaSchemaBuilder enableRelay(boolean enableRelay) {
        this.enableRelay = enableRelay;
        return this;
    }

    public int getDefaultMaxResults() {
        return this.defaultMaxResults;
    }

    public GraphQLJpaSchemaBuilder defaultMaxResults(int defaultMaxResults) {
        this.defaultMaxResults = defaultMaxResults;
        return this;
    }

    public int getDefaultPageLimitSize() {
        return this.defaultPageLimitSize;
    }

    public GraphQLJpaSchemaBuilder defaultPageLimitSize(int defaultPageLimitSize) {
        this.defaultPageLimitSize = defaultPageLimitSize;
        return this;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public GraphQLJpaSchemaBuilder defaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
        return this;
    }

    public boolean isEnableDefaultMaxResults() {
        return this.enableDefaultMaxResults;
    }

    public GraphQLJpaSchemaBuilder enableDefaultMaxResults(boolean enableDefaultMaxResults) {
        this.enableDefaultMaxResults = enableDefaultMaxResults;
        return this;
    }

    public GraphQLJpaSchemaBuilder restrictedKeysProvider(RestrictedKeysProvider restrictedKeysProvider) {
        this.restrictedKeysProvider = restrictedKeysProvider;
        return this;
    }

    public RestrictedKeysProvider getRestrictedKeysProvider() {
        return this.restrictedKeysProvider;
    }

    public boolean isEnableResultStream() {
        return this.enableResultStream;
    }

    public GraphQLJpaSchemaBuilder enableResultStream(boolean enableResultStream) {
        this.enableResultStream = enableResultStream;
        return this;
    }

    @Override
    public GraphQLJpaSchemaBuilder graphQLIDType(boolean graphQLIDType) {
        this.graphQLIDType = graphQLIDType;
        return this;
    }

    public boolean isGraphQLIDType() {
        return this.graphQLIDType;
    }

    final class GraphQLObjectTypeMetadataImpl
    implements GraphQLObjectTypeMetadata {
        GraphQLObjectTypeMetadataImpl() {
        }

        @Override
        public EntityType<?> entity(String objectType) {
            return GraphQLJpaSchemaBuilder.this.entityObjectTypeResolver.apply(objectType);
        }

        @Override
        public EmbeddableType<?> embeddable(String objectType) {
            return GraphQLJpaSchemaBuilder.this.embeddableObjectTypeResolver.apply(objectType);
        }
    }

    static class NoOpCoercing
    implements Coercing<Object, Object> {
        NoOpCoercing() {
        }

        public Object serialize(Object input) {
            return input;
        }

        public Object parseValue(Object input) {
            return input;
        }

        public Object parseLiteral(Object input) {
            return input;
        }
    }
}

