/*
 * Decompiled with CFR 0.152.
 */
package com.introproventures.graphql.jpa.query.schema.impl;

import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaQueryFactory;
import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import jakarta.persistence.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLJpaSimpleDataFetcher
implements DataFetcher<Object> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLJpaSimpleDataFetcher.class);
    private final GraphQLJpaQueryFactory queryFactory;

    private GraphQLJpaSimpleDataFetcher(Builder builder) {
        this.queryFactory = builder.queryFactory;
    }

    public Object get(DataFetchingEnvironment environment) {
        Field field = environment.getField();
        if (!field.getArguments().isEmpty()) {
            try {
                return this.queryFactory.querySingleResult(environment);
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IQueryFactoryStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements IQueryFactoryStage,
    IBuildStage {
        private GraphQLJpaQueryFactory queryFactory;

        private Builder() {
        }

        @Override
        public IBuildStage withQueryFactory(GraphQLJpaQueryFactory queryFactory) {
            this.queryFactory = queryFactory;
            return this;
        }

        @Override
        public GraphQLJpaSimpleDataFetcher build() {
            return new GraphQLJpaSimpleDataFetcher(this);
        }
    }

    public static interface IBuildStage {
        public GraphQLJpaSimpleDataFetcher build();
    }

    public static interface IQueryFactoryStage {
        public IBuildStage withQueryFactory(GraphQLJpaQueryFactory var1);
    }
}

